/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.ControlOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.repository.RepositoriesView;
import org.modelbus.team.eclipse.ui.wizard.FragmentLocationWizard;

public class ControlAction
extends AbstractRepositoryTeamAction {
    private EObject selectedElement;
    protected IRepositoryResource selectedResource;

    @Override
    public boolean isEnabled() {
        EObject eObject;
        IStructuredSelection selection = this.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof EObject && (eObject = (EObject)object).eContainer() != null && eObject.eContainmentFeature().isResolveProxies() && eObject.eResource().getURI().scheme().equals("http")) {
            this.selectedElement = eObject;
            return true;
        }
        return false;
    }

    @Override
    public void runImpl(IAction action) {
        Resource resource = this.selectedElement.eResource();
        URI fragmentURI = EcoreUtil.getURI((EObject)this.selectedElement);
        IRepositoryResource selectedResource = ModelBusUtility.asRepositoryResource((String)resource.getURI().toString(), (boolean)false);
        IRepositoryResource[] resources = new IRepositoryResource[]{selectedResource};
        IRepositoryResource[] commonParents = ModelBusUtility.getCommonParents((IRepositoryResource[])resources);
        FragmentLocationWizard fragmentLocationWizard = new FragmentLocationWizard(selectedResource, this.selectedElement);
        Shell shell = ModelBusTeamUIPlugin.instance().getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fragmentLocationWizard);
        if (wizardDialog.open() == 0) {
            IRepositoryResource fragmentRepositoryResource = fragmentLocationWizard.getDestination();
            String fileName = fragmentLocationWizard.getNewName();
            String fragmentFileLocation = URI.createURI((String)fragmentRepositoryResource.getUrl()).appendSegment(fileName).toString();
            ControlOperation mainOp = new ControlOperation(fragmentURI.toString(), fragmentFileLocation, "TODO: implement control log message", resources);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(commonParents));
            op.add((IActionOperation)new AbstractActionOperation(""){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    ControlAction.this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RepositoriesView view = RepositoriesView.instance();
                            if (view == null) {
                                return;
                            }
                            view.getRepositoryTree().fireEmptySelectionEvent();
                        }
                    });
                }

                public ISchedulingRule getSchedulingRule() {
                    return null;
                }
            });
            this.runScheduled((IActionOperation)op);
        }
    }
}

