/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IRevisionProvider;
import org.modelbus.team.eclipse.core.operation.remote.CreateFolderOperation;
import org.modelbus.team.eclipse.core.operation.remote.SetRevisionAuthorNameOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.panel.remote.CreateFolderPanel;

public class CreateFolderAction
extends AbstractRepositoryTeamAction {
    private final boolean toolbarAction;

    public CreateFolderAction() {
        this.toolbarAction = false;
    }

    public CreateFolderAction(boolean toolbarAction) {
        this.toolbarAction = toolbarAction;
    }

    @Override
    public void runImpl(IAction action) {
        CreateFolderPanel panel = new CreateFolderPanel();
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            if (this.toolbarAction) {
                resources = new IRepositoryResource[]{ModelBusConnector.getRepositoryRoot()};
            }
            String folder = panel.getResourceName();
            String message = panel.getMessage();
            CreateFolderOperation mainOp = new CreateFolderOperation(resources[0], folder, message);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(resources));
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)mainOp, 4L));
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        return this.toolbarAction || resources.length == 1 && resources[0].getSelectedRevision().getKind() == 7;
    }
}

