/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorException;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.remote.CreatePatchOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryModifyWorkspaceAction;
import org.modelbus.team.eclipse.ui.operation.FileToClipboardOperation;
import org.modelbus.team.eclipse.ui.operation.UILoggedOperation;
import org.modelbus.team.eclipse.ui.wizard.CreatePatchRemoteWizard;
import org.modelbus.team.eclipse.ui.wizard.CreatePatchWizard;

public class CreatePatchAction
extends AbstractRepositoryModifyWorkspaceAction {
    @Override
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        CreatePatchWizard wizard = null;
        wizard = resources.length == 1 ? new CreatePatchRemoteWizard(resources[0], true) : new CreatePatchWizard(resources[0].getName(), null, true);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            IRepositoryResource second = resources.length == 1 ? ((CreatePatchRemoteWizard)wizard).getSelectedResource() : resources[1];
            try {
                if (resources[0].getRevision().isGreaterThan(second.getRevision())) {
                    IRepositoryResource tmp = second;
                    second = resources[0];
                    resources[0] = tmp;
                }
                this.runScheduled(CreatePatchAction.getCreatePatchOperation(resources[0], second, wizard));
            }
            catch (ModelBusConnectorException ex) {
                UILoggedOperation.reportError(ModelBusTeamPlugin.instance().getResource("Operation.CreatePatchRemote"), ex);
            }
        }
    }

    public static IActionOperation getCreatePatchOperation(IRepositoryResource first, IRepositoryResource second, CreatePatchWizard wizard) {
        CreatePatchOperation mainOp = new CreatePatchOperation(first, second, wizard.getFileName(), wizard.isRecursive(), wizard.isIgnoreDeleted(), wizard.isProcessBinary(), wizard.isIgnoreAncestry());
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)mainOp);
        switch (wizard.getWriteMode()) {
            case 2: {
                op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{wizard.getTargetFolder()}, 1, RefreshResourcesOperation.REFRESH_CHANGES), new IActionOperation[]{mainOp});
                break;
            }
            case 0: {
                op.add((IActionOperation)new FileToClipboardOperation(wizard.getFileName()), new IActionOperation[]{mainOp});
            }
        }
        return op;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }
}

