/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IRevisionProvider;
import org.modelbus.team.eclipse.core.operation.remote.DeleteResourcesOperation;
import org.modelbus.team.eclipse.core.operation.remote.SetRevisionAuthorNameOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.panel.common.CommentPanel;
import org.modelbus.team.eclipse.ui.repository.RepositoriesView;

public class DeleteAction
extends AbstractRepositoryTeamAction {
    @Override
    public void runImpl(IAction action) {
        CommentPanel commentPanel = new CommentPanel(ModelBusTeamUIPlugin.instance().getResource("DeleteAction.Comment.Title"));
        DefaultDialog dialog = new DefaultDialog(this.getShell(), commentPanel);
        if (dialog.open() == 0) {
            IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            IRepositoryResource[] commonParents = ModelBusUtility.getCommonParents((IRepositoryResource[])resources);
            DeleteResourcesOperation mainOp = new DeleteResourcesOperation(resources, commentPanel.getMessage());
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(commonParents));
            op.add((IActionOperation)new AbstractActionOperation(""){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    DeleteAction.this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RepositoriesView view = RepositoriesView.instance();
                            if (view == null) {
                                return;
                            }
                            view.getRepositoryTree().fireEmptySelectionEvent();
                        }
                    });
                }

                public ISchedulingRule getSchedulingRule() {
                    return null;
                }
            });
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)mainOp, 4L));
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getUrl().equals("") || resources[i].getSelectedRevision().getKind() != 7 || resources[i] instanceof IRepositoryRoot && (((IRepositoryRoot)resources[i]).getKind() == 4 || ((IRepositoryRoot)resources[i]).getKind() == 0)) {
                return false;
            }
            ++i;
        }
        return resources.length > 0;
    }
}

