/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorDescriptor;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.operation.OpenRemoteFileOperation;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFile;

public class OpenFileWithAction
extends AbstractRepositoryTeamAction {
    protected String editorId;
    protected boolean allowsMultiple;

    public OpenFileWithAction() {
        this("org.eclipse.ui.DefaultTextEditor", true);
    }

    public OpenFileWithAction(String editorId, boolean allowsMultiple) {
        this.editorId = editorId;
        this.allowsMultiple = allowsMultiple;
    }

    @Override
    public void runImpl(IAction action) {
        RepositoryFile[] resources = (RepositoryFile[])this.getAdaptedSelection(RepositoryFile.class);
        IRepositoryFile[] files = new IRepositoryFile[resources.length];
        int i = 0;
        while (i < resources.length) {
            files[i] = (IRepositoryFile)resources[i].getRepositoryResource();
            ++i;
        }
        this.runScheduled((IActionOperation)new OpenRemoteFileOperation(files, 3, this.editorId));
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action.getImageDescriptor() == null) {
            IEditorDescriptor descriptor = ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry().findEditor(this.editorId);
            action.setImageDescriptor(descriptor == null ? null : descriptor.getImageDescriptor());
        }
    }

    @Override
    public boolean isEnabled() {
        Object[] items = this.getAdaptedSelection(RepositoryFile.class);
        return this.allowsMultiple ? items.length > 0 : items.length == 1;
    }
}

