/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.operation.OpenRemoteFileOperation;

public class OpenFileWithInplaceAction
extends AbstractRepositoryTeamAction {
    @Override
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        this.runScheduled((IActionOperation)new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)resources[0]}, 2));
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.isEnabled()) {
            IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            action.setImageDescriptor(ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getSystemExternalEditorImageDescriptor(resources[0].getName()));
        } else {
            action.setImageDescriptor(null);
        }
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (resources.length != 1 || !(resources[0] instanceof IRepositoryFile)) {
            return false;
        }
        return ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry().isSystemInPlaceEditorAvailable(resources[0].getName());
    }
}

