/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IRevisionProvider;
import org.modelbus.team.eclipse.core.operation.remote.CopyResourcesOperation;
import org.modelbus.team.eclipse.core.operation.remote.MoveResourcesOperation;
import org.modelbus.team.eclipse.core.operation.remote.SetRevisionAuthorNameOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceProvider;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.RemoteResourceTransfer;
import org.modelbus.team.eclipse.ui.RemoteResourceTransferrable;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.panel.common.CommentPanel;

public class PasteAction
extends AbstractRepositoryTeamAction {
    @Override
    public void runImpl(IAction action) {
        final RemoteResourceTransferrable transferrable = this.getTransferrable();
        CommentPanel commentPanel = new CommentPanel(ModelBusTeamUIPlugin.instance().getResource("PasteAction.Comment.Title"));
        DefaultDialog dialog = new DefaultDialog(this.getShell(), commentPanel);
        if (dialog.open() == 0) {
            this.clearClipboard(transferrable);
            final IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            resources[0] = resources[0] instanceof IRepositoryContainer ? resources[0] : resources[0].getParent();
            CopyResourcesOperation pasteOp = transferrable.operation == 0 ? new CopyResourcesOperation(resources[0], transferrable.resources, commentPanel.getMessage(), null) : new MoveResourcesOperation(resources[0], transferrable.resources, commentPanel.getMessage(), null);
            CompositeOperation op = new CompositeOperation(pasteOp.getId());
            op.add((IActionOperation)pasteOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(new IRepositoryResourceProvider(){

                public IRepositoryResource[] getRepositoryResources() {
                    if (transferrable.operation == 0) {
                        return resources;
                    }
                    HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>(Arrays.asList(resources));
                    fullSet.addAll(Arrays.asList(ModelBusUtility.getCommonParents((IRepositoryResource[])transferrable.resources)));
                    return fullSet.toArray(new IRepositoryResource[fullSet.size()]);
                }
            }));
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)pasteOp, 4L));
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected boolean isSource(IRepositoryResource selectedResource, IRepositoryResource resource) {
        Path selectedUrl = new Path(selectedResource.getUrl());
        return new Path(resource.getUrl()).isPrefixOf((IPath)selectedUrl) || resource.getParent() != null && new Path(resource.getParent().getUrl()).equals((Object)selectedUrl);
    }

    protected RemoteResourceTransferrable getTransferrable() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            RemoteResourceTransferrable transferrable = (RemoteResourceTransferrable)clipboard.getContents((Transfer)new RemoteResourceTransfer());
            if (transferrable == null || transferrable.operation == 255 || transferrable.resources == null || transferrable.resources.length == 0) {
                return null;
            }
            RemoteResourceTransferrable remoteResourceTransferrable = transferrable;
            return remoteResourceTransferrable;
        }
        finally {
            clipboard.dispose();
        }
    }

    protected void clearClipboard(RemoteResourceTransferrable transferrable) {
        if (transferrable.operation == 1) {
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            try {
                clipboard.setContents(new Object[]{new RemoteResourceTransferrable(null, 255)}, new Transfer[]{new RemoteResourceTransfer()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }
}

