/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote.management;

import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.CreateFolderOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.panel.remote.CreateProjectStructurePanel;

public class CreateProjectStructureAction
extends AbstractRepositoryTeamAction {
    private boolean toolbarAction;

    public CreateProjectStructureAction() {
        this.toolbarAction = false;
    }

    public CreateProjectStructureAction(boolean toolbarAction) {
        this.toolbarAction = toolbarAction;
    }

    @Override
    public void runImpl(IAction action) {
        CreateProjectStructurePanel panel = new CreateProjectStructurePanel();
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            String[] stringArray;
            String name = panel.getResourceName();
            IRepositoryResource[] parent = this.getSelectedRepositoryResources();
            if (this.toolbarAction) {
                parent = new IRepositoryResource[]{ModelBusConnector.getRepositoryRoot()};
            }
            IRepositoryRoot cfr_ignored_0 = (IRepositoryRoot)parent[0].getRoot();
            String trunk = ModelBusTeamPlugin.instance().getOptionProvider().getDefaultTrunkName();
            String branches = ModelBusTeamPlugin.instance().getOptionProvider().getDefaultBranchesName();
            String tags = ModelBusTeamPlugin.instance().getOptionProvider().getDefaultTagsName();
            if (name.length() == 0) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = trunk;
                stringArray2[1] = branches;
                stringArray = stringArray2;
                stringArray2[2] = tags;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = String.valueOf(name) + "/" + trunk;
                stringArray3[1] = String.valueOf(name) + "/" + branches;
                stringArray = stringArray3;
                stringArray3[2] = String.valueOf(name) + "/" + tags;
            }
            String[] folders = stringArray;
            CreateFolderOperation mainOp = new CreateFolderOperation(parent[0], folders, panel.getMessage());
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(parent), new IActionOperation[]{mainOp});
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        return this.toolbarAction || resources.length == 1 && resources[0] instanceof IRepositoryContainer;
    }
}

