/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote.management;

import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.modelbus.team.eclipse.core.operation.remote.management.AddRevisionLinkOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceProvider;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.common.InputRevisionPanel;

public class SelectResourceRevisionAction
extends AbstractRepositoryTeamAction {
    @Override
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        this.runImpl(resources);
    }

    protected void runImpl(IRepositoryResource[] resources) {
        ModelBusRevision selectedRevision = null;
        if (resources.length == 1) {
            InputRevisionPanel panel = new InputRevisionPanel(resources[0], ModelBusTeamUIPlugin.instance().getResource("SelectResourceRevisionAction.InputRevisionPanel.Title"));
            DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
            if (dialog.open() == 0) {
                selectedRevision = panel.getSelectedRevision();
                resources[0] = ModelBusUtility.copyOf((IRepositoryResource)resources[0]);
                resources[0].setSelectedRevision(selectedRevision);
            } else {
                return;
            }
        }
        LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(resources);
        AddRevisionLinkOperation mainOp = new AddRevisionLinkOperation((IRepositoryResourceProvider)locateOp, selectedRevision);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)locateOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{locateOp});
        this.runScheduled((IActionOperation)op);
    }

    @Override
    public boolean isEnabled() {
        return false;
    }
}

