/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.annotate;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.internal.text.revisions.RevisionSelectionProvider;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusAnnotationData;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryReference;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.operation.remote.GetResourceAnnotationOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.annotate.BuiltInAnnotateRevision;
import org.modelbus.team.eclipse.ui.annotate.CommitterColors;
import org.modelbus.team.eclipse.ui.annotate.ModelBusTeamQuickDiffProvider;
import org.modelbus.team.eclipse.ui.history.ModelBusHistoryPage;
import org.modelbus.team.eclipse.ui.operation.OpenRemoteFileOperation;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class BuiltInAnnotate {
    protected AbstractDecoratedTextEditor textEditor;
    protected ModelBusHistoryPage historyPage;

    public void open(IWorkbenchPage page, IRepositoryResource remote, IFile resource) {
        GetResourceAnnotationOperation annotateOp = new GetResourceAnnotationOperation(remote);
        annotateOp.setIncludeMerged(ModelBusTeamPreferences.getMergeBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "includeMerged"));
        IActionOperation showOp = this.prepareBuiltInAnnotate(annotateOp, page, remote, resource);
        CompositeOperation op = new CompositeOperation(showOp.getId());
        op.add((IActionOperation)annotateOp);
        op.add(showOp, new IActionOperation[]{annotateOp});
        UIMonitorUtility.doTaskScheduledDefault(page.getActivePart(), (IActionOperation)op);
    }

    protected IActionOperation prepareBuiltInAnnotate(final GetResourceAnnotationOperation annotateOp, final IWorkbenchPage page, final IRepositoryResource remote, final IFile resource) {
        CompositeOperation op = new CompositeOperation("Operation.BuiltInShowAnnotation");
        final RevisionInformation info = new RevisionInformation();
        AbstractActionOperation prepareRevisions = new AbstractActionOperation("Operation.PrepareRevisions"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                HashMap<String, BuiltInAnnotateRevision> revisions = new HashMap<String, BuiltInAnnotateRevision>();
                ModelBusAnnotationData[] data = annotateOp.getAnnotatedLines();
                if (data == null || data.length == 0) {
                    return;
                }
                String noAuthor = ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoAuthor");
                int i = 0;
                while (i < data.length) {
                    String revisionId = data[i].revision;
                    BuiltInAnnotateRevision revision = (BuiltInAnnotateRevision)((Object)revisions.get(revisionId));
                    if (revision == null) {
                        ModelBusRevision modelBusRevision = ModelBusRevision.fromString((String)revisionId);
                        revision = new BuiltInAnnotateRevision(modelBusRevision, data[i].author, CommitterColors.getDefault().getCommitterRGB(data[i].author == null ? noAuthor : data[i].author));
                        revisions.put(revisionId, revision);
                        info.addRevision((Revision)revision);
                    }
                    revision.addLine(i + 1);
                    if (data[i].mergedRevision != "-1" && data[i].mergedRevision != data[i].revision) {
                        revision.addMergeInfo(i + 1, data[i].mergedRevision, data[i].mergedDate, data[i].mergedAuthor == null ? noAuthor : data[i].mergedAuthor, data[i].mergedPath);
                    }
                    ++i;
                }
                ModelBusRevision from = ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
                ModelBusRevision to = ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
                for (BuiltInAnnotateRevision revision : revisions.values()) {
                    revision.addLine(-1);
                    if (from.isGreaterThan(revision.getRevision()) || from == ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
                        from = revision.getRevision();
                    }
                    if (!to.isLowerThan(revision.getRevision())) continue;
                    to = revision.getRevision();
                }
                IRepositoryResource resource = annotateOp.getRepositoryResource();
                IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
                ModelBusLogEntry[] msgs = ModelBusUtility.logEntries((IModelBusConnector)proxy, (ModelBusEntryReference)ModelBusUtility.getEntryReference((IRepositoryResource)resource), (ModelBusRevision)to, (ModelBusRevision)from, (long)0L, (String[])IModelBusConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)this, monitor, null));
                int i2 = 0;
                while (i2 < msgs.length) {
                    BuiltInAnnotateRevision revision = (BuiltInAnnotateRevision)((Object)revisions.get(msgs[i2].revision));
                    if (revision != null) {
                        revision.setLogMessage(msgs[i2]);
                    }
                    ++i2;
                }
            }
        };
        op.add((IActionOperation)prepareRevisions, new IActionOperation[]{annotateOp});
        AbstractActionOperation attachMessages = new AbstractActionOperation("Operation.BuiltInShowView"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                page.getActivePart().getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BuiltInAnnotate.this.initializeEditor(page, remote, resource, info);
                        }
                        catch (PartInitException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }
        };
        op.add((IActionOperation)attachMessages, new IActionOperation[]{annotateOp, prepareRevisions});
        return op;
    }

    protected void initializeEditor(final IWorkbenchPage page, IRepositoryResource remote, IFile resource, RevisionInformation info) throws PartInitException {
        IEditorPart editor;
        IEditorPart iEditorPart = editor = resource != null ? this.openEditor(page, resource) : this.openEditor(page, remote);
        if (editor instanceof AbstractDecoratedTextEditor) {
            this.textEditor = (AbstractDecoratedTextEditor)editor;
            final ISelectionProvider provider = (ISelectionProvider)this.textEditor.getAdapter(RevisionSelectionProvider.class);
            if (provider != null) {
                final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        BuiltInAnnotateRevision selected;
                        if (event.getSelection() instanceof IStructuredSelection && (selected = (BuiltInAnnotateRevision)((Object)((IStructuredSelection)event.getSelection()).getFirstElement())) != null && BuiltInAnnotate.this.historyPage != null) {
                            BuiltInAnnotate.this.historyPage.selectRevision(selected.getId());
                        }
                    }
                };
                provider.addSelectionChangedListener(selectionListener);
                page.addPartListener(new IPartListener(){

                    public void partClosed(IWorkbenchPart part) {
                        if (part instanceof IHistoryView || part == BuiltInAnnotate.this.textEditor) {
                            page.removePartListener((IPartListener)this);
                            provider.removeSelectionChangedListener(selectionListener);
                        }
                    }

                    public void partActivated(IWorkbenchPart part) {
                    }

                    public void partBroughtToTop(IWorkbenchPart part) {
                    }

                    public void partDeactivated(IWorkbenchPart part) {
                    }

                    public void partOpened(IWorkbenchPart part) {
                    }
                });
            }
            this.textEditor.showRevisionInformation(info, ModelBusTeamQuickDiffProvider.class.getName());
        }
    }

    protected IEditorPart openEditor(IWorkbenchPage page, IRepositoryResource remote) throws PartInitException {
        IEditorPart part;
        OpenRemoteFileOperation op = new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)remote}, 0);
        op.setRequiredDefaultEditorKind(AbstractDecoratedTextEditor.class);
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
        if (op.getExecutionState() == 0 && (part = op.getEditors()[0]) instanceof AbstractDecoratedTextEditor) {
            return part;
        }
        return null;
    }

    protected IEditorPart openEditor(IWorkbenchPage page, IFile resource) throws PartInitException {
        IEditorPart part = ResourceUtil.findEditor((IWorkbenchPage)page, (IFile)resource);
        if (part != null && part instanceof AbstractDecoratedTextEditor) {
            page.activate((IWorkbenchPart)part);
            return part;
        }
        return IDE.openEditor((IWorkbenchPage)page, (IFile)resource, (String)"org.eclipse.ui.DefaultTextEditor");
    }
}

