/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.compare;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.RemoteResourceTypedElement;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusRepositorySubscriber;
import org.modelbus.team.eclipse.repository.subscriber.ModelBusThreeWaySynchronizer;

public class ModelBusCompareEditorInput
extends CompareEditorInput {
    IResource local;
    RepositoryProvider provider;
    String revision;

    public ModelBusCompareEditorInput(CompareConfiguration configuration, RepositoryProvider provider, IResource local, String revision) {
        super(configuration);
        this.local = local;
        this.provider = provider;
        this.revision = revision;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RemoteResourceTypedElement ancestor = null;
        LocalResourceTypedElement left = null;
        RemoteResourceTypedElement right = null;
        IResourceVariant ancestorVariant = null;
        IResourceVariant remoteVariant = null;
        try {
            if (this.provider instanceof ModelBusRepositoryProvider) {
                ModelBusRepositoryProvider modelBusRepositoryProvider = (ModelBusRepositoryProvider)this.provider;
                ModelBusThreeWaySynchronizer synchronizer = (ModelBusThreeWaySynchronizer)ModelBusRepositorySubscriber.getInstance().getSynchronizer();
                String workingCopyRevision = synchronizer.getWorkingCopyRevision(this.local);
                if (!"-2".equals(workingCopyRevision)) {
                    ancestorVariant = modelBusRepositoryProvider.getResourceVariant(this.local, workingCopyRevision);
                    if (!"-2".equals(this.revision)) {
                        remoteVariant = modelBusRepositoryProvider.getResourceVariant(this.local, this.revision);
                    }
                }
            }
        }
        catch (RepositoryAuthentificationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (NonExistingResourceException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (TeamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvalidRevisionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        String encoding = null;
        if (this.local instanceof IEncodedStorage) {
            IEncodedStorage es = (IEncodedStorage)this.local;
            try {
                encoding = es.getCharset();
            }
            catch (CoreException coreException) {}
        }
        if (ancestorVariant != null) {
            ancestor = new RemoteResourceTypedElement(ancestorVariant, encoding);
            left = new LocalResourceTypedElement(this.local);
            if (remoteVariant == null) {
                right = ancestor;
                ancestor = null;
            } else {
                right = new RemoteResourceTypedElement(remoteVariant, encoding);
            }
            Differencer d = new Differencer();
            Object object = d.findDifferences(true, monitor, null, (Object)ancestor, (Object)left, (Object)right);
            return object;
        }
        return null;
    }
}

