/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeSelection;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.local.SetPropertyAction;
import org.modelbus.team.eclipse.ui.compare.PropertyCompareInput;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.properties.ResourcePropertyEditPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class ThreeWayPropertyCompareInput
extends PropertyCompareInput {
    protected String baseRevision;
    protected IResource leftResource;

    public ThreeWayPropertyCompareInput(CompareConfiguration configuration, IResource left, ModelBusEntryRevisionReference right, ModelBusEntryRevisionReference ancestor, String baseRevisionNumber) {
        super(configuration, new ModelBusEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)left), null, ModelBusRevision.WORKING), right, ancestor);
        this.baseRevision = baseRevisionNumber;
        this.leftResource = left;
    }

    @Override
    protected void fillMenu(IMenuManager manager, TreeSelection selection) {
        final PropertyCompareInput.PropertyCompareNode selectedNode = (PropertyCompareInput.PropertyCompareNode)((Object)selection.getFirstElement());
        Action tAction = null;
        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("SetPropertyAction.label")){

            public void run() {
                IResource[] resources = new IResource[]{ThreeWayPropertyCompareInput.this.leftResource};
                ResourcePropertyEditPanel panel = new ResourcePropertyEditPanel(null, resources, false);
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                if (dialog.open() == 0) {
                    SetPropertyAction.doSetProperty(resources, panel, null);
                    boolean notContained = true;
                    PropertyCompareInput.RootCompareNode root = (PropertyCompareInput.RootCompareNode)((Object)ThreeWayPropertyCompareInput.this.getCompareResult());
                    IDiffElement[] nodes = root.getChildren();
                    int i = 0;
                    while (i < nodes.length) {
                        PropertyCompareInput.PropertyCompareNode current = (PropertyCompareInput.PropertyCompareNode)nodes[i];
                        if (current.getName().equals(panel.getPropertyName())) {
                            notContained = false;
                            ((PropertyCompareInput.PropertyElement)current.getLeft()).setValue(panel.getPropertyValue());
                            current.setKind(ThreeWayPropertyCompareInput.this.calculateDifference(panel.getPropertyValue(), ((PropertyCompareInput.PropertyElement)current.getRight()).getValue(), ((PropertyCompareInput.PropertyElement)current.getAncestor()).getValue()));
                            current.fireChange();
                        }
                        ++i;
                    }
                    if (notContained) {
                        new PropertyCompareInput.PropertyCompareNode((IDiffContainer)root, ThreeWayPropertyCompareInput.this.calculateDifference(panel.getPropertyValue(), null, null), new PropertyCompareInput.PropertyElement(panel.getPropertyName(), null, false), new PropertyCompareInput.PropertyElement(panel.getPropertyName(), panel.getPropertyValue(), true), new PropertyCompareInput.PropertyElement(panel.getPropertyName(), null, false));
                    }
                    ThreeWayPropertyCompareInput.this.viewer.refresh();
                }
            }
        };
        manager.add((IAction)tAction);
        tAction.setEnabled(true);
        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("RemovePropertyAction.label")){

            public void run() {
                ThreeWayPropertyCompareInput.this.removeProperty(selectedNode);
            }
        };
        manager.add((IAction)tAction);
        tAction.setEnabled(((PropertyCompareInput.PropertyElement)selectedNode.getLeft()).getValue() != null);
    }

    protected void removeProperty(PropertyCompareInput.PropertyCompareNode currentNode) {
        final String propName = currentNode.getName();
        AbstractActionOperation op = null;
        op = new AbstractActionOperation("Operation.RemoveProperties"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
                proxy.removeProperty(ThreeWayPropertyCompareInput.this.left.path, propName, 0, null, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)this, monitor, null));
            }
        };
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
        if (op.getExecutionState() != 0) {
            return;
        }
        if ((currentNode.getKind() & 3) == 1 && (currentNode.getKind() & 0xC) == 4) {
            ((PropertyCompareInput.RootCompareNode)((Object)this.getCompareResult())).remove((IDiffElement)currentNode);
        } else {
            ((PropertyCompareInput.PropertyElement)currentNode.getLeft()).setValue(null);
            currentNode.setKind(this.calculateDifference(null, ((PropertyCompareInput.PropertyElement)currentNode.getRight()).getValue(), ((PropertyCompareInput.PropertyElement)currentNode.getAncestor()).getValue()));
        }
        currentNode.fireChange();
        this.viewer.refresh();
    }

    public String getTitle() {
        return ModelBusTeamUIPlugin.instance().getResource("PropertyCompareInput.Title3", new String[]{String.valueOf(this.left.path.substring(this.left.path.lastIndexOf("/") + 1)) + " [" + this.getRevisionPart(this.left), this.getRevisionPart(this.ancestor), String.valueOf(this.getRevisionPart(this.right)) + "] "});
    }

    @Override
    protected String getRevisionPart(ModelBusEntryRevisionReference reference) {
        if (reference.revision == ModelBusRevision.WORKING) {
            return ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.LocalSign");
        }
        if (reference.revision == ModelBusRevision.BASE) {
            if (this.ancestor == null) {
                return ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.ResourceIsNotAvailable");
            }
            return ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.BaseSign", new String[]{String.valueOf(this.baseRevision)});
        }
        return ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.RevisionSign", new String[]{String.valueOf(reference.revision)});
    }
}

