/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.compare;

import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusDiffStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusLocalResource;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRepositoryResource;
import org.modelbus.team.eclipse.core.resource.ILocalFile;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.compare.PropertyComparePanel;
import org.modelbus.team.eclipse.ui.compare.ResourceCompareInput;
import org.modelbus.team.eclipse.ui.compare.ThreeWayPropertyCompareInput;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.UILoggedOperation;
import org.modelbus.team.eclipse.ui.utility.OverlayedImageDescriptor;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class ThreeWayResourceCompareInput
extends ResourceCompareInput {
    protected ILocalResource local;
    protected Collection<ModelBusDiffStatus> localChanges;
    protected Collection<ModelBusDiffStatus> remoteChanges;

    public ThreeWayResourceCompareInput(CompareConfiguration configuration, ILocalResource local, IRepositoryResource ancestor, IRepositoryResource remote, Collection<ModelBusDiffStatus> localChanges, Collection<ModelBusDiffStatus> remoteChanges) {
        super(configuration);
        this.local = local;
        this.localChanges = localChanges;
        this.remoteChanges = remoteChanges;
        this.rootLeft = ModelBusRemoteStorage.instance().asRepositoryResource(this.local.getResource());
        this.rootLeft.setSelectedRevision(ModelBusRevision.WORKING);
        this.rootAncestor = ancestor;
        this.rootRight = remote;
    }

    @Override
    protected void fillMenu(IMenuManager manager, TreeSelection selection) {
        final CompareNode selectedNode = (CompareNode)((Object)selection.getFirstElement());
        Action tAction = null;
        boolean propertyComparisonAllowed = true;
        propertyComparisonAllowed = (selectedNode.getKind() & 0xC) == 12 ? (selectedNode.getKind() & 3) != 2 : (selectedNode.getKind() & 3) == 3;
        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("SynchronizeActionGroup.CompareProperties")){

            public void run() {
                ResourceCompareInput.ResourceElement element = (ResourceCompareInput.ResourceElement)selectedNode.getLeft();
                ModelBusLocalResource local = (ModelBusLocalResource)element.getLocalResource();
                IResource left = local.getResource();
                element = (ResourceCompareInput.ResourceElement)selectedNode.getAncestor();
                ModelBusEntryRevisionReference baseReference = null;
                ModelBusRevision baseRevNum = local.getBaseRevision();
                ModelBusRepositoryResource repoResource = (ModelBusRepositoryResource)element.getRepositoryResource();
                baseReference = repoResource.getSelectedRevision().getKind() == ModelBusRevision.BASE.getKind() ? new ModelBusEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)local.getResource()), null, ModelBusRevision.BASE) : new ModelBusEntryRevisionReference(repoResource.getUrl(), repoResource.getPegRevision(), repoResource.getSelectedRevision());
                element = (ResourceCompareInput.ResourceElement)selectedNode.getRight();
                ModelBusEntryRevisionReference rightReference = null;
                repoResource = (ModelBusRepositoryResource)element.getRepositoryResource();
                rightReference = repoResource.getSelectedRevision().getKind() == ModelBusRevision.BASE.getKind() ? new ModelBusEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)local.getResource()), null, ModelBusRevision.BASE) : new ModelBusEntryRevisionReference(repoResource.getUrl(), repoResource.getPegRevision(), repoResource.getSelectedRevision());
                ThreeWayPropertyCompareInput input = new ThreeWayPropertyCompareInput(new CompareConfiguration(), left, rightReference, baseReference, baseRevNum.getRevision());
                try {
                    input.run((IProgressMonitor)new NullProgressMonitor());
                    if (input.getCompareResult() == null) {
                        MessageDialog dialog = new MessageDialog(UIMonitorUtility.getShell(), ModelBusTeamUIPlugin.instance().getResource("ComparePropsNoDiff.Title"), null, ModelBusTeamUIPlugin.instance().getResource("ComparePropsNoDiff.Message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                        dialog.open();
                    } else {
                        PropertyComparePanel panel = new PropertyComparePanel(input, true);
                        DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                        dlg.open();
                    }
                }
                catch (Exception ex) {
                    UILoggedOperation.reportError("Compare Properties Operation", ex);
                }
            }
        };
        manager.add((IAction)tAction);
        tAction.setEnabled(propertyComparisonAllowed && selection.size() == 1);
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws Exception {
        ModelBusDiffStatus status;
        HashMap<String, ModelBusDiffStatus> localChanges = new HashMap<String, ModelBusDiffStatus>();
        HashMap<String, ModelBusDiffStatus> remoteChanges = new HashMap<String, ModelBusDiffStatus>();
        HashSet<String> allChangesSet = new HashSet<String>();
        Iterator<ModelBusDiffStatus> it = this.localChanges.iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            status = it.next();
            allChangesSet.add(status.pathPrev);
            localChanges.put(status.pathPrev, status);
        }
        it = this.remoteChanges.iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            status = it.next();
            String localPath = this.getLocalPath(ModelBusUtility.decodeURL((String)status.pathPrev), this.rootAncestor);
            allChangesSet.add(localPath);
            remoteChanges.put(localPath, status);
        }
        Object[] allChanges = allChangesSet.toArray(new String[allChangesSet.size()]);
        Arrays.sort(allChanges);
        HashMap<IPath, IDiffElement> path2node = new HashMap<IPath, IDiffElement>();
        String message = ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.CheckingDelta");
        int i = 0;
        while (i < allChanges.length && !monitor.isCanceled()) {
            monitor.subTask(MessageFormat.format(message, allChanges[i]));
            this.makeBranch((String)allChanges[i], (ModelBusDiffStatus)localChanges.get(allChanges[i]), (ModelBusDiffStatus)remoteChanges.get(allChanges[i]), path2node, monitor);
            ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)allChanges.length);
            ++i;
        }
        if (!monitor.isCanceled()) {
            this.findRootNode(path2node, this.rootLeft, monitor);
        }
        super.initialize(monitor);
    }

    protected void makeBranch(String localPath, ModelBusDiffStatus stLocal, ModelBusDiffStatus stRemote, final Map path2node, final IProgressMonitor monitor) throws Exception {
        int nodeKind = stLocal == null ? this.getNodeKind(stRemote) : this.getNodeKind(stLocal);
        ILocalResource local = this.getLocalResource(localPath, nodeKind == 1);
        if (!(stRemote == null && IStateFilter.SF_IGNORED.accept(local) || path2node.containsKey(new Path(ModelBusRemoteStorage.instance().asRepositoryResource(local.getResource()).getUrl())))) {
            if (local.isCopied() && IStateFilter.SF_ADDED.accept(local) && !local.getResource().equals((Object)this.local.getResource())) {
                FileUtility.checkForResourcesPresenceRecursive((IResource[])new IResource[]{local.getResource()}, (IStateFilter)new IStateFilter.AbstractStateFilter(){

                    protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                        return !IStateFilter.SF_IGNORED.accept(resource, state, mask) && !IStateFilter.SF_DELETED.accept(resource, state, mask);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                        if (!IStateFilter.SF_DELETED.accept(resource, state, mask)) {
                            local = this.takeLocal(local, resource);
                            String path = FileUtility.getWorkingCopyPath((IResource)resource);
                            ModelBusDiffStatus stLocal = new ModelBusDiffStatus(path, path, resource.getType() == 1 ? 1 : 2, 3, 0);
                            try {
                                CompareNode node = ThreeWayResourceCompareInput.this.makeNode(local, stLocal, null, path2node, monitor);
                                if (node == null) return false;
                                IRepositoryResource remote = ((ResourceCompareInput.ResourceElement)node.getLeft()).getRepositoryResource();
                                path2node.put(new Path(remote.getUrl()), node);
                                return false;
                            }
                            catch (RuntimeException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                        } else {
                            path2node.put(new Path(ModelBusRemoteStorage.instance().asRepositoryResource(resource).getUrl()), null);
                        }
                        return false;
                    }
                });
            } else {
                CompareNode node = this.makeNode(local, stLocal, stRemote, path2node, monitor);
                if (node != null) {
                    IRepositoryResource resource = ((ResourceCompareInput.ResourceElement)node.getLeft()).getRepositoryResource();
                    path2node.put(new Path(resource.getUrl()), node);
                }
            }
        }
    }

    protected CompareNode makeNode(ILocalResource local, ModelBusDiffStatus stLocal, ModelBusDiffStatus stRemote, Map path2node, IProgressMonitor monitor) throws Exception {
        int diffKindRight;
        int diffKindLeft;
        int statusRight;
        int fictiveStatusRight;
        int statusLeft;
        int localNodeKind = local instanceof ILocalFile ? 1 : 2;
        int remoteNodeKind = stRemote == null ? localNodeKind : this.getNodeKind(stRemote);
        boolean useOriginator = this.local.isCopied() && (stLocal != null && stLocal.textStatus != 3 || local.getResource().equals((Object)this.local.getResource()));
        IRepositoryResource[] entries = this.getRepositoryEntries(local, remoteNodeKind, stLocal, stRemote);
        IRepositoryResource left = entries[0];
        IRepositoryResource ancestor = entries[1];
        IRepositoryResource right = entries[2];
        if (!right.exists() && IStateFilter.SF_NOTEXISTS.accept(local)) {
            return null;
        }
        int n = stLocal == null ? 1 : (statusLeft = stLocal.textStatus == 1 ? stLocal.propStatus : stLocal.textStatus);
        if (statusLeft == 4 && localNodeKind == 1 && new File(FileUtility.getWorkingCopyPath((IResource)local.getResource())).exists()) {
            statusLeft = 7;
        }
        int n2 = fictiveStatusRight = useOriginator || statusLeft != 3 && statusLeft != 11 && statusLeft != 0 && statusLeft != 5 ? 1 : 0;
        int n3 = stRemote != null ? (stRemote.textStatus == 1 ? stRemote.propStatus : stRemote.textStatus) : (statusRight = fictiveStatusRight);
        if (stRemote != null && this.rootRight.getUrl().equals(this.rootAncestor.getUrl())) {
            if (this.rootRight.getSelectedRevision().getKind() == 1 && this.local.getRevision().isGreaterThanOrEqual(this.rootRight.getSelectedRevision())) {
                if (!local.getResource().exists() && statusRight == 4 || statusRight != 4 && local.getRevision().equals((Object)right.getRevision())) {
                    return null;
                }
            } else if (local.getRevision().equals((Object)right.getRevision())) {
                if (stLocal == null) {
                    return null;
                }
                stRemote = null;
                statusRight = fictiveStatusRight;
            }
        }
        if ((diffKindLeft = ResourceCompareInput.getDiffKind(statusLeft, stLocal == null ? 0 : stLocal.propStatus)) != 0) {
            diffKindLeft |= 4;
        }
        if ((diffKindRight = ResourceCompareInput.getDiffKind(statusRight, stRemote == null ? 0 : stRemote.propStatus)) != 0) {
            diffKindRight |= 8;
        }
        if ((diffKindRight & 3) == 1 || (diffKindLeft & 3) == 2) {
            left.setSelectedRevision(ModelBusRevision.INVALID_REVISION_DESCRIPTOR);
            ancestor.setSelectedRevision(ModelBusRevision.INVALID_REVISION_DESCRIPTOR);
        }
        if ((diffKindRight & 3) == 2 || (diffKindLeft & 3) == 1) {
            right.setSelectedRevision(ModelBusRevision.INVALID_REVISION_DESCRIPTOR);
        }
        IDiffContainer parent = this.getParentCompareNode(left, path2node);
        return new CompareNode(parent, diffKindLeft | diffKindRight, local, left, ancestor, right, statusLeft, statusRight);
    }

    protected ILocalResource getLocalResource(String path, boolean isFile) {
        IProject resource;
        if (path == null) {
            return ModelBusRemoteStorage.instance().asLocalResource(null);
        }
        IProject project = this.local.getResource().getProject();
        String relative = path.substring(FileUtility.getWorkingCopyPath((IResource)project).length());
        Object object = resource = relative.length() == 0 ? project : project.findMember(relative);
        if (resource == null) {
            resource = isFile ? project.getFile(relative) : project.getFolder(relative);
        }
        return ModelBusRemoteStorage.instance().asLocalResourceAccessible((IResource)resource);
    }

    protected String getLocalPath(String url, IRepositoryResource base) {
        String baseUrl = base.getUrl();
        if (url.length() < baseUrl.length()) {
            return null;
        }
        String delta = url.substring(baseUrl.length());
        String projectPath = FileUtility.getWorkingCopyPath((IResource)this.local.getResource());
        return String.valueOf(projectPath) + delta;
    }

    @Override
    protected IDiffContainer makeStubNode(IDiffContainer parent, IRepositoryResource node) {
        ILocalResource local = this.getLocalResource(this.getLocalPath(node.getUrl(), this.rootLeft), false);
        IRepositoryResource ancestor = node;
        IRepositoryResource remote = node;
        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
            IRepositoryResource[] entries = this.getRepositoryEntries(local, 2, null, null);
            ancestor = entries[1];
            remote = entries[2];
        }
        return new CompareNode(parent, 0, local, node, ancestor, remote, 1, 1);
    }

    protected IRepositoryResource[] getRepositoryEntries(ILocalResource local, int remoteNodeKind, ModelBusDiffStatus stLocal, ModelBusDiffStatus stRemote) {
        IRepositoryResource right;
        IRepositoryResource left = ModelBusRemoteStorage.instance().asRepositoryResource(local.getResource());
        left.setSelectedRevision(ModelBusRevision.WORKING);
        left.setPegRevision(null);
        boolean useOriginator = this.local.isCopied() && (stLocal != null && stLocal.textStatus != 3 || local.getResource().equals((Object)this.local.getResource()));
        IRepositoryResource ancestor = useOriginator ? ModelBusUtility.getCopiedFrom((IResource)local.getResource()) : ModelBusUtility.copyOf((IRepositoryResource)left);
        IRepositoryResource iRepositoryResource = right = useOriginator ? ModelBusUtility.getCopiedFrom((IResource)local.getResource()) : ModelBusUtility.copyOf((IRepositoryResource)left);
        if (stRemote != null) {
            ancestor = this.createResourceFor(remoteNodeKind, ModelBusUtility.decodeURL((String)stRemote.pathPrev));
            right = this.createResourceFor(remoteNodeKind, ModelBusUtility.decodeURL((String)stRemote.pathNext));
        } else if (!this.rootLeft.getUrl().equals(this.rootRight.getUrl()) && left.getUrl().length() >= this.rootLeft.getUrl().length()) {
            String delta = left.getUrl().substring(this.rootLeft.getUrl().length());
            ancestor = this.createResourceFor(remoteNodeKind, String.valueOf(this.rootAncestor.getUrl()) + delta);
            right = this.createResourceFor(remoteNodeKind, String.valueOf(this.rootRight.getUrl()) + delta);
        }
        ancestor.setSelectedRevision(ModelBusRevision.BASE);
        ancestor.setPegRevision(null);
        right.setPegRevision(this.rootRight.getPegRevision());
        right.setSelectedRevision(this.rootRight.getSelectedRevision());
        return new IRepositoryResource[]{left, ancestor, right};
    }

    @Override
    protected boolean isThreeWay() {
        return true;
    }

    @Override
    protected String getLeftLabel() throws Exception {
        ResourceCompareInput.ResourceElement element = this.getLeftResourceElement();
        return String.valueOf(element.getLocalResource().getResource().getFullPath().toString().substring(1)) + " [" + this.getRevisionPart(element) + "]";
    }

    @Override
    protected String getRevisionPart(ResourceCompareInput.ResourceElement element) throws Exception {
        IRepositoryResource resource = element.getRepositoryResource();
        ModelBusRevision selected = resource.getSelectedRevision();
        int kind = selected.getKind();
        if (kind == 6) {
            return ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.LocalSign");
        }
        if (kind == 5) {
            ModelBusRevision revision = element.getLocalResource().getRevision();
            if ("-1".equals(revision)) {
                return ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.ResourceIsNotAvailable");
            }
            return ModelBusTeamUIPlugin.instance().getResource("ResourceCompareInput.BaseSign", new String[]{String.valueOf(revision)});
        }
        return super.getRevisionPart(element);
    }

    @Override
    protected ResourceCompareInput.ResourceCompareViewer createDiffViewerImpl(Composite parent, CompareConfiguration config) {
        return new ResourceCompareInput.ResourceCompareViewer(this, parent, config){

            public void setLabelProvider(IBaseLabelProvider labelProvider) {
                super.setLabelProvider((IBaseLabelProvider)new ResourceCompareInput.ResourceCompareViewer.LabelProviderWrapper(this, (ILabelProvider)labelProvider){

                    @Override
                    public Image getImage(Object element) {
                        if (element instanceof CompareNode && (((CompareNode)((Object)element)).getLocalChangeType() == 7 || ((CompareNode)((Object)element)).getRemoteChangeType() == 7)) {
                            Image image = (Image)this.images.get(element);
                            if (image == null) {
                                OverlayedImageDescriptor imageDescriptor = null;
                                int direction = ((CompareNode)((Object)element)).getKind() & 0xC;
                                imageDescriptor = direction == 4 ? new OverlayedImageDescriptor(this.baseProvider.getImage(element), ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_out.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V) : (direction == 8 ? new OverlayedImageDescriptor(this.baseProvider.getImage(element), ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_in.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V) : new OverlayedImageDescriptor(this.baseProvider.getImage(element), ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_conf.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V));
                                image = imageDescriptor.createImage();
                                this.images.put(element, image);
                            }
                            return image;
                        }
                        return super.getImage(element);
                    }
                });
            }
        };
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.root != null) {
            try {
                pm.beginTask(ModelBusTeamUIPlugin.instance().getResource("ThreeWayResourceCompareInput.SaveChanges"), -1);
                this.saveChanges((CompareNode)this.root, pm);
            }
            finally {
                pm.done();
            }
        }
    }

    protected void saveChanges(CompareNode node, IProgressMonitor pm) throws CoreException {
        IDiffElement[] children;
        ResourceCompareInput.ResourceElement left = (ResourceCompareInput.ResourceElement)node.getLeft();
        if (left.isEditable() && left.isDirty()) {
            left.commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length && !pm.isCanceled()) {
                this.saveChanges((CompareNode)children[i], pm);
                ++i;
            }
        }
    }

    protected class CompareNode
    extends ResourceCompareInput.BaseCompareNode {
        protected int localChangeType;
        protected int remoteChangeType;

        public CompareNode(IDiffContainer parent, int kind, ILocalResource workingVersion, IRepositoryResource local, IRepositoryResource ancestor, IRepositoryResource remote, int localChangeType, int remoteChangeType) {
            super(parent, kind);
            this.localChangeType = localChangeType;
            this.remoteChangeType = remoteChangeType;
            boolean useOriginator = ThreeWayResourceCompareInput.this.local.isCopied() && (localChangeType != 3 || workingVersion.getResource().equals((Object)ThreeWayResourceCompareInput.this.local.getResource()));
            ResourceCompareInput.ResourceElement leftElt = new ResourceCompareInput.ResourceElement(local, workingVersion, localChangeType != 0 && localChangeType != 4);
            leftElt.setEditable(local instanceof IRepositoryFile);
            this.setLeft(leftElt);
            this.setAncestor(new ResourceCompareInput.ResourceElement(ancestor, workingVersion, useOriginator || localChangeType != 5 && localChangeType != 3 && remoteChangeType != 3));
            this.setRight(new ResourceCompareInput.ResourceElement(remote, workingVersion, remoteChangeType != 4 && remoteChangeType != 0));
        }

        public int getLocalChangeType() {
            return this.localChangeType;
        }

        public int getRemoteChangeType() {
            return this.remoteChangeType;
        }
    }
}

