/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryBase;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.RevisionComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.GetRemoteFolderChildrenOperation;
import org.modelbus.team.eclipse.ui.panel.common.RepositoryTreePanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.utility.UserInputHistory;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.ResourceNameVerifier;

public class BranchTagSelectionComposite
extends Composite {
    public static final int BRANCH_OPERATED = 0;
    public static final int TAG_OPERATED = 1;
    protected Combo urlText;
    protected Button browse;
    protected UserInputHistory inputHistory;
    protected RevisionComposite revisionComposite;
    protected RevisionComposite secondRevisionComposite;
    protected IValidationManager validationManager;
    protected IRepositoryResource baseResource;
    protected boolean considerStructure;
    protected int type;
    protected String url;
    protected CompositeVerifier verifier;
    protected String selectionTitle;
    protected String selectionDescription;
    protected IRepositoryRoot root;
    protected String ignored;

    public BranchTagSelectionComposite(Composite parent, int style, IRepositoryResource baseResource, String historyKey, IValidationManager validationManager, int type) {
        super(parent, style);
        this.baseResource = baseResource;
        this.inputHistory = new UserInputHistory(historyKey);
        this.validationManager = validationManager;
        this.type = type;
        this.ignored = ModelBusTeamUIPlugin.instance().getResource(this.type == 0 ? "Branch.Read.Separator" : "Tag.Read.Separator");
        this.considerStructure = ModelBusTeamPreferences.getRepositoryBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        this.root = this.type == 0 ? ModelBusUtility.getBranchesLocation((IRepositoryResource)this.baseResource) : ModelBusUtility.getTagsLocation((IRepositoryResource)this.baseResource);
        this.createControls(parent);
    }

    protected void createControls(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label resourceLabel = new Label((Composite)this, 0);
        resourceLabel.setLayoutData((Object)new GridData());
        if (this.type == 0) {
            resourceLabel.setText(ModelBusTeamUIPlugin.instance().getResource("Select.Branch.Label"));
        } else {
            resourceLabel.setText(ModelBusTeamUIPlugin.instance().getResource("Select.Tag.Label"));
        }
        Composite select = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        select.setLayout((Layout)layout);
        data = new GridData(768);
        select.setLayoutData((Object)data);
        this.urlText = new Combo(select, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setVisibleItemCount(this.inputHistory.getDepth() * 2);
        this.urlText.setItems(this.inputHistory.getHistory());
        IRepositoryResource[] children = new IRepositoryResource[]{};
        if (this.considerStructure) {
            GetRemoteFolderChildrenOperation op = new GetRemoteFolderChildrenOperation((IRepositoryContainer)this.root, true);
            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
            if (op.getChildren() != null) {
                children = op.getChildren();
            }
        }
        if (children.length > 0) {
            this.urlText.add(this.ignored);
        }
        int i = 0;
        while (i < children.length) {
            this.urlText.add(children[i].getName());
            ++i;
        }
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BranchTagSelectionComposite.this.url = ((Combo)e.widget).getText();
                BranchTagSelectionComposite.this.revisionComposite.setSelectedResource(BranchTagSelectionComposite.this.getSelectedResource());
            }
        });
        this.urlText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String comboText;
                int idx = BranchTagSelectionComposite.this.urlText.getSelectionIndex();
                if (idx != -1 && (comboText = BranchTagSelectionComposite.this.urlText.getItem(idx)).equals(BranchTagSelectionComposite.this.ignored)) {
                    BranchTagSelectionComposite.this.urlText.setText("");
                }
            }
        });
        this.validationManager.attachTo((Control)this.urlText, new ResourceNameVerifier(resourceLabel.getText(), true));
        this.validationManager.attachTo((Control)this.urlText, new NonEmptyFieldVerifier(resourceLabel.getText()));
        this.browse = new Button(select, 8);
        this.browse.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String part = BranchTagSelectionComposite.this.type == 0 ? "Branch" : "Tag";
                RepositoryTreePanel panel = BranchTagSelectionComposite.this.considerStructure ? new RepositoryTreePanel(ModelBusTeamUIPlugin.instance().getResource("Select." + part + ".Title"), ModelBusTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Description"), ModelBusTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Message"), null, true, (IRepositoryBase)BranchTagSelectionComposite.this.root) : new RepositoryTreePanel(ModelBusTeamUIPlugin.instance().getResource("Select." + part + ".Title"), ModelBusTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Description"), ModelBusTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Message"), null, true);
                DefaultDialog browser = new DefaultDialog(BranchTagSelectionComposite.this.getShell(), panel);
                if (browser.open() == 0) {
                    IRepositoryResource selectedResource = panel.getSelectedResource();
                    boolean samePeg = selectedResource.getPegRevision().equals((Object)BranchTagSelectionComposite.this.baseResource.getPegRevision());
                    if (BranchTagSelectionComposite.this.considerStructure) {
                        String toTrim = BranchTagSelectionComposite.this.root.getUrl();
                        BranchTagSelectionComposite.this.urlText.setText(samePeg ? selectedResource.getUrl().substring(toTrim.length() + 1) : ModelBusUtility.getEntryReference((IRepositoryResource)selectedResource).toString());
                    } else {
                        BranchTagSelectionComposite.this.urlText.setText(samePeg ? selectedResource.getUrl() : ModelBusUtility.getEntryReference((IRepositoryResource)selectedResource).toString());
                    }
                    BranchTagSelectionComposite.this.revisionComposite.setSelectedResource(selectedResource);
                    BranchTagSelectionComposite.this.validationManager.validateContent();
                }
            }
        });
        Composite revisions = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        revisions.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        revisions.setLayoutData((Object)data);
        this.revisionComposite = new RevisionComposite(revisions, this.validationManager, true, new String[]{ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.Revision"), ModelBusTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.HeadRevision")}, ModelBusRevision.HEAD, false){

            @Override
            public void additionalValidation() {
                BranchTagSelectionComposite.this.validationManager.validateContent();
            }
        };
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setSelectedResource(this.baseResource);
    }

    public void saveChanges() {
        this.inputHistory.addLine(this.url);
    }

    public void setCurrentRevision(ModelBusRevision currentRevision) {
        this.revisionComposite.setCurrentRevision(currentRevision);
    }

    public IRepositoryResource getSelectedResource() {
        String url = this.considerStructure ? String.valueOf(this.root.getUrl()) + "/" + this.url : this.url;
        IRepositoryResource resource = this.getDestination(ModelBusUtility.asEntryReference((String)url), false);
        resource.setSelectedRevision(this.revisionComposite.getSelectedRevision());
        return resource;
    }

    protected IRepositoryResource getDestination(ModelBusEntryReference ref, boolean allowsNull) {
        if (ref == null) {
            return ModelBusUtility.copyOf((IRepositoryResource)this.baseResource);
        }
        String url = ModelBusUtility.normalizeURL((String)ref.path);
        try {
            IRepositoryContainer resource;
            Object object = resource = this.baseResource instanceof IRepositoryContainer ? ModelBusConnector.asRepositoryContainer((String)url, (boolean)false) : this.baseResource.asRepositoryFile(url, false);
            if (ref.pegRevision != null) {
                resource.setPegRevision(ref.pegRevision);
            }
            return resource;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return allowsNull ? null : ModelBusUtility.copyOf((IRepositoryResource)this.baseResource);
        }
    }
}

