/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;

public class ModelBusContainerSelectionGroup
extends ContainerSelectionGroup {
    public ModelBusContainerSelectionGroup(Composite parent, Listener listener) {
        super(parent, listener, false, "", false);
    }

    public void createContents(String message, int heightHint, int widthHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    public void createContents(String message, int heightHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    public static class ModelBusContainerCheckOutSelectionVerifier
    extends ModelBusContainerSelectionVerifier {
        protected static String WARNING_MESSAGE;

        public ModelBusContainerCheckOutSelectionVerifier() {
            WARNING_MESSAGE = ModelBusTeamUIPlugin.instance().getResource("ModelBusContainerSelectionGroup.Verifier.NonModelBusWarning");
        }

        @Override
        protected String getWarningMessageImpl(Control input) {
            ModelBusContainerSelectionGroup control = (ModelBusContainerSelectionGroup)input;
            IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(control.getContainerFullPath());
            if (!FileUtility.isConnected((IResource)destinationRoot)) {
                return WARNING_MESSAGE;
            }
            return null;
        }

        @Override
        protected boolean isNonModelBusCheckDisabled() {
            return false;
        }
    }

    public static class ModelBusContainerSelectionVerifier
    extends AbstractFormattedVerifier {
        protected static String ERROR_MESSAGE;
        protected static String DESTINATION_IS_DETACHED_FROM_ModelBus;
        protected static String DESTINATION_DIRECTORY_IS_DELETED;
        protected static String DESTINATION_DIRECTORY_IS_OBSTRUCTED;

        public ModelBusContainerSelectionVerifier() {
            super("");
            ERROR_MESSAGE = ModelBusTeamUIPlugin.instance().getResource("ModelBusContainerSelectionGroup.Verifier.NotSelected");
            DESTINATION_IS_DETACHED_FROM_ModelBus = ModelBusTeamUIPlugin.instance().getResource("ModelBusContainerSelectionGroup.Verifier.NonModelBus");
            DESTINATION_DIRECTORY_IS_DELETED = ModelBusTeamUIPlugin.instance().getResource("ModelBusContainerSelectionGroup.Verifier.Deleted");
            DESTINATION_DIRECTORY_IS_OBSTRUCTED = ModelBusTeamUIPlugin.instance().getResource("ModelBusContainerSelectionGroup.Verifier.Obstructed");
        }

        @Override
        protected String getErrorMessageImpl(Control input) {
            ModelBusContainerSelectionGroup control = (ModelBusContainerSelectionGroup)input;
            if (control.getContainerFullPath() == null) {
                return ERROR_MESSAGE;
            }
            IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(control.getContainerFullPath());
            ILocalResource localDest = ModelBusRemoteStorage.instance().asLocalResource(destinationRoot);
            if (IStateFilter.SF_INTERNAL_INVALID.accept(localDest)) {
                return this.isNonModelBusCheckDisabled() ? DESTINATION_IS_DETACHED_FROM_ModelBus : null;
            }
            if (IStateFilter.SF_DELETED.accept(localDest)) {
                return DESTINATION_DIRECTORY_IS_DELETED;
            }
            if (IStateFilter.SF_OBSTRUCTED.accept(localDest)) {
                return DESTINATION_DIRECTORY_IS_OBSTRUCTED;
            }
            return null;
        }

        @Override
        protected String getWarningMessageImpl(Control input) {
            return null;
        }

        protected boolean isNonModelBusCheckDisabled() {
            return true;
        }
    }
}

