/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import java.io.FileOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.core.connector.ModelBusProperty;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IResourcePropertyProvider;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.property.RemovePropertiesOperation;
import org.modelbus.team.eclipse.core.operation.remote.GetRemotePropertiesOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.local.SetKeywordsAction;
import org.modelbus.team.eclipse.ui.action.local.SetPropertyAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.dialog.SetPropertyWithOverrideDialog;
import org.modelbus.team.eclipse.ui.panel.view.property.PropertyApplyPanel;
import org.modelbus.team.eclipse.ui.properties.RemovePropertyDialog;
import org.modelbus.team.eclipse.ui.properties.ResourcePropertyEditPanel;
import org.modelbus.team.eclipse.ui.utility.ColumnedViewerComparator;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class PropertiesComposite
extends Composite {
    public static final int APPLY_TO_ALL = 0;
    public static final int APPLY_TO_FILES = 1;
    public static final int APPLY_TO_FOLDERS = 2;
    protected static final int COLUMN_NAME = 0;
    protected static final int COLUMN_VALUE = 1;
    protected ModelBusProperty[] properties;
    protected TableViewer propertyViewer;
    protected Text propertyText;
    protected boolean isProcessing = false;
    protected IResourcePropertyProvider provider;
    protected IResource wcResource;
    protected IRepositoryResource repositoryResource;
    protected IAdaptable resource;

    public PropertiesComposite(Composite parent) {
        super(parent, 0);
        this.createControls(parent);
    }

    public synchronized void setResource(IAdaptable resource, IResourcePropertyProvider provider) {
        if (resource instanceof IResource) {
            this.repositoryResource = null;
            this.wcResource = (IResource)resource;
        } else if (resource instanceof IRepositoryResource) {
            this.repositoryResource = (IRepositoryResource)resource;
        }
        this.provider = provider;
    }

    public IActionOperation getRefreshViewOperation() {
        return new AbstractActionOperation("Operation.PShowProperties"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runImpl(IProgressMonitor monitor) throws Exception {
                PropertiesComposite propertiesComposite = PropertiesComposite.this;
                synchronized (propertiesComposite) {
                    if (PropertiesComposite.this.provider != null && PropertiesComposite.this.provider.getExecutionState() == 0) {
                        if (PropertiesComposite.this.resource != null && !PropertiesComposite.this.resource.equals(PropertiesComposite.this.provider.getLocal()) && !PropertiesComposite.this.resource.equals(PropertiesComposite.this.provider.getRemote())) {
                            return;
                        }
                        PropertiesComposite.this.provider.refresh();
                        PropertiesComposite.this.properties = PropertiesComposite.this.provider.getProperties();
                        if (PropertiesComposite.this.properties == null) {
                            PropertiesComposite.this.properties = new ModelBusProperty[0];
                        }
                    } else {
                        PropertiesComposite.this.properties = null;
                    }
                }
                if (!PropertiesComposite.this.isDisposed()) {
                    PropertiesComposite.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).PropertiesComposite.this.properties != null) {
                                PropertiesComposite.this.setPending(false);
                            }
                            PropertiesComposite.this.initializeComposite();
                        }
                    });
                }
            }
        };
    }

    private void createControls(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        SashForm innerSashForm = new SashForm((Composite)this, 512);
        data = new GridData(1808);
        innerSashForm.setLayoutData((Object)data);
        Table table = new Table((Composite)innerSashForm, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        this.propertyText = new Text((Composite)innerSashForm, 770);
        this.propertyText.setBackground(this.propertyText.getBackground());
        this.propertyText.setEditable(false);
        data = new GridData(1808);
        this.propertyText.setLayoutData((Object)data);
        innerSashForm.setWeights(new int[]{70, 30});
        this.propertyViewer = new TableViewer(table);
        this.propertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection;
                if (event.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null && selection instanceof ModelBusProperty) {
                    PropertiesComposite.this.propertyText.setText(((ModelBusProperty)selection).value);
                }
            }
        });
        PropertiesTableComparator comparator = new PropertiesTableComparator((Viewer)this.propertyViewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.Name"));
        col.addSelectionListener((SelectionListener)comparator);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.Value"));
        col.addSelectionListener((SelectionListener)comparator);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        this.propertyViewer.setComparator((ViewerComparator)comparator);
        comparator.setColumnNumber(0);
        this.propertyViewer.getTable().setSortColumn(this.propertyViewer.getTable().getColumn(0));
        this.propertyViewer.getTable().setSortDirection(128);
        this.propertyViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (PropertiesComposite.this.isProcessing) {
                    return (Object[])inputElement;
                }
                if (PropertiesComposite.this.wcResource == null && PropertiesComposite.this.repositoryResource == null) {
                    return new ModelBusProperty[0];
                }
                return PropertiesComposite.this.properties;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertyViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (PropertiesComposite.this.isProcessing) {
                    if (columnIndex == 0 && PropertiesComposite.this.wcResource != null) {
                        return ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Model.Pending");
                    }
                    return "";
                }
                ModelBusProperty data = (ModelBusProperty)element;
                if (columnIndex == 0) {
                    return data.name;
                }
                return FileUtility.formatMultilineText((String)data.value);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)table);
        menuMgr.addMenuListener(new IMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void menuAboutToShow(IMenuManager manager) {
                PropertiesComposite propertiesComposite = PropertiesComposite.this;
                synchronized (propertiesComposite) {
                    boolean isEditAllowed;
                    manager.add((IContributionItem)new Separator("additions"));
                    final IStructuredSelection tSelection = (IStructuredSelection)PropertiesComposite.this.propertyViewer.getSelection();
                    if (tSelection.size() == 1 && tSelection.getFirstElement() instanceof String) {
                        return;
                    }
                    Action tAction = null;
                    boolean bl = isEditAllowed = PropertiesComposite.this.provider != null && PropertiesComposite.this.provider.isEditAllowed();
                    if (PropertiesComposite.this.wcResource != null && PropertiesComposite.this.repositoryResource == null) {
                        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.Add")){

                            public void run() {
                                PropertiesComposite.this.editProperty(null);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed);
                        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.Edit")){

                            public void run() {
                                ModelBusProperty data = (ModelBusProperty)tSelection.getFirstElement();
                                PropertiesComposite.this.editProperty(data);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed && tSelection.size() == 1);
                        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.Remove")){

                            public void run() {
                                ModelBusProperty[] data = tSelection.toList().toArray(new ModelBusProperty[tSelection.size()]);
                                PropertiesComposite.this.removeProperty(data);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed && tSelection.size() > 0);
                        manager.add((IContributionItem)new Separator());
                        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.SetKeywords")){

                            public void run() {
                                PropertiesComposite.this.setKeywords();
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.ApplyRecursively")){

                            public void run() {
                                ModelBusProperty[] data = tSelection.toList().toArray(new ModelBusProperty[tSelection.size()]);
                                PropertiesComposite.this.setPropertyRecursive(data);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed && tSelection.size() > 0 && PropertiesComposite.this.wcResource instanceof IContainer);
                    }
                    tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.SaveValueToFile")){

                        public void run() {
                            ModelBusProperty data = (ModelBusProperty)tSelection.getFirstElement();
                            PropertiesComposite.this.saveValueToFile(data);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(PropertiesComposite.this.provider != null && tSelection.size() == 1);
                    manager.add((IContributionItem)new Separator());
                    tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("PropertiesComposite.Refresh")){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PropertiesComposite propertiesComposite = PropertiesComposite.this;
                            synchronized (propertiesComposite) {
                                if ((this).PropertiesComposite.this.repositoryResource != null) {
                                    (this).PropertiesComposite.this.provider = new GetRemotePropertiesOperation((this).PropertiesComposite.this.repositoryResource);
                                }
                                CompositeOperation composite = new CompositeOperation("Operation.PRefresh");
                                if ((this).PropertiesComposite.this.provider != null && (this).PropertiesComposite.this.provider.getExecutionState() != 0) {
                                    composite.add((IActionOperation)(this).PropertiesComposite.this.provider);
                                    composite.add(PropertiesComposite.this.getRefreshViewOperation(), new IActionOperation[]{(this).PropertiesComposite.this.provider});
                                } else {
                                    composite.add(PropertiesComposite.this.getRefreshViewOperation());
                                }
                                UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
                    tAction.setEnabled(PropertiesComposite.this.provider != null);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        table.setMenu(menu);
        this.propertyViewer.addDoubleClickListener(new IDoubleClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doubleClick(DoubleClickEvent e) {
                PropertiesComposite propertiesComposite = PropertiesComposite.this;
                synchronized (propertiesComposite) {
                    IStructuredSelection selection;
                    if (PropertiesComposite.this.provider != null && PropertiesComposite.this.provider.isEditAllowed() && (selection = (IStructuredSelection)e.getSelection()).size() == 1) {
                        ModelBusProperty data = (ModelBusProperty)selection.getFirstElement();
                        PropertiesComposite.this.editProperty(data);
                    }
                }
            }
        });
    }

    protected void removeProperty(ModelBusProperty[] data) {
        RemovePropertyDialog dialog = new RemovePropertyDialog(this.getShell(), data.length == 1, this.wcResource instanceof IFile);
        if (dialog.open() != 0) {
            return;
        }
        CompositeOperation composite = new CompositeOperation("Operation.PRemoveProperty");
        composite.add((IActionOperation)new RemovePropertiesOperation(new IResource[]{this.wcResource}, data, dialog.isRecursive()));
        composite.add(this.getRefreshOperation(dialog.isRecursive() ? 2 : 0));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void setKeywords() {
        SetKeywordsAction.doSetKeywords(new IResource[]{this.wcResource});
    }

    protected void setPropertyRecursive(ModelBusProperty[] data) {
        PropertyApplyPanel panel = new PropertyApplyPanel(data.length == 1);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            SetPropertyAction.doSetProperty(new IResource[]{this.wcResource}, data, null, true, panel.getApplyMethod(), panel.useMask(), panel.getFilterMask(), false, this.getRefreshViewOperation());
        }
    }

    protected void editProperty(ModelBusProperty data) {
        SetPropertyWithOverrideDialog overrideDialog;
        ModelBusProperty[] modelBusPropertyArray;
        boolean propertyAlreadyExists = false;
        boolean override = true;
        IResource[] resources = new IResource[]{this.wcResource};
        if (data == null) {
            modelBusPropertyArray = null;
        } else {
            ModelBusProperty[] modelBusPropertyArray2 = new ModelBusProperty[1];
            modelBusPropertyArray = modelBusPropertyArray2;
            modelBusPropertyArray2[0] = data;
        }
        ResourcePropertyEditPanel panel = new ResourcePropertyEditPanel(modelBusPropertyArray, resources, false);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() != 0) {
            return;
        }
        int i = 0;
        while (i < this.properties.length) {
            if (this.properties[i].name.equals(panel.getPropertyName())) {
                propertyAlreadyExists = true;
                break;
            }
            ++i;
        }
        if (propertyAlreadyExists && data == null && (overrideDialog = new SetPropertyWithOverrideDialog(this.getShell(), panel.getPropertyName())).open() != 0) {
            override = false;
        }
        if (override) {
            SetPropertyAction.doSetProperty(resources, panel, this.getRefreshViewOperation());
        }
    }

    protected void saveValueToFile(final ModelBusProperty data) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFileName(data.name);
        final String fileName = fileDialog.open();
        AbstractActionOperation saveValue = new AbstractActionOperation("Operation.PSaveValueToFile"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                FileOutputStream output = null;
                if (fileName != null) {
                    output = new FileOutputStream(fileName);
                    byte[] value = data.value.getBytes();
                    output.write(value);
                }
                if (output != null) {
                    output.close();
                }
            }
        };
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)saveValue);
    }

    protected IActionOperation getRefreshOperation(int depth) {
        CompositeOperation composite = new CompositeOperation("Operation.PRefreshView");
        composite.add(this.getRefreshViewOperation());
        if (this.wcResource != null) {
            composite.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{this.wcResource}, 2, RefreshResourcesOperation.REFRESH_ALL));
        }
        return composite;
    }

    public void initializeComposite() {
        if (this.isProcessing) {
            this.propertyViewer.setInput((Object)new String[]{""});
            this.propertyViewer.getTable().setLinesVisible(false);
        } else {
            this.propertyViewer.setInput((Object)this.properties);
            this.propertyViewer.getTable().setLinesVisible(true);
        }
        this.propertyText.setText("");
    }

    public void setPending(boolean isProcessing) {
        this.isProcessing = isProcessing;
    }

    public synchronized void disconnectComposite() {
        this.wcResource = null;
        this.properties = null;
        this.provider = null;
    }

    protected class PropertiesTableComparator
    extends ColumnedViewerComparator {
        public PropertiesTableComparator(Viewer tableViewer) {
            super(tableViewer);
        }

        @Override
        public int compareImpl(Viewer viewer, Object row1, Object row2) {
            if (row1 instanceof ModelBusProperty) {
                ModelBusProperty data1 = (ModelBusProperty)row1;
                ModelBusProperty data2 = (ModelBusProperty)row2;
                return this.column == 0 ? ColumnedViewerComparator.compare(data1.name, data2.name) : ColumnedViewerComparator.compare(data1.value, data2.value);
            }
            return 0;
        }
    }
}

