/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.CredentialsComposite;
import org.modelbus.team.eclipse.ui.composite.IPropertiesPanel;
import org.modelbus.team.eclipse.ui.composite.ISecurityInfoProvider;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.common.RepositoryTreePanel;
import org.modelbus.team.eclipse.ui.utility.UserInputHistory;
import org.modelbus.team.eclipse.ui.verifier.AbsolutePathVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.URLVerifier;

public class RepositoryPropertiesComposite
extends Composite
implements IPropertiesPanel {
    protected static final String URL_HISTORY_NAME = "repositoryURL";
    protected Text repositoryLabel;
    protected Combo url;
    protected CompositeVerifier urlVerifier;
    protected UserInputHistory urlHistory;
    protected Button browse;
    protected Button useLocationButton;
    protected Button newLabelButton;
    protected CredentialsComposite credentialsComposite;
    protected String rootUrl;
    protected IValidationManager validationManager;
    protected ISecurityInfoProvider provider;

    public RepositoryPropertiesComposite(Composite parent, int style, IValidationManager validationManager) {
        super(parent, style);
        this.validationManager = validationManager;
    }

    public String getPasswordDirect() {
        return this.credentialsComposite.getPassword().getText();
    }

    public void setPasswordDirect(String password) {
        this.credentialsComposite.getPassword().setText(password);
    }

    public String getUsernameDirect() {
        return this.credentialsComposite.getUsername().getText();
    }

    public void setUsernameDirect(String username) {
        this.credentialsComposite.getUsername().setText(username);
    }

    public boolean getPasswordSavedDirect() {
        return this.credentialsComposite.getSavePassword().getSelection();
    }

    public void setPasswordSavedDirect(boolean saved) {
        this.credentialsComposite.getSavePassword().setSelection(saved);
    }

    @Override
    public void initialize() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 7;
        layout.verticalSpacing = 3;
        this.setLayout((Layout)layout);
        data = new GridData(1808);
        this.setLayoutData(data);
        Composite rootURLGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rootURLGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        rootURLGroup.setLayoutData((Object)data);
        Label description = new Label(rootURLGroup, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesComposite.URL"));
        this.urlHistory = new UserInputHistory(URL_HISTORY_NAME);
        this.url = new Combo(rootURLGroup, 4);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        this.url.setLayoutData((Object)data);
        this.url.setVisibleItemCount(this.urlHistory.getDepth());
        this.url.setItems(this.urlHistory.getHistory());
        this.urlVerifier = new CompositeVerifier(){

            @Override
            public boolean verify(Control input) {
                boolean retVal = super.verify(input);
                RepositoryPropertiesComposite.this.browse.setEnabled(retVal);
                return retVal;
            }
        };
        this.defineUrlVerifier(null);
        this.validationManager.attachTo((Control)this.url, this.urlVerifier);
        this.browse = new Button(rootURLGroup, 8);
        this.browse.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData(128);
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelBusRemoteStorage.instance();
                RepositoryTreePanel panel = new RepositoryTreePanel(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesComposite.SelectNewURL"), ModelBusTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Description"), ModelBusTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Message"), null, true);
                panel.setAutoExpandFirstLevel(true);
                DefaultDialog browser = new DefaultDialog(RepositoryPropertiesComposite.this.getShell(), panel);
                if (browser.open() == 0) {
                    if (panel.getSelectedResource() != null) {
                        String newUrl = panel.getSelectedResource().getUrl();
                        RepositoryPropertiesComposite.this.url.setText(newUrl);
                    }
                    RepositoryPropertiesComposite.this.provider.commit();
                }
            }
        });
        Group labelGroup = new Group((Composite)this, 0);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        layout = new GridLayout();
        labelGroup.setLayout((Layout)layout);
        labelGroup.setLayoutData((Object)data);
        labelGroup.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesComposite.Label"));
        this.useLocationButton = new Button((Composite)labelGroup, 16);
        this.useLocationButton.setLayoutData((Object)new GridData(768));
        this.useLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesComposite.this.validationManager.validateContent();
                Button button = (Button)e.widget;
                RepositoryPropertiesComposite.this.repositoryLabel.setEnabled(!button.getSelection());
                if (!button.getSelection()) {
                    RepositoryPropertiesComposite.this.repositoryLabel.selectAll();
                } else {
                    RepositoryPropertiesComposite.this.repositoryLabel.setText("");
                }
            }
        });
        this.useLocationButton.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesComposite.UseURL"));
        this.newLabelButton = new Button((Composite)labelGroup, 16);
        this.newLabelButton.setLayoutData((Object)new GridData(768));
        this.newLabelButton.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesComposite.UseCustom"));
        this.repositoryLabel = new Text((Composite)labelGroup, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        this.repositoryLabel.setLayoutData((Object)data);
        this.validationManager.attachTo((Control)this.repositoryLabel, new AbstractVerifierProxy(new NonEmptyFieldVerifier(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesComposite.UseCustom.Verifier"))){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return RepositoryPropertiesComposite.this.newLabelButton.getSelection();
            }
        });
        this.repositoryLabel.setEnabled(false);
        this.credentialsComposite = new CredentialsComposite(this, 0);
        this.credentialsComposite.initialize();
        this.url.setFocus();
        this.resetChanges();
    }

    public void setRepositoryLocation(String rootUrl, ISecurityInfoProvider provider) {
        this.rootUrl = rootUrl;
        this.provider = provider;
    }

    public String getLocationUrl() {
        return this.url.getText();
    }

    public void setCredentialsInput(ISecurityInfoProvider provider) {
        this.provider = provider;
    }

    public void defineUrlVerifier(AbstractVerifier verifier) {
        String name = ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesComposite.URL.Verifier");
        this.urlVerifier.removeAll();
        this.urlVerifier.add(new URLVerifier(name));
        this.urlVerifier.add(new AbsolutePathVerifier(name));
        throw new RuntimeException();
    }

    @Override
    public void saveChanges() {
        String newUrl = this.url.getText();
        this.urlHistory.addLine(newUrl);
        this.credentialsComposite.getUserHistory().addLine(this.credentialsComposite.userName.getText());
    }

    @Override
    public void resetChanges() {
    }

    @Override
    public void cancelChanges() {
    }
}

