/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.resource.SSHSettings;
import org.modelbus.team.eclipse.core.resource.SSLSettings;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.AbstractDynamicComposite;
import org.modelbus.team.eclipse.ui.composite.IPropertiesPanel;
import org.modelbus.team.eclipse.ui.composite.ISecurityInfoProvider;
import org.modelbus.team.eclipse.ui.composite.RepositoryPropertiesComposite;
import org.modelbus.team.eclipse.ui.composite.RepositoryRootsComposite;
import org.modelbus.team.eclipse.ui.composite.SSHComposite;
import org.modelbus.team.eclipse.ui.composite.SSLComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.utility.UserInputHistory;
import org.modelbus.team.eclipse.ui.verifier.AbstractFormattedVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;

public class RepositoryPropertiesTabFolder
extends Composite
implements IPropertiesPanel,
ISecurityInfoProvider {
    protected static final String AUTHOR_HISTORY_NAME = "authorName";
    protected RepositoryPropertiesComposite repositoryPropertiesPanel;
    protected SSHComposite sshComposite;
    protected SSLComposite sslComposite;
    protected RepositoryRootsComposite rootsComposite;
    protected Composite parent;
    protected int style;
    protected IValidationManager validationManager;
    protected Button validateButton;
    protected Button resetChangesButton;
    protected boolean validateOnFinish;
    protected boolean forceDisableRoots;
    protected boolean createNew;
    protected Combo cachedRealms;
    protected boolean isAuthorNameEnabled;
    protected Combo authorInput;
    protected Button authorEnabled;
    protected UserInputHistory authorNameHistory;
    protected TabItem sshTab;
    protected TabItem sslTab;
    protected Composite unavailableSSHComposite;
    protected Composite unavailableProxyComposite;
    protected String sipUsername;
    protected String sipPassword;
    protected boolean sipIsPasswordSaved;
    protected SSHSettings sipSSHSettings;
    protected SSLSettings sipSSLSettings;

    public RepositoryPropertiesTabFolder(Composite parent, int style, IValidationManager validationManager) {
        super(parent, style);
        this.parent = parent;
        this.style = style;
        this.validationManager = validationManager;
        this.createNew = false;
    }

    @Override
    public String getUsername() {
        this.sipUsername = this.repositoryPropertiesPanel.getUsernameDirect();
        return this.sipUsername;
    }

    @Override
    public void setUsername(String username) {
        this.sipUsername = username;
    }

    @Override
    public String getPassword() {
        this.sipPassword = this.repositoryPropertiesPanel.getPasswordDirect();
        return this.sipPassword;
    }

    @Override
    public void setPassword(String password) {
        this.sipPassword = password;
    }

    @Override
    public boolean isPasswordSaved() {
        this.sipIsPasswordSaved = this.repositoryPropertiesPanel.getPasswordSavedDirect();
        return this.sipIsPasswordSaved;
    }

    @Override
    public void setPasswordSaved(boolean saved) {
        this.sipIsPasswordSaved = saved;
    }

    @Override
    public SSLSettings getSSLSettings() {
        this.sipSSLSettings = this.sslComposite.getSSLSettingsDirect();
        return this.sipSSLSettings;
    }

    @Override
    public SSHSettings getSSHSettings() {
        this.sipSSHSettings = this.sshComposite.getSSHSettingsDirect();
        return this.sipSSHSettings;
    }

    @Override
    public void commit() {
        this.repositoryPropertiesPanel.setUsernameDirect(this.sipUsername);
        this.repositoryPropertiesPanel.setPasswordDirect(this.sipPassword);
        this.repositoryPropertiesPanel.setPasswordSavedDirect(this.sipIsPasswordSaved);
        this.sshComposite.setSSHSettingsDirect(this.sipSSHSettings);
        this.sslComposite.setSSLSettingsDirect(this.sipSSLSettings);
    }

    @Override
    public void initialize() {
        int widthHint;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 7;
        this.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.General"));
        tabItem.setControl((Control)this.createRepositoryPropertiesPanel((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.Advanced"));
        Composite rootsComposite = this.createRepositoryRootsComposite((Composite)tabFolder);
        GridData data = new GridData();
        data.verticalIndent = 10;
        this.authorEnabled = new Button(rootsComposite, 32);
        this.authorEnabled.setText(ModelBusTeamUIPlugin.instance().getResource("NewRepositoryLocationWizard.OverrideAuthor"));
        this.authorEnabled.setSelection(true);
        this.authorEnabled.setLayoutData((Object)data);
        String name = ModelBusConnector.getUserName();
        data = new GridData(768);
        this.authorInput = new Combo(rootsComposite, 2048);
        this.authorNameHistory = new UserInputHistory(AUTHOR_HISTORY_NAME);
        this.authorInput.setVisibleItemCount(this.authorNameHistory.getDepth());
        this.authorInput.setItems(this.authorNameHistory.getHistory());
        this.authorInput.setText(name);
        this.authorInput.setEnabled(true);
        this.authorInput.setLayoutData((Object)data);
        AbstractFormattedVerifier verifier = new AbstractFormattedVerifier("AuthorNameVerifier"){

            @Override
            protected String getErrorMessageImpl(Control input) {
                if (this.getText(input).equals("")) {
                    return ModelBusTeamUIPlugin.instance().getResource(ModelBusTeamUIPlugin.instance().getResource("NewRepositoryLocationWizard.AuthorName.Verifier"));
                }
                return null;
            }

            @Override
            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        };
        this.validationManager.attachTo((Control)this.authorInput, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return RepositoryPropertiesTabFolder.this.authorEnabled.getSelection();
            }
        });
        this.authorEnabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                RepositoryPropertiesTabFolder.this.authorInput.setEnabled(((Button)event.widget).getSelection());
                RepositoryPropertiesTabFolder.this.validationManager.validateContent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group proxyGroup = new Group(rootsComposite, 0);
        GridLayout proxyGroupLayout = new GridLayout(1, true);
        proxyGroupLayout.marginHeight = 5;
        proxyGroupLayout.marginWidth = 5;
        proxyGroup.setLayout((Layout)proxyGroupLayout);
        proxyGroup.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.Proxy"));
        data = new GridData(768);
        data.verticalIndent = 10;
        proxyGroup.setLayoutData((Object)data);
        Link proxyLink = new Link((Composite)proxyGroup, 64);
        proxyLink.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.Proxy.Link"));
        proxyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pageId = "org.eclipse.ui.net.NetPreferences";
                PreferencesUtil.createPreferenceDialogOn(null, (String)pageId, (String[])new String[]{pageId}, null).open();
            }
        });
        data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this, 3);
        proxyLink.setLayoutData((Object)data);
        tabItem.setControl((Control)rootsComposite);
        this.unavailableSSHComposite = this.createUnavailableComposite((Composite)tabFolder);
        this.unavailableSSHComposite.setVisible(false);
        this.createSSHHostComposite((Composite)tabFolder);
        this.sshComposite.setVisible(false);
        this.sshTab = new TabItem(tabFolder, 0);
        this.sshTab.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.SSHSettings"));
        this.sshTab.setControl((Control)this.sshComposite);
        this.createSSLHostComposite((Composite)tabFolder);
        this.sslComposite.setVisible(false);
        this.sslTab = new TabItem(tabFolder, 0);
        this.sslTab.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.SSLSettings"));
        this.sslTab.setControl((Control)this.sslComposite);
        this.unavailableProxyComposite = this.createUnavailableComposite((Composite)tabFolder);
        this.unavailableProxyComposite.setVisible(false);
        Composite bottomPart = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        bottomPart.setLayout((Layout)layout);
        data = new GridData(768);
        bottomPart.setLayoutData((Object)data);
        Composite realmsComposite = new Composite(bottomPart, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        realmsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        realmsComposite.setLayoutData((Object)data);
        Label label = new Label(realmsComposite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.ShowFor"));
        this.cachedRealms = new Combo(realmsComposite, 2056);
        final Button deleteRealm = new Button(realmsComposite, 8);
        data = new GridData(768);
        this.cachedRealms.setLayoutData((Object)data);
        final ArrayList<String> itemSet = new ArrayList<String>();
        itemSet.add("<Repository Location>");
        this.cachedRealms.setItems(itemSet.toArray(new String[itemSet.size()]));
        this.cachedRealms.select(0);
        this.cachedRealms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleteRealm.setEnabled(RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex() != 0);
                RepositoryPropertiesTabFolder.this.realmSelectionChanged();
            }
        });
        ImageDescriptor imgDescr = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/common/delete_realm.gif");
        deleteRealm.setImage(imgDescr.createImage());
        data = new GridData();
        data.heightHint = this.cachedRealms.getTextHeight() + 2;
        deleteRealm.setLayoutData((Object)data);
        deleteRealm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex();
                if (idx != 0) {
                    String item = RepositoryPropertiesTabFolder.this.cachedRealms.getItem(idx);
                    itemSet.remove(item);
                    RepositoryPropertiesTabFolder.this.cachedRealms.setItems(itemSet.toArray(new String[itemSet.size()]));
                    RepositoryPropertiesTabFolder.this.cachedRealms.select(idx - 1);
                    RepositoryPropertiesTabFolder.this.realmSelectionChanged();
                }
                boolean enabled = RepositoryPropertiesTabFolder.this.cachedRealms.getItems().length > 1;
                ((Button)e.widget).setEnabled(enabled);
                RepositoryPropertiesTabFolder.this.cachedRealms.setEnabled(enabled);
                idx = RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex();
                if (idx == 0) {
                    ((Button)e.widget).setEnabled(false);
                }
            }
        });
        deleteRealm.setEnabled(false);
        this.cachedRealms.setEnabled(itemSet.size() > 1);
        this.validateButton = new Button(bottomPart, 32);
        data = new GridData(32);
        this.validateButton.setLayoutData((Object)data);
        this.validateButton.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.ValidateOnFinish"));
        this.validateButton.setSelection(true);
        Text empty = new Text(bottomPart, 8);
        data = new GridData(768);
        empty.setLayoutData((Object)data);
        empty.setVisible(false);
        this.resetChangesButton = new Button(bottomPart, 8);
        data = new GridData(128);
        this.resetChangesButton.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.ResetChanges"));
        data.widthHint = widthHint = DefaultDialog.computeButtonWidth(this.resetChangesButton);
        this.resetChangesButton.setLayoutData((Object)data);
        this.resetChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesTabFolder.this.resetChanges();
                RepositoryPropertiesTabFolder.this.validationManager.validateContent();
            }
        });
    }

    protected void realmSelectionChanged() {
        int idx = this.cachedRealms.getSelectionIndex();
        this.repositoryPropertiesPanel.saveChanges();
        this.repositoryPropertiesPanel.resetChanges();
        this.sslComposite.saveChanges();
        this.sslComposite.resetChanges();
    }

    protected Composite createRepositoryPropertiesPanel(Composite tabFolder) {
        this.repositoryPropertiesPanel = new RepositoryPropertiesComposite(tabFolder, this.style, this.validationManager);
        this.repositoryPropertiesPanel.initialize();
        return this.repositoryPropertiesPanel;
    }

    protected Composite createSSHHostComposite(Composite tabFolder) {
        this.sshComposite = new SSHComposite(tabFolder, this.style, this.validationManager);
        this.sshComposite.initialize();
        return this.sshComposite;
    }

    protected Composite createSSLHostComposite(Composite tabFolder) {
        this.sslComposite = new SSLComposite(tabFolder, this.style, this.validationManager);
        this.sslComposite.initialize();
        return this.sslComposite;
    }

    protected Composite createRepositoryRootsComposite(Composite tabFolder) {
        this.rootsComposite = new RepositoryRootsComposite(tabFolder, this.style, this.validationManager);
        this.rootsComposite.setCreateLocation(this.createNew);
        this.rootsComposite.initialize();
        return this.rootsComposite;
    }

    protected Composite createUnavailableComposite(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.UnavailableMessage"));
        Link link = new Link(composite, 0);
        link.setText(ModelBusTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.LinkToPreferences"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesTabFolder.this.handleLinkSelection();
            }
        });
        return composite;
    }

    public void handleLinkSelection() {
        boolean sshWasAllowed = true;
        String pageId = "org.modelbus.team.eclipse.ui.ModelBusTeamPreferences";
        PreferencesUtil.createPreferenceDialogOn(null, (String)pageId, (String[])new String[]{pageId}, null).open();
        boolean sshAllowed = true;
        this.updateTabContent(sshWasAllowed, sshAllowed, this.sshTab, this.sshComposite, this.unavailableSSHComposite);
    }

    public void updateTabContent(boolean wasAvailable, boolean isAvailable, TabItem tab, AbstractDynamicComposite availableComposite, Composite unavailableComposite) {
        if (isAvailable) {
            if (!wasAvailable) {
                availableComposite.restoreAppearance();
                tab.setControl((Control)availableComposite);
            }
        } else if (wasAvailable) {
            availableComposite.saveAppearance();
            tab.setControl((Control)unavailableComposite);
            availableComposite.revalidateContent();
        }
    }

    public String getLocationUrl() {
        return this.repositoryPropertiesPanel.getLocationUrl();
    }

    public boolean isStructureEnabled() {
        return this.rootsComposite.isStructureEnabled();
    }

    public boolean isValidateOnFinishRequested() {
        return this.validateOnFinish;
    }

    @Override
    public void saveChanges() {
        this.repositoryPropertiesPanel.saveChanges();
        this.sslComposite.saveChanges();
        this.rootsComposite.saveChanges();
        this.authorNameHistory.addLine(this.authorInput.getText());
        ModelBusTeamUIPlugin.instance().getPreferenceStore();
        boolean enabled = this.rootsComposite.isStructureEnabled();
        if (!enabled) {
            // empty if block
        }
        new HashSet<String>(Arrays.asList(this.cachedRealms.getItems()));
        this.validateOnFinish = this.validateButton.getSelection();
    }

    @Override
    public void resetChanges() {
        this.repositoryPropertiesPanel.resetChanges();
        this.sslComposite.resetChanges();
        this.rootsComposite.resetChanges();
    }

    @Override
    public void cancelChanges() {
    }

    public void setForceDisableRoots(boolean forceDisableRoots, AbstractVerifier verifier) {
        if (this.rootsComposite != null) {
            this.rootsComposite.setForceDisableRoots(forceDisableRoots);
        }
        if (this.repositoryPropertiesPanel != null) {
            this.repositoryPropertiesPanel.defineUrlVerifier(verifier);
        }
    }
}

