/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.connector.ModelBusRevisionRange;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.RevisionComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.common.RepositoryTreePanel;
import org.modelbus.team.eclipse.ui.utility.UserInputHistory;
import org.modelbus.team.eclipse.ui.verifier.AbsolutePathVerifier;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifier;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.URLVerifier;

public class RepositoryResourceSelectionComposite
extends Composite {
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_TWO = 1;
    public static final int MODE_CHECK = 2;
    public static final int TEXT_NONE = 0;
    public static final int TEXT_BASE = 1;
    public static final int TEXT_LAST = 2;
    protected Combo urlText;
    protected Button browse;
    protected UserInputHistory urlHistory;
    protected RevisionComposite revisionComposite;
    protected RevisionComposite secondRevisionComposite;
    protected IValidationManager validationManager;
    protected IRepositoryResource baseResource;
    protected boolean stopOnCopy;
    protected boolean toFilterCurrent;
    protected int mode;
    protected String url;
    protected CompositeVerifier verifier;
    protected String selectionTitle;
    protected String selectionDescription;
    protected String comboId;
    protected boolean foldersOnly;
    protected int defaultTextType;

    public RepositoryResourceSelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, IRepositoryResource baseResource, boolean stopOnCopy, String selectionTitle, String selectionDescription, int mode, int defaultTextType) {
        this(parent, style, validationManager, historyKey, "RepositoryResourceSelectionComposite.URL", baseResource, stopOnCopy, selectionTitle, selectionDescription, mode, defaultTextType);
    }

    public RepositoryResourceSelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, String comboId, IRepositoryResource baseResource, boolean stopOnCopy, String selectionTitle, String selectionDescription, int mode, int defaultTextType) {
        super(parent, style);
        this.stopOnCopy = stopOnCopy;
        this.toFilterCurrent = false;
        this.urlHistory = new UserInputHistory(historyKey);
        this.validationManager = validationManager;
        this.baseResource = baseResource;
        this.selectionTitle = selectionTitle;
        this.selectionDescription = selectionDescription;
        this.mode = mode;
        this.comboId = comboId;
        this.foldersOnly = !(baseResource instanceof IRepositoryFile);
        this.defaultTextType = defaultTextType;
        this.createControls(defaultTextType);
    }

    public void setBaseResource(IRepositoryResource baseResource) {
        this.baseResource = baseResource;
        if (this.revisionComposite != null) {
            this.revisionComposite.setBaseResource(this.baseResource);
        }
        if (this.secondRevisionComposite != null) {
            this.secondRevisionComposite.setBaseResource(this.baseResource);
        }
        if (this.defaultTextType == 1 && this.baseResource != null) {
            this.urlText.setText(this.baseResource.getUrl());
        }
    }

    public void setFoldersOnly(boolean foldersOnly) {
        this.foldersOnly = foldersOnly;
    }

    public void setFilterCurrent(boolean toFilter) {
        this.toFilterCurrent = toFilter;
        this.revisionComposite.setFilterCurrent(this.toFilterCurrent);
    }

    public boolean isSelectionAvailable() {
        return this.getDestination(ModelBusUtility.asEntryReference((String)this.url), true) != null;
    }

    public IRepositoryResource getSelectedResource() {
        IRepositoryResource resource = this.getDestination(ModelBusUtility.asEntryReference((String)this.url), false);
        resource.setSelectedRevision(this.revisionComposite.getSelectedRevision());
        return resource;
    }

    public IRepositoryResource getSecondSelectedResource() {
        if (this.secondRevisionComposite == null) {
            return null;
        }
        IRepositoryResource resource = this.getDestination(ModelBusUtility.asEntryReference((String)this.url), false);
        resource.setSelectedRevision(this.secondRevisionComposite.getSelectedRevision());
        return resource;
    }

    public ModelBusRevisionRange[] getSelectedRevisions() {
        if (this.mode == 2) {
            return this.revisionComposite.getSelectedRevisions();
        }
        ModelBusRevision first = this.getSelectedResource().getSelectedRevision();
        ModelBusRevision second = this.getSecondSelectedRevision();
        return new ModelBusRevisionRange[]{new ModelBusRevisionRange(first, second == null ? first : second)};
    }

    public ModelBusRevision getStartRevision() {
        return this.revisionComposite.getSelectedRevision();
    }

    public ModelBusRevision getSecondSelectedRevision() {
        if (this.secondRevisionComposite == null) {
            return null;
        }
        return this.secondRevisionComposite.getSelectedRevision();
    }

    public void setCurrentRevision(ModelBusRevision currentRevision) {
        this.revisionComposite.setCurrentRevision(currentRevision);
    }

    public void addVerifier(AbstractVerifier verifier) {
        this.verifier.add(verifier);
    }

    public void removeVerifier(AbstractVerifier verifier) {
        this.verifier.remove(verifier);
    }

    public void setUrl(String url) {
        this.urlText.setText(url);
    }

    public String getUrl() {
        return this.urlText.getText();
    }

    public void saveHistory() {
        this.urlHistory.addLine(this.urlText.getText());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.urlText.setEnabled(enabled);
        this.browse.setEnabled(enabled);
        this.revisionComposite.setEnabled(enabled);
        if (this.secondRevisionComposite != null) {
            this.secondRevisionComposite.setEnabled(enabled);
        }
    }

    private void createControls(int defaultTextType) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label urlLabel = new Label((Composite)this, 0);
        urlLabel.setLayoutData((Object)new GridData());
        urlLabel.setText(ModelBusTeamUIPlugin.instance().getResource(this.comboId));
        Composite select = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        select.setLayout((Layout)layout);
        data = new GridData(768);
        select.setLayoutData((Object)data);
        this.urlText = new Combo(select, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setVisibleItemCount(this.urlHistory.getDepth());
        this.urlText.setItems(this.urlHistory.getHistory());
        if (defaultTextType == 1 && this.baseResource != null) {
            this.urlText.setText(this.baseResource.getUrl());
        } else if (defaultTextType == 2 && this.urlText.getItemCount() > 0) {
            this.urlText.select(0);
        }
        this.url = this.urlText.getText();
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryResourceSelectionComposite.this.url = ((Combo)e.widget).getText();
                if (RepositoryResourceSelectionComposite.this.isSelectionAvailable()) {
                    RepositoryResourceSelectionComposite.this.revisionComposite.setSelectedResource(RepositoryResourceSelectionComposite.this.getSelectedResource());
                    boolean toFilter = RepositoryResourceSelectionComposite.this.toFilterCurrent && RepositoryResourceSelectionComposite.this.baseResource != null && (RepositoryResourceSelectionComposite.this.getSelectedResource().getUrl().equals(RepositoryResourceSelectionComposite.this.baseResource.getUrl()) || RepositoryResourceSelectionComposite.this.getSelectedResource().getUrl().equals(String.valueOf(RepositoryResourceSelectionComposite.this.baseResource.getUrl()) + "/"));
                    RepositoryResourceSelectionComposite.this.revisionComposite.setFilterCurrent(toFilter);
                    if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                        RepositoryResourceSelectionComposite.this.secondRevisionComposite.setSelectedResource(RepositoryResourceSelectionComposite.this.getSecondSelectedResource());
                        RepositoryResourceSelectionComposite.this.secondRevisionComposite.setFilterCurrent(toFilter);
                    }
                }
            }
        });
        this.verifier = new CompositeVerifier(){

            @Override
            protected void fireError(String errorReason) {
                RepositoryResourceSelectionComposite.this.revisionComposite.setEnabled(false);
                if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                    RepositoryResourceSelectionComposite.this.secondRevisionComposite.setEnabled(false);
                }
                super.fireError(errorReason);
            }

            @Override
            protected void fireOk() {
                RepositoryResourceSelectionComposite.this.revisionComposite.setEnabled(true);
                if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                    RepositoryResourceSelectionComposite.this.secondRevisionComposite.setEnabled(true);
                }
                super.fireOk();
            }
        };
        this.verifier.add(new NonEmptyFieldVerifier(ModelBusTeamUIPlugin.instance().getResource(String.valueOf(this.comboId) + ".Verifier")));
        this.verifier.add(new URLVerifier(ModelBusTeamUIPlugin.instance().getResource(String.valueOf(this.comboId) + ".Verifier")){

            @Override
            protected String getErrorMessage(Control input) {
                String url;
                String error = super.getErrorMessage(input);
                if (RepositoryResourceSelectionComposite.this.baseResource != null && error == null && RepositoryResourceSelectionComposite.this.getDestination(ModelBusUtility.asEntryReference((String)(url = this.getText(input))), true) == null) {
                    error = ModelBusTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.URL.Verifier.Error", new String[]{url, "TODOMWA1"});
                }
                return error;
            }
        });
        this.verifier.add(new AbsolutePathVerifier(this.comboId));
        this.validationManager.attachTo((Control)this.urlText, this.verifier);
        this.browse = new Button(select, 8);
        this.browse.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRepositoryResource[] iRepositoryResourceArray;
                String string = ModelBusTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.Select.Title");
                String string2 = RepositoryResourceSelectionComposite.this.selectionTitle;
                String string3 = RepositoryResourceSelectionComposite.this.selectionDescription;
                if (RepositoryResourceSelectionComposite.this.baseResource == null) {
                    iRepositoryResourceArray = new IRepositoryResource[]{};
                } else {
                    IRepositoryResource[] iRepositoryResourceArray2 = new IRepositoryResource[1];
                    iRepositoryResourceArray = iRepositoryResourceArray2;
                    iRepositoryResourceArray2[0] = RepositoryResourceSelectionComposite.this.getSelectedResource();
                }
                RepositoryTreePanel panel = new RepositoryTreePanel(string, string2, string3, iRepositoryResourceArray, true);
                panel.setAllowFiles(!RepositoryResourceSelectionComposite.this.foldersOnly);
                DefaultDialog browser = new DefaultDialog(RepositoryResourceSelectionComposite.this.getShell(), panel);
                if (browser.open() == 0) {
                    IRepositoryResource selectedResource = panel.getSelectedResource();
                    boolean samePeg = RepositoryResourceSelectionComposite.this.baseResource != null && selectedResource.getPegRevision().equals((Object)RepositoryResourceSelectionComposite.this.baseResource.getPegRevision());
                    RepositoryResourceSelectionComposite.this.urlText.setText(samePeg ? selectedResource.getUrl() : ModelBusUtility.getEntryReference((IRepositoryResource)selectedResource).toString());
                    RepositoryResourceSelectionComposite.this.revisionComposite.setSelectedResource(selectedResource);
                    if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                        RepositoryResourceSelectionComposite.this.secondRevisionComposite.setSelectedResource(selectedResource);
                    }
                    RepositoryResourceSelectionComposite.this.validationManager.validateContent();
                }
            }
        });
        Composite revisions = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        revisions.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        revisions.setLayoutData((Object)data);
        String revTitle = ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.Revision");
        if (this.mode == 1) {
            revTitle = ModelBusTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.StartRevision");
        } else if (this.mode == 2) {
            revTitle = ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.Revisions");
        }
        String revHeadName = ModelBusTeamUIPlugin.instance().getResource(this.mode == 2 ? "RevisionComposite.All" : "RevisionComposite.HeadRevision");
        this.revisionComposite = new RevisionComposite(revisions, this.validationManager, this.stopOnCopy, new String[]{revTitle, revHeadName}, ModelBusRevision.HEAD, this.mode == 2){

            @Override
            public void additionalValidation() {
                RepositoryResourceSelectionComposite.this.validateRevisions();
            }
        };
        data = new GridData(768);
        data.horizontalSpan = this.mode == 1 ? 1 : 2;
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setBaseResource(this.baseResource);
        this.revisionComposite.setSelectedResource(this.getSelectedResource());
        if (this.mode == 1) {
            this.secondRevisionComposite = new RevisionComposite(revisions, this.validationManager, this.stopOnCopy, new String[]{ModelBusTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.StopRevision"), ModelBusTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.HeadRevision")}, ModelBusRevision.HEAD, false){

                @Override
                public void additionalValidation() {
                    RepositoryResourceSelectionComposite.this.validateRevisions();
                }
            };
            data = new GridData(768);
            this.secondRevisionComposite.setLayoutData(data);
            this.secondRevisionComposite.setBaseResource(this.baseResource);
            this.secondRevisionComposite.setSelectedResource(this.getSelectedResource());
        }
    }

    protected IRepositoryResource getDestination(ModelBusEntryReference ref, boolean allowsNull) {
        if (ref == null) {
            if (this.baseResource == null) {
                if (allowsNull) {
                    return null;
                }
                throw new IllegalArgumentException("ModelBus entry reference cannot be null.");
            }
            return ModelBusUtility.copyOf((IRepositoryResource)this.baseResource);
        }
        String url = ModelBusUtility.normalizeURL((String)ref.path);
        try {
            IRepositoryResource base = this.baseResource;
            IRepositoryResource resource = null;
            if (base != null) {
                resource = this.foldersOnly ? this.baseResource.asRepositoryContainer(url, false) : this.baseResource.asRepositoryFile(url, false);
            } else {
                ModelBusUtility.getModelBusUrl((String)url);
                resource = ModelBusUtility.asRepositoryResource((String)url, (boolean)this.foldersOnly);
            }
            if (ref.pegRevision != null) {
                resource.setPegRevision(ref.pegRevision);
            }
            return resource;
        }
        catch (Exception exception) {
            if (allowsNull) {
                return null;
            }
            if (this.baseResource == null) {
                throw new IllegalArgumentException("ModelBus entry reference must contain a valid value.");
            }
            return ModelBusUtility.copyOf((IRepositoryResource)this.baseResource);
        }
    }

    protected void validateRevisions() {
        if ((this.mode & 1) != 0) {
            this.validationManager.validateContent();
        }
    }
}

