/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.part.DrillDownAdapter;
import org.modelbus.team.eclipse.core.resource.IRepositoryBase;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.repository.RepositoryTreeViewer;
import org.modelbus.team.eclipse.ui.repository.model.IRepositoryContentFilter;
import org.modelbus.team.eclipse.ui.repository.model.RepositoriesRoot;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryContentProvider;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFolder;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryLabelProvider;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryResource;

public class RepositoryTreeComposite
extends Composite {
    protected RepositoryTreeViewer repositoryTree;
    protected DrillDownAdapter ddAdapter;
    protected RepositoryContentProvider provider;
    protected boolean autoExpandFirstLevel;

    public RepositoryTreeComposite(Composite parent, int style) {
        this(parent, style, false);
    }

    public RepositoryTreeComposite(Composite parent, int style, boolean multiSelect) {
        this(parent, style, multiSelect, new RepositoriesRoot());
    }

    public RepositoryTreeComposite(Composite parent, int style, boolean multiSelect, Object input) {
        super(parent, style);
        this.createControls(multiSelect ? 2 : 4, input);
    }

    public RepositoryTreeViewer getRepositoryTreeViewer() {
        return this.repositoryTree;
    }

    public void setAutoExpandFirstLevel(boolean autoExpandFirstLevel) {
        this.autoExpandFirstLevel = autoExpandFirstLevel;
    }

    public Object getModelRoot() {
        return this.repositoryTree.getInput();
    }

    public void setModelRoot(Object root) {
        this.repositoryTree.setInput(root);
    }

    public IRepositoryContentFilter getFilter() {
        return this.provider.getFilter();
    }

    public void setFilter(IRepositoryContentFilter filter) {
        this.provider.setFilter(filter);
        this.repositoryTree.refresh();
    }

    private void createControls(int style, Object input) {
        GridData data = null;
        GridLayout layout = null;
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarMgr.createControl((Composite)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        toolBar.setLayoutData((Object)data);
        this.repositoryTree = new RepositoryTreeViewer(this, style | 0x100 | 0x200);
        if (this.autoExpandFirstLevel) {
            this.repositoryTree.setAutoExpandLevel(2);
        }
        this.repositoryTree.getTree().setLayoutData((Object)new GridData(1808));
        this.provider = new RepositoryContentProvider(this.repositoryTree);
        this.repositoryTree.setContentProvider((IContentProvider)this.provider);
        this.repositoryTree.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        if (input instanceof IRepositoryBase) {
            RepositoryResource resource = RepositoryFolder.wrapChild(null, (IRepositoryResource)input);
            resource.setViewer(this.repositoryTree);
            this.repositoryTree.setInput(resource);
        } else {
            this.repositoryTree.setInput(input);
        }
        this.repositoryTree.setAutoExpandLevel(2);
        this.ddAdapter = new DrillDownAdapter((TreeViewer)this.repositoryTree);
        this.ddAdapter.addNavigationActions((IToolBarManager)toolBarMgr);
        toolBarMgr.update(true);
    }
}

