/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorException;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryReference;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.connector.ModelBusRevisionRange;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.operation.remote.GetLogMessagesOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.history.filter.RevisionLogEntryFilter;
import org.modelbus.team.eclipse.ui.panel.common.SelectRevisionPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;
import org.modelbus.team.eclipse.ui.verifier.IntegerFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.RevisionRangesVerifier;

public class RevisionComposite
extends Composite {
    protected IRepositoryResource selectedResource;
    protected IRepositoryResource baseResource;
    protected ModelBusRevision defaultRevision;
    protected ModelBusRevision currentRevision;
    protected String lastSelectedRevision;
    protected boolean stopOnCopy;
    protected boolean toFilterCurrent;
    protected boolean startFromCopy;
    protected String[] captions;
    protected ModelBusRevision selectedRevision;
    protected Text revisionField;
    protected Button headRevisionRadioButton;
    protected Button startFromCopyRadioButton;
    protected Button changeRevisionRadioButton;
    protected Button changeRevisionButton;
    protected Button reverseRevisionsButton;
    protected Button dateTimeRadioButton;
    protected DateTime dateField;
    protected DateTime timeField;
    protected boolean reverseRevisions;
    protected IValidationManager validationManager;
    protected boolean checkStyled;
    protected ModelBusRevisionRange[] revisions;

    public RevisionComposite(Composite parent, IValidationManager validationManager, boolean stopOnCopy, String[] captions, ModelBusRevision defaultRevision, boolean checkStyled) {
        super(parent, 0);
        this.stopOnCopy = stopOnCopy;
        this.toFilterCurrent = false;
        this.validationManager = validationManager;
        this.lastSelectedRevision = "-1";
        this.captions = captions;
        this.defaultRevision = defaultRevision;
        this.checkStyled = checkStyled;
        this.createControls();
    }

    public void setBaseResource(IRepositoryResource baseResource) {
        this.baseResource = baseResource;
    }

    public void setFilterCurrent(boolean toFilter) {
        this.toFilterCurrent = toFilter;
    }

    public ModelBusRevision getSelectedRevision() {
        return this.selectedRevision;
    }

    public ModelBusRevisionRange[] getSelectedRevisions() {
        if (this.revisions[0].from.getKind() == 0) {
            UIMonitorUtility.doTaskNowDefault((IActionOperation)new AbstractActionOperation("Operation.DetectStartRevision"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
                    ModelBusLogEntry[] msgs = ModelBusUtility.logEntries((IModelBusConnector)proxy, (ModelBusEntryReference)ModelBusUtility.getEntryReference((IRepositoryResource)RevisionComposite.this.selectedResource), (ModelBusRevision)ModelBusRevision.fromString((String)"0"), (ModelBusRevision)RevisionComposite.this.selectedResource.getSelectedRevision(), (long)(0x40000L | (RevisionComposite.this.startFromCopy ? 131072L : 0L)), (String[])IModelBusConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)this, monitor, null));
                    if (msgs.length > 0) {
                        RevisionComposite.this.revisions[0] = new ModelBusRevisionRange(RevisionComposite.this.startFromCopy ? msgs[0].modelBusRevision.getPreviousRevision() : msgs[0].modelBusRevision, RevisionComposite.this.revisions[0].to);
                    }
                }
            }, true);
        }
        int i = 0;
        while (i < this.revisions.length) {
            if (this.reverseRevisions ^ (this.revisions[i].from.getKind() == 7 || this.revisions[i].from.getKind() == 1 && this.revisions[i].to.getKind() == 1 && this.revisions[i].from.isGreaterThan(this.revisions[i].to))) {
                this.revisions[i] = new ModelBusRevisionRange(this.revisions[i].to, this.revisions[i].from);
            }
            ++i;
        }
        Arrays.sort(this.revisions, new Comparator<ModelBusRevisionRange>(){

            @Override
            public int compare(ModelBusRevisionRange o1, ModelBusRevisionRange o2) {
                int retVal = o1.from.equals((Object)o2.from) ? 0 : (o1.from.isLowerThan(o2.from) ? -1 : 1);
                return RevisionComposite.this.reverseRevisions ? retVal * -1 : retVal;
            }
        });
        return this.revisions;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    public void addChangeRevisionListener(SelectionListener listener) {
        this.changeRevisionButton.addSelectionListener(listener);
    }

    public void setSelectedResource(IRepositoryResource resource) {
        this.selectedResource = resource;
        if (this.baseResource == null) {
            this.baseResource = resource;
        }
        if (this.selectedResource == null) {
            this.setEnabled(false);
        } else {
            ModelBusRevision rev = this.selectedResource.getSelectedRevision();
            if (rev.getKind() == 1) {
                this.selectedRevision = rev;
                this.lastSelectedRevision = ((ModelBusRevision.StringRevision)this.selectedRevision).getRevision();
                this.revisionField.setText(this.selectedRevision.toString());
                this.headRevisionRadioButton.setSelection(false);
                if (this.checkStyled) {
                    this.startFromCopyRadioButton.setSelection(false);
                } else {
                    this.dateTimeRadioButton.setSelection(false);
                }
                this.changeRevisionRadioButton.setSelection(true);
            } else if (rev.getKind() == 2 && !this.checkStyled) {
                this.selectedRevision = rev;
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(rev.getDate());
                this.dateField.setYear(calendar.get(1));
                this.dateField.setMonth(calendar.get(2));
                this.dateField.setDay(calendar.get(5));
                this.timeField.setHours(calendar.get(11));
                this.timeField.setMinutes(calendar.get(12));
                this.timeField.setSeconds(calendar.get(13));
                this.headRevisionRadioButton.setSelection(false);
                this.dateTimeRadioButton.setSelection(true);
                this.changeRevisionRadioButton.setSelection(false);
            } else {
                this.selectedRevision = this.defaultRevision;
                this.lastSelectedRevision = "-1";
                this.revisionField.setText("");
                this.headRevisionRadioButton.setSelection(!this.checkStyled);
                if (this.checkStyled) {
                    this.startFromCopyRadioButton.setSelection(true);
                } else {
                    this.dateTimeRadioButton.setSelection(false);
                }
                this.changeRevisionRadioButton.setSelection(false);
            }
            this.setEnabled(true);
        }
    }

    public ModelBusRevision getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(ModelBusRevision currentRevision) {
        this.currentRevision = currentRevision;
    }

    private void createControls() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group group = new Group((Composite)this, 0);
        group.setText(this.captions == null ? ModelBusTeamUIPlugin.instance().getResource(this.checkStyled ? "RevisionComposite.Revisions" : "RevisionComposite.Revision") : this.captions[0]);
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        this.headRevisionRadioButton = new Button((Composite)group, 16);
        this.headRevisionRadioButton.setText(this.captions == null ? ModelBusTeamUIPlugin.instance().getResource(this.checkStyled ? "RevisionComposite.All" : "RevisionComposite.HeadRevision") : this.captions[1]);
        data = new GridData();
        data.horizontalSpan = 3;
        this.headRevisionRadioButton.setLayoutData((Object)data);
        this.headRevisionRadioButton.setSelection(!this.checkStyled);
        this.headRevisionRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionComposite.this.validationManager.validateContent();
                if (((Button)e.widget).getSelection()) {
                    RevisionComposite.this.changeRevisionButton.setEnabled(false);
                    RevisionComposite.this.revisionField.setEnabled(false);
                    RevisionComposite.this.dateField.setEnabled(false);
                    RevisionComposite.this.timeField.setEnabled(false);
                    RevisionComposite.this.startFromCopy = false;
                    RevisionComposite.this.defaultToRevisions();
                }
                RevisionComposite.this.additionalValidation();
            }
        });
        if (this.checkStyled) {
            this.startFromCopyRadioButton = new Button((Composite)group, 16);
            this.startFromCopyRadioButton.setText(ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.StartFromCopy"));
            data = new GridData();
            data.horizontalSpan = 3;
            this.startFromCopyRadioButton.setLayoutData((Object)data);
            this.startFromCopyRadioButton.setSelection(true);
            this.startFromCopyRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.validationManager.validateContent();
                    if (((Button)e.widget).getSelection()) {
                        RevisionComposite.this.changeRevisionButton.setEnabled(false);
                        RevisionComposite.this.revisionField.setEnabled(false);
                        RevisionComposite.this.dateField.setEnabled(false);
                        RevisionComposite.this.timeField.setEnabled(false);
                        RevisionComposite.this.startFromCopy = true;
                        RevisionComposite.this.defaultToRevisions();
                    }
                    RevisionComposite.this.additionalValidation();
                }
            });
        } else {
            this.dateTimeRadioButton = new Button((Composite)group, 16);
            this.dateTimeRadioButton.setText(ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.DateTime"));
            data = new GridData();
            this.dateTimeRadioButton.setLayoutData((Object)data);
            this.dateTimeRadioButton.setSelection(false);
            this.dateTimeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.validationManager.validateContent();
                    if (((Button)e.widget).getSelection()) {
                        RevisionComposite.this.changeRevisionButton.setEnabled(false);
                        RevisionComposite.this.revisionField.setEnabled(false);
                        RevisionComposite.this.dateField.setEnabled(true);
                        RevisionComposite.this.timeField.setEnabled(true);
                        RevisionComposite.this.startFromCopy = false;
                        RevisionComposite.this.dateTimeToRevision();
                    }
                    RevisionComposite.this.additionalValidation();
                }
            });
            Composite cmp = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cmp.setLayout((Layout)layout);
            data = new GridData();
            cmp.setLayoutData((Object)data);
            this.dateField = new DateTime(cmp, 65568);
            data = new GridData();
            this.dateField.setLayoutData((Object)data);
            this.dateField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.dateTimeToRevision();
                }
            });
            this.timeField = new DateTime(cmp, 65664);
            data = new GridData();
            this.timeField.setLayoutData((Object)data);
            this.timeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.dateTimeToRevision();
                }
            });
            Label label = new Label((Composite)group, 0);
            data = new GridData();
            label.setLayoutData((Object)data);
            this.dateField.setEnabled(false);
            this.timeField.setEnabled(false);
        }
        this.changeRevisionRadioButton = new Button((Composite)group, 16);
        this.changeRevisionRadioButton.setText(ModelBusTeamUIPlugin.instance().getResource(this.checkStyled ? "RevisionComposite.RevisionsCtrl" : "RevisionComposite.RevisionCtrl"));
        this.changeRevisionRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionComposite.this.validationManager.validateContent();
                if (((Button)e.widget).getSelection()) {
                    RevisionComposite.this.changeRevisionButton.setEnabled(true);
                    RevisionComposite.this.revisionField.setEnabled(true);
                    RevisionComposite.this.dateField.setEnabled(false);
                    RevisionComposite.this.timeField.setEnabled(false);
                    RevisionComposite.this.startFromCopy = false;
                    RevisionComposite.this.textToRevisions();
                }
                RevisionComposite.this.additionalValidation();
            }
        });
        if (this.checkStyled) {
            data = new GridData(768);
        } else {
            data = new GridData();
            data.horizontalAlignment = 4;
        }
        this.revisionField = new Text((Composite)group, 2052);
        this.revisionField.setLayoutData((Object)data);
        this.revisionField.setEnabled(false);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = this.changeRevisionRadioButton.getText();
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(this.checkStyled ? new RevisionRangesVerifier(name) : new IntegerFieldVerifier(name, true));
        this.validationManager.attachTo((Control)this.revisionField, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return RevisionComposite.this.changeRevisionRadioButton.getSelection();
            }
        });
        this.revisionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RevisionComposite.this.textToRevisions();
            }
        });
        this.changeRevisionButton = new Button((Composite)group, 8);
        this.changeRevisionButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.changeRevisionButton);
        this.changeRevisionButton.setLayoutData((Object)data);
        this.changeRevisionButton.setEnabled(false);
        this.changeRevisionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetLogMessagesOperation msgsOp = SelectRevisionPanel.getMsgsOp(RevisionComposite.this.selectedResource, RevisionComposite.this.stopOnCopy);
                if (!UIMonitorUtility.doTaskNowDefault(RevisionComposite.this.getShell(), (IActionOperation)msgsOp, true).isCancelled() && msgsOp.getExecutionState() == 0) {
                    DefaultDialog dialog;
                    SelectRevisionPanel panel = new SelectRevisionPanel(msgsOp, RevisionComposite.this.checkStyled, RevisionComposite.this.checkStyled, RevisionComposite.this.currentRevision);
                    if (RevisionComposite.this.toFilterCurrent) {
                        RevisionLogEntryFilter revFilter = new RevisionLogEntryFilter();
                        ModelBusRevision revNum = ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
                        if (RevisionComposite.this.baseResource != null) {
                            try {
                                revNum = RevisionComposite.this.baseResource.getRevision();
                            }
                            catch (ModelBusConnectorException modelBusConnectorException) {}
                        }
                        revFilter.setRevisionstoHide(revNum, revNum);
                        panel.addFilter(revFilter);
                    }
                    if ((dialog = new DefaultDialog(RevisionComposite.this.getShell(), panel)).open() == 0) {
                        if (RevisionComposite.this.checkStyled) {
                            RevisionComposite.this.revisions = panel.getSelectedRevisions();
                            String text = "";
                            ModelBusRevisionRange[] modelBusRevisionRangeArray = RevisionComposite.this.revisions;
                            int n = RevisionComposite.this.revisions.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ModelBusRevisionRange range = modelBusRevisionRangeArray[n2];
                                text = String.valueOf(text) + (text.length() == 0 ? range.toString() : ", " + range.toString());
                                ++n2;
                            }
                            RevisionComposite.this.revisionField.setText(text);
                        } else {
                            String selectedRevisionNum;
                            RevisionComposite.this.lastSelectedRevision = selectedRevisionNum = panel.getSelectedRevision();
                            RevisionComposite.this.selectedRevision = ModelBusRevision.fromString((String)selectedRevisionNum);
                            RevisionComposite.this.revisionField.setText(String.valueOf(selectedRevisionNum));
                        }
                    }
                }
                RevisionComposite.this.additionalValidation();
            }
        });
        if (this.checkStyled) {
            this.reverseRevisionsButton = new Button((Composite)group, 32);
            this.reverseRevisionsButton.setText(ModelBusTeamUIPlugin.instance().getResource("RevisionComposite.Reverse"));
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.reverseRevisionsButton.setLayoutData((Object)data);
            this.reverseRevisionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.reverseRevisions = ((Button)e.widget).getSelection();
                }
            });
        }
        this.defaultToRevisions();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.headRevisionRadioButton.setEnabled(enabled);
        if (this.checkStyled) {
            this.startFromCopyRadioButton.setEnabled(enabled);
            this.reverseRevisionsButton.setEnabled(enabled);
        } else {
            this.dateTimeRadioButton.setEnabled(enabled);
            this.dateField.setEnabled(enabled && this.dateTimeRadioButton.getSelection());
            this.timeField.setEnabled(enabled && this.dateTimeRadioButton.getSelection());
        }
        this.changeRevisionRadioButton.setEnabled(enabled);
        this.changeRevisionButton.setEnabled(enabled && this.changeRevisionRadioButton.getSelection());
        this.revisionField.setEnabled(enabled && this.changeRevisionRadioButton.getSelection());
    }

    public void additionalValidation() {
    }

    protected void dateTimeToRevision() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.dateField.getYear(), this.dateField.getMonth(), this.dateField.getDay(), this.timeField.getHours(), this.timeField.getMinutes(), this.timeField.getSeconds());
        this.selectedRevision = ModelBusRevision.fromDate((long)calendar.getTimeInMillis());
    }

    protected void defaultToRevisions() {
        if (this.checkStyled) {
            this.revisions = new ModelBusRevisionRange[]{new ModelBusRevisionRange(ModelBusRevision.START, this.defaultRevision)};
        } else {
            this.selectedRevision = this.defaultRevision;
        }
    }

    protected void textToRevisions() {
        String input = this.revisionField.getText();
        try {
            if (this.checkStyled) {
                String[] parts = input.split(",");
                ArrayList<ModelBusRevisionRange> revisions = new ArrayList<ModelBusRevisionRange>();
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    revisions.add(new ModelBusRevisionRange(part.trim()));
                    ++n2;
                }
                this.revisions = revisions.toArray(new ModelBusRevisionRange[revisions.size()]);
            } else {
                String selectedRevisionNum;
                this.lastSelectedRevision = selectedRevisionNum = input;
                this.selectedRevision = ModelBusRevision.fromString((String)selectedRevisionNum);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }
}

