/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.core.resource.SSHSettings;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.AbstractDynamicComposite;
import org.modelbus.team.eclipse.ui.composite.IPropertiesPanel;
import org.modelbus.team.eclipse.ui.composite.SecurityWarningComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.utility.UserInputHistory;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.CompositeVerifier;
import org.modelbus.team.eclipse.ui.verifier.ExistingResourceVerifier;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;
import org.modelbus.team.eclipse.ui.verifier.NonEmptyFieldVerifier;
import org.modelbus.team.eclipse.ui.verifier.ProxyPortVerifier;

public class SSHComposite
extends AbstractDynamicComposite
implements IPropertiesPanel {
    protected boolean callback;
    protected Button passwordRadioButton;
    protected Button privateKeyRadioButton;
    protected Text privateKeyFileText;
    protected Button browseButton;
    protected Text passphraseText;
    protected Button savePassphraseCheckBox;
    protected Text portText;
    protected IValidationManager validationManager;
    protected UserInputHistory userHistory;
    protected SSHSettings credentialsInput;
    protected boolean tempOptionsSaved;
    protected boolean tempPassBtnEnabled;
    protected boolean tempKeyBtnEnabled;
    protected boolean tempSavePassChecked;

    public SSHComposite(Composite parent, int style, IValidationManager validationManager) {
        this(parent, style, validationManager, false);
    }

    public SSHComposite(Composite parent, int style, IValidationManager validationManager, boolean callback) {
        super(parent, style);
        this.validationManager = validationManager;
        this.callback = callback;
        this.credentialsInput = new SSHSettings();
    }

    public SSHSettings getSSHSettingsDirect() {
        SSHSettings settings = new SSHSettings();
        this.getSSHSettingsDirectImpl(settings);
        return settings;
    }

    public void setSSHSettingsDirect(SSHSettings settings) {
        this.savePassphraseCheckBox.setSelection(settings.isPassPhraseSaved());
        this.privateKeyRadioButton.setSelection(settings.isUseKeyFile());
        this.passwordRadioButton.setSelection(!settings.isUseKeyFile());
        String text = settings.getPassPhrase();
        this.passphraseText.setText(text == null ? "" : text);
        text = settings.getPrivateKeyPath();
        this.privateKeyFileText.setText(text == null ? "" : text);
        this.portText.setText(String.valueOf(settings.getPort()));
        if (this.callback && text != null && text.length() > 0) {
            this.passphraseText.setFocus();
            this.passphraseText.selectAll();
        }
        this.refreshControlsEnablement();
    }

    @Override
    public void initialize() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 7;
        layout.verticalSpacing = 3;
        this.setLayout((Layout)layout);
        data = new GridData(1808);
        this.setLayoutData(data);
        Composite sshGroup = new Composite((Composite)this, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        sshGroup.setLayout((Layout)layout);
        sshGroup.setLayoutData((Object)data);
        Label lblPort = new Label(sshGroup, 0);
        lblPort.setText(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.Port"));
        this.portText = new Text(sshGroup, 2048);
        data = new GridData(768);
        this.portText.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = ModelBusTeamUIPlugin.instance().getResource("SSHComposite.Port.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ProxyPortVerifier(name));
        this.portText.setText(String.valueOf(22));
        this.validationManager.attachTo((Control)this.portText, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return SSHComposite.this.isVisible();
            }
        });
        Group passGroup = new Group((Composite)this, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.verticalSpacing = 12;
        passGroup.setLayout((Layout)layout);
        passGroup.setLayoutData((Object)data);
        passGroup.setText(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.Authentication"));
        Composite inner = new Composite((Composite)passGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        this.passwordRadioButton = new Button(inner, 16);
        data = new GridData(1);
        this.passwordRadioButton.setLayoutData((Object)data);
        this.passwordRadioButton.setText(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.Password"));
        this.passwordRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SSHComposite.this.refreshControlsEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.privateKeyRadioButton = new Button(inner, 16);
        data = new GridData();
        this.privateKeyRadioButton.setLayoutData((Object)data);
        this.privateKeyRadioButton.setText(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.PrivateKey"));
        this.privateKeyRadioButton.setSelection(false);
        Composite groupInner = new Composite(inner, 4);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        groupInner.setLayout((Layout)layout);
        data = new GridData(768);
        groupInner.setLayoutData((Object)data);
        Label description = new Label(groupInner, 0);
        description.setText(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.File"));
        data = new GridData(32);
        description.setLayoutData((Object)data);
        Composite privateKeyFileComposite = new Composite(groupInner, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        privateKeyFileComposite.setLayout((Layout)layout);
        privateKeyFileComposite.setLayoutData((Object)data);
        this.privateKeyFileText = new Text(privateKeyFileComposite, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.privateKeyFileText.setLayoutData((Object)data);
        this.validationManager.attachTo((Control)this.privateKeyFileText, new AbstractVerifierProxy(new ExistingResourceVerifier(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.File.Verifier"), true)){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return SSHComposite.this.privateKeyRadioButton.getSelection() && SSHComposite.this.isVisible();
            }
        });
        this.browseButton = new Button(privateKeyFileComposite, 8);
        this.browseButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData(128);
        data.widthHint = DefaultDialog.computeButtonWidth(this.browseButton);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(SSHComposite.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    SSHComposite.this.privateKeyFileText.setText(res);
                    SSHComposite.this.validationManager.validateContent();
                }
            }
        });
        description = new Label(groupInner, 0);
        description.setText(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.Passphrase"));
        data = new GridData(32);
        description.setLayoutData((Object)data);
        this.passphraseText = new Text(groupInner, 0x400800);
        data = new GridData(768);
        data.widthHint = 200;
        this.passphraseText.setLayoutData((Object)data);
        Composite savePassphrase = new Composite((Composite)passGroup, 4);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        savePassphrase.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        savePassphrase.setLayoutData((Object)data);
        this.savePassphraseCheckBox = new Button(savePassphrase, 32);
        this.savePassphraseCheckBox.setText(ModelBusTeamUIPlugin.instance().getResource("SSHComposite.SavePassphrase"));
        new SecurityWarningComposite(savePassphrase);
    }

    public void setCredentialsInput(SSHSettings input) {
        this.credentialsInput = input;
    }

    @Override
    public void saveChanges() {
        this.getSSHSettingsDirectImpl(this.credentialsInput);
    }

    @Override
    public void resetChanges() {
        this.setSSHSettingsDirect(this.credentialsInput);
    }

    @Override
    public void cancelChanges() {
    }

    protected void getSSHSettingsDirectImpl(SSHSettings settings) {
        settings.setPassPhraseSaved(this.savePassphraseCheckBox.getSelection());
        settings.setUseKeyFile(this.privateKeyRadioButton.getSelection());
        settings.setPassPhrase(this.passphraseText.getText());
        settings.setPrivateKeyPath(this.privateKeyFileText.getText());
        String port = this.portText.getText().trim();
        if (port.length() > 0) {
            settings.setPort(Integer.parseInt(port));
        }
    }

    protected void refreshControlsEnablement() {
        boolean buttonSelected = this.passwordRadioButton.getSelection();
        buttonSelected = this.privateKeyRadioButton.getSelection();
        this.privateKeyFileText.setEnabled(buttonSelected);
        this.browseButton.setEnabled(buttonSelected);
        this.passphraseText.setEnabled(buttonSelected);
        this.savePassphraseCheckBox.setEnabled(buttonSelected);
        this.validationManager.validateContent();
    }

    @Override
    public void saveAppearance() {
        this.tempPassBtnEnabled = this.passwordRadioButton.getSelection();
        this.tempKeyBtnEnabled = this.privateKeyRadioButton.getSelection();
        this.tempSavePassChecked = this.savePassphraseCheckBox.getSelection();
        this.tempOptionsSaved = true;
    }

    @Override
    public void restoreAppearance() {
        if (this.tempOptionsSaved) {
            this.passwordRadioButton.setSelection(this.tempPassBtnEnabled);
            this.privateKeyRadioButton.setSelection(this.tempKeyBtnEnabled);
            this.savePassphraseCheckBox.setSelection(this.tempSavePassChecked);
            this.tempOptionsSaved = false;
            this.refreshControlsEnablement();
        } else {
            this.resetChanges();
        }
    }

    @Override
    public void revalidateContent() {
        this.validationManager.validateContent();
    }
}

