/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.composite;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.modelbus.team.eclipse.core.resource.SSLSettings;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.IPropertiesPanel;
import org.modelbus.team.eclipse.ui.composite.SecurityWarningComposite;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.verifier.AbstractVerifierProxy;
import org.modelbus.team.eclipse.ui.verifier.ExistingResourceVerifier;
import org.modelbus.team.eclipse.ui.verifier.IValidationManager;

public class SSLComposite
extends Composite
implements IPropertiesPanel {
    protected boolean callback;
    protected Button enableAuthenticationCheckBox;
    protected Text certificateFileText;
    protected Button browseButton;
    protected Text certificatePassphraseText;
    protected Button savePassphraseCheckBox;
    protected IValidationManager validationManager;
    protected SSLSettings credentialsInput;

    public SSLComposite(Composite parent, int style, IValidationManager validationManager) {
        this(parent, style, validationManager, false);
    }

    public SSLComposite(Composite parent, int style, IValidationManager validationManager, boolean callback) {
        super(parent, style);
        this.validationManager = validationManager;
        this.callback = callback;
        this.credentialsInput = new SSLSettings();
    }

    public SSLSettings getSSLSettingsDirect() {
        SSLSettings settings = new SSLSettings();
        this.getSSLSettingsDirectImpl(settings);
        return settings;
    }

    public void setSSLSettingsDirect(SSLSettings settings) {
        this.savePassphraseCheckBox.setSelection(settings.isPassPhraseSaved());
        this.enableAuthenticationCheckBox.setSelection(settings.isAuthenticationEnabled());
        String text = settings.getPassPhrase();
        this.certificatePassphraseText.setText(text == null ? "" : text);
        text = settings.getCertificatePath();
        this.certificateFileText.setText(text == null ? "" : text);
        if (this.callback) {
            if (text != null && text.length() > 0) {
                this.certificatePassphraseText.setFocus();
                this.certificatePassphraseText.selectAll();
            } else {
                this.certificateFileText.setFocus();
            }
        }
        this.refreshControlsEnablement();
    }

    @Override
    public void initialize() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 7;
        layout.verticalSpacing = 3;
        data = new GridData(1808);
        this.setLayout((Layout)layout);
        this.setLayoutData(data);
        this.enableAuthenticationCheckBox = new Button((Composite)this, 32);
        data = new GridData(32);
        data.horizontalSpan = 2;
        this.enableAuthenticationCheckBox.setLayoutData((Object)data);
        this.enableAuthenticationCheckBox.setText(ModelBusTeamUIPlugin.instance().getResource("SSLComposite.EnableAuthentication"));
        this.enableAuthenticationCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SSLComposite.this.refreshControlsEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group group = new Group((Composite)this, 0);
        group.setText(ModelBusTeamUIPlugin.instance().getResource("SSLComposite.ClientCertificate"));
        layout = new GridLayout();
        layout.verticalSpacing = 12;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        Composite fileAndPassphrase = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        fileAndPassphrase.setLayout((Layout)layout);
        data = new GridData(768);
        fileAndPassphrase.setLayoutData((Object)data);
        Label description = new Label(fileAndPassphrase, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(ModelBusTeamUIPlugin.instance().getResource("SSLComposite.File"));
        Composite inner = new Composite(fileAndPassphrase, 4);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        inner.setLayoutData((Object)data);
        this.certificateFileText = new Text(inner, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.certificateFileText.setLayoutData((Object)data);
        this.validationManager.attachTo((Control)this.certificateFileText, new AbstractVerifierProxy(new ExistingResourceVerifier(ModelBusTeamUIPlugin.instance().getResource("SSLComposite.File.Verifier"), true)){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return SSLComposite.this.enableAuthenticationCheckBox.getSelection();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(ModelBusTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData(128);
        data.widthHint = DefaultDialog.computeButtonWidth(this.browseButton);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(SSLComposite.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    SSLComposite.this.certificateFileText.setText(res);
                    SSLComposite.this.validationManager.validateContent();
                }
            }
        });
        description = new Label(fileAndPassphrase, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(ModelBusTeamUIPlugin.instance().getResource("SSLComposite.Passphrase"));
        this.certificatePassphraseText = new Text(fileAndPassphrase, 0x400800);
        data = new GridData(768);
        data.widthHint = 200;
        this.certificatePassphraseText.setLayoutData((Object)data);
        inner = new Composite((Composite)group, 4);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        this.savePassphraseCheckBox = new Button(inner, 32);
        this.savePassphraseCheckBox.setText(ModelBusTeamUIPlugin.instance().getResource("SSLComposite.SavePassphrase"));
        new SecurityWarningComposite(inner);
    }

    public void setCredentialsInput(SSLSettings input) {
        this.credentialsInput = input;
    }

    @Override
    public void saveChanges() {
        this.getSSLSettingsDirectImpl(this.credentialsInput);
    }

    @Override
    public void resetChanges() {
        this.setSSLSettingsDirect(this.credentialsInput);
    }

    @Override
    public void cancelChanges() {
    }

    protected void getSSLSettingsDirectImpl(SSLSettings settings) {
        settings.setAuthenticationEnabled(this.enableAuthenticationCheckBox.getSelection());
        settings.setCertificatePath(this.certificateFileText.getText());
        settings.setPassPhrase(this.certificatePassphraseText.getText());
        settings.setPassPhraseSaved(this.savePassphraseCheckBox.getSelection());
    }

    protected void refreshControlsEnablement() {
        boolean enabled = this.enableAuthenticationCheckBox.getSelection();
        this.certificateFileText.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.certificatePassphraseText.setEnabled(enabled);
        this.savePassphraseCheckBox.setEnabled(enabled);
        this.validationManager.validateContent();
    }
}

