/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.console;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.part.FileEditorInput;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class LocalFileHyperlink
implements IHyperlink {
    protected String pathString;

    public LocalFileHyperlink(String pathString) {
        this.pathString = pathString;
    }

    public void linkActivated() {
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new OpenLocalFileOperation(this.pathString));
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    protected class OpenLocalFileOperation
    extends AbstractActionOperation {
        protected String filePath;

        public OpenLocalFileOperation(String filePath) {
            super("Operation.OpenLocalFile");
            this.filePath = filePath;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            IFile file;
            IWorkbenchWindow window = ModelBusTeamUIPlugin.instance().getWorkbench().getActiveWorkbenchWindow();
            if (window == null || window.getActivePage() == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (ResourcesPlugin.getWorkspace().getRoot() == null) {
                return;
            }
            IPath path = Path.fromOSString((String)this.filePath);
            if (!path.isAbsolute()) {
                path = path.makeAbsolute().setDevice(ResourcesPlugin.getWorkspace().getRoot().getLocation().getDevice());
            }
            if (!((file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path)) != null && file.exists() || path == null || path.isAbsolute() || path.segmentCount() <= 1)) {
                path = path.removeFirstSegments(1);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            if (file == null || !file.exists()) {
                return;
            }
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            if (registry == null) {
                return;
            }
            IEditorDescriptor descriptor = null;
            IContentDescription contentDescription = file.getContentDescription();
            descriptor = registry.getDefaultEditor(path.lastSegment(), contentDescription != null ? contentDescription.getContentType() : null);
            if (descriptor == null) {
                descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
            }
            if (descriptor == null) {
                return;
            }
            FileEditorInput input = new FileEditorInput(file);
            page.openEditor((IEditorInput)input, descriptor.getId());
        }
    }
}

