/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.console;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IConsoleStream;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class ModelBusConsole
extends MessageConsole
implements IPropertyChangeListener {
    public static final String ModelBus_CONSOLE_TYPE = "org.modelbus.team.eclipse.ui.console.ModelBusConsole";
    protected MessageConsoleStream cmdStream;
    protected MessageConsoleStream okStream;
    protected MessageConsoleStream warningStream;
    protected MessageConsoleStream errorStream;
    protected int autoshow;
    protected boolean enabled;

    public ModelBusConsole() {
        super(ModelBusTeamUIPlugin.instance().getResource("ModelBusConsole.Name"), ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/console.gif"));
        super.setType(ModelBus_CONSOLE_TYPE);
        super.init();
        this.setTabWidth(4);
        this.cmdStream = this.newMessageStream();
        this.okStream = this.newMessageStream();
        this.warningStream = this.newMessageStream();
        this.errorStream = this.newMessageStream();
        this.loadPreferences();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        ModelBusTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public IConsoleStream getConsoleStream() {
        return new ModelBusConsoleStream();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("preference.console.")) {
            this.loadPreferences();
        }
    }

    public void shutdown() {
        super.dispose();
        ModelBusTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        this.enabled = false;
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        Color tmp1 = this.cmdStream.getColor();
        Color tmp2 = this.okStream.getColor();
        Color tmp3 = this.warningStream.getColor();
        Color tmp4 = this.errorStream.getColor();
        try {
            this.cmdStream.close();
        }
        catch (Exception exception) {}
        try {
            this.okStream.close();
        }
        catch (Exception exception) {}
        try {
            this.warningStream.close();
        }
        catch (Exception exception) {}
        try {
            this.errorStream.close();
        }
        catch (Exception exception) {}
        if (tmp1 != null) {
            tmp1.dispose();
        }
        if (tmp1 != null) {
            tmp2.dispose();
        }
        if (tmp1 != null) {
            tmp3.dispose();
        }
        if (tmp1 != null) {
            tmp4.dispose();
        }
    }

    protected void init() {
    }

    protected void dispose() {
    }

    protected void loadPreferences() {
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        this.enabled = ModelBusTeamPreferences.getConsoleBoolean(store, "enabled");
        Color tmp = this.cmdStream.getColor();
        this.cmdStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), ModelBusTeamPreferences.getConsoleRGB(store, "command")));
        if (tmp != null && !tmp.equals((Object)this.cmdStream.getColor())) {
            tmp.dispose();
        }
        tmp = this.okStream.getColor();
        this.okStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), ModelBusTeamPreferences.getConsoleRGB(store, "ok")));
        if (tmp != null && !tmp.equals((Object)this.okStream.getColor())) {
            tmp.dispose();
        }
        tmp = this.warningStream.getColor();
        this.warningStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), ModelBusTeamPreferences.getConsoleRGB(store, "warning")));
        if (tmp != null && !tmp.equals((Object)this.warningStream.getColor())) {
            tmp.dispose();
        }
        tmp = this.errorStream.getColor();
        this.errorStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), ModelBusTeamPreferences.getConsoleRGB(store, "error")));
        if (tmp != null && !tmp.equals((Object)this.errorStream.getColor())) {
            tmp.dispose();
        }
        if (ModelBusTeamPreferences.getConsoleBoolean(store, "wrapEnabled")) {
            this.setConsoleWidth(ModelBusTeamPreferences.getConsoleInt(store, "wrapWidth"));
        } else {
            this.setConsoleWidth(-1);
        }
        this.autoshow = ModelBusTeamPreferences.getConsoleInt(store, "autoshow");
        if (ModelBusTeamPreferences.getConsoleBoolean(store, "limitEnabled")) {
            int limit = ModelBusTeamPreferences.getConsoleInt(store, "limitRange");
            this.setWaterMarks(1000 < limit ? 1000 : limit - 1, limit);
        } else {
            this.setWaterMarks(-1, 0);
        }
        UIMonitorUtility.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelBusConsole.this.setFont(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(ModelBusTeamPreferences.fullConsoleName("font")));
            }
        });
        if (this.enabled) {
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this});
        } else {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        }
    }

    protected class ModelBusConsoleStream
    implements IConsoleStream {
        protected long start;
        protected String buffer;
        protected boolean outputStarted;
        protected boolean hasError;
        protected boolean hasWarning;
        protected boolean activated;
        protected boolean cancelled;

        public void markEnd() {
            if (this.outputStarted) {
                this.write(0, "*** ");
                if (this.hasError) {
                    this.write(3, ModelBusTeamUIPlugin.instance().getResource("ModelBusConsole.Error"));
                } else if (this.hasWarning) {
                    this.write(2, ModelBusTeamUIPlugin.instance().getResource("ModelBusConsole.Warning"));
                } else {
                    this.write(0, this.cancelled ? ModelBusTeamUIPlugin.instance().getResource("ModelBusConsole.Cancelled") : ModelBusTeamUIPlugin.instance().getResource("ModelBusConsole.Ok"));
                }
                this.write(0, " " + ModelBusTeamUIPlugin.instance().getResource("ModelBusConsole.Took", new String[]{new SimpleDateFormat("mm:ss.SSS").format(new Date(System.currentTimeMillis() - this.start))}) + "\n\n");
            }
        }

        public void markStart(String data) {
            this.start = System.currentTimeMillis();
            this.buffer = data;
        }

        public void doComplexWrite(Runnable runnable) {
            this.flushBuffer();
            if (ModelBusConsole.this.enabled) {
                runnable.run();
            }
        }

        public void write(int severity, String data) {
            this.flushBuffer();
            if (ModelBusConsole.this.enabled) {
                if (!this.activated && (ModelBusConsole.this.autoshow == 1 || ModelBusConsole.this.autoshow == 2 && severity == 3 || ModelBusConsole.this.autoshow == 3 && (severity == 3 || severity == 2))) {
                    this.activated = true;
                    ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)ModelBusConsole.this);
                }
                switch (severity) {
                    case 0: {
                        this.print(ModelBusConsole.this.cmdStream, data);
                        break;
                    }
                    case 1: {
                        this.print(ModelBusConsole.this.okStream, data);
                        break;
                    }
                    case 2: {
                        this.hasWarning = true;
                        this.print(ModelBusConsole.this.warningStream, data);
                        break;
                    }
                    default: {
                        this.hasError = true;
                        this.print(ModelBusConsole.this.errorStream, data);
                    }
                }
            }
        }

        public void markCancelled() {
            this.cancelled = true;
        }

        protected void print(final MessageConsoleStream stream, final String data) {
            if (UIMonitorUtility.getDisplay().getThread() == Thread.currentThread()) {
                ProgressMonitorUtility.doTaskScheduledDefault((IActionOperation)new AbstractActionOperation("Operation.WriteToConsoleResources"){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        stream.print(data);
                    }
                }, (boolean)true);
            } else {
                stream.print(data);
            }
        }

        protected void flushBuffer() {
            this.outputStarted = true;
            if (this.buffer != null) {
                String tmp = this.buffer;
                this.buffer = null;
                this.write(0, "*** ");
                this.write(0, tmp);
                this.write(0, "\n");
            }
        }
    }
}

