/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.debugmail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.core.TeamPlugin;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.ModelBusTeamProvider;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.file.ModelBusFileStorage;
import org.modelbus.team.eclipse.core.operation.local.AbstractWorkingCopyOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.ui.debugmail.AbstractMainMenuAction;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class MigrateToEclipse
extends AbstractMainMenuAction {
    public static final String OLD_PROVIDER_ID = "org.polarion.team.modelbus.core.modelbusnature";
    public static final String OLD_STATE_LOCATION = "org.polarion.team.modelbus.core";
    public static final String OLD_PREFERENCES_LOCATION = "org.polarion.team.modelbus.ui";
    public static final QualifiedName OLD_RESOURCE_PROPERTY = new QualifiedName("org.polarion.team.modelbus", "resource");
    public static final QualifiedName OLD_LOCATION_PROPERTY = new QualifiedName("org.polarion.team.modelbus", "location");
    protected static final byte[] OLD_ENTRY1 = new byte[]{111, 114, 103, 46, 112, 111, 108, 97, 114, 105, 111, 110};
    protected static final byte[] NEW_ENTRY1 = new byte[]{111, 114, 103, 46, 101, 99, 108, 105, 112, 115, 101};
    protected static final byte[] OLD_ENTRY2 = new byte[]{76, 111, 114, 103, 47, 112, 111, 108, 97, 114, 105, 111, 110};
    protected static final byte[] NEW_ENTRY2 = new byte[]{76, 111, 114, 103, 47, 101, 99, 108, 105, 112, 115, 101};

    public void run(IAction action) {
        CompositeOperation op = new CompositeOperation("Operation.MigrateToEclipse");
        op.add((IActionOperation)new ConvertRepositoryFiles());
        op.add((IActionOperation)new ConvertSettings());
        RemapProjects remapOp = new RemapProjects();
        op.add((IActionOperation)remapOp);
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)remapOp, 1, RefreshResourcesOperation.REFRESH_CACHE));
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected static int replaceBinaryEntries(byte[] data, int writeLen, byte[] oldEntry, byte[] newEntry, boolean decrementPrevByte) {
        int i = MigrateToEclipse.findNextBinaryEntry(data, 0, writeLen, oldEntry);
        while (i < writeLen) {
            if (decrementPrevByte) {
                int n = i - 1;
                data[n] = (byte)(data[n] - 1);
            }
            int offs = 0;
            while (offs < newEntry.length && i < writeLen) {
                data[i] = newEntry[offs];
                ++i;
                ++offs;
            }
            System.arraycopy(data, i + 1, data, i, --writeLen - i);
            i = MigrateToEclipse.findNextBinaryEntry(data, i, writeLen, oldEntry);
        }
        return writeLen;
    }

    protected static int findNextBinaryEntry(byte[] data, int start, int len, byte[] oldEntry) {
        while (start < len) {
            block4: {
                if (data[start] == oldEntry[0]) {
                    int i = 1;
                    while (i < oldEntry.length && start + i < len) {
                        if (data[start + i] == oldEntry[i]) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return i < oldEntry.length ? len : start;
                }
            }
            ++start;
        }
        return len;
    }

    protected static class ConvertRepositoryFiles
    extends AbstractActionOperation {
        public ConvertRepositoryFiles() {
            super("Operation.ConvertRepositoryFiles");
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            IPath newStateLocation = ModelBusTeamPlugin.instance().getStateLocation();
            IPath oldStateLocation = newStateLocation.removeLastSegments(1).append(MigrateToEclipse.OLD_STATE_LOCATION);
            this.transformStoreFile(oldStateLocation.append(".modelbusRepositories").toFile(), newStateLocation.append(".modelbusRepositories").toFile());
            this.transformStoreFile(oldStateLocation.append(".externalModelBusRepositories").toFile(), newStateLocation.append(".externalModelBusRepositories").toFile());
            ModelBusRemoteStorage.instance().initialize(newStateLocation);
            ModelBusFileStorage.instance().initialize(newStateLocation);
            ModelBusRemoteStorage.instance().saveConfiguration();
            ModelBusFileStorage.instance().saveConfiguration();
        }

        protected void transformStoreFile(File oldFile, File newFile) throws Exception {
            if (!oldFile.exists()) {
                return;
            }
            byte[] data = new byte[(int)oldFile.length()];
            FileInputStream stream = new FileInputStream(oldFile);
            try {
                stream.read(data);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Exception exception) {}
            int writeLen = MigrateToEclipse.replaceBinaryEntries(data, data.length, OLD_ENTRY1, NEW_ENTRY1, true);
            writeLen = MigrateToEclipse.replaceBinaryEntries(data, writeLen, OLD_ENTRY2, NEW_ENTRY2, true);
            FileOutputStream out = new FileOutputStream(newFile);
            try {
                out.write(data, 0, writeLen);
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static class ConvertSettings
    extends AbstractActionOperation {
        public ConvertSettings() {
            super("Operation.ConvertSettings");
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    InstanceScope ctx = new InstanceScope();
                    IEclipsePreferences prefs = ctx.getNode(MigrateToEclipse.OLD_PREFERENCES_LOCATION);
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    try {
                        Platform.getPreferencesService().exportPreferences(prefs, (OutputStream)output, null);
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                    byte[] data = output.toByteArray();
                    int dataLen = MigrateToEclipse.replaceBinaryEntries(data, data.length, OLD_ENTRY1, NEW_ENTRY1, false);
                    ByteArrayInputStream input = new ByteArrayInputStream(data, 0, dataLen);
                    try {
                        Platform.getPreferencesService().importPreferences((InputStream)input);
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }

    protected static class RemapProjects
    extends AbstractWorkingCopyOperation
    implements IResourceProvider {
        protected List<IProject> processed;

        public RemapProjects() {
            super("Operation.RemapProjects", null);
        }

        public IResource[] getResources() {
            return (IResource[])this.processed.toArray(new IProject[this.processed.size()]);
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            this.processed = new ArrayList<IProject>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isAccessible()) {
                    final IProject current = projects[i];
                    this.protectStep(new IUnprotectedOperation(){

                        public void run(IProgressMonitor monitor) throws Exception {
                            RemapProjects.this.processProject(current);
                        }
                    }, monitor, projects.length);
                }
                ++i;
            }
        }

        protected void processProject(IProject current) throws Exception {
            String id = current.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY);
            if (MigrateToEclipse.OLD_PROVIDER_ID.equals(id)) {
                String resourceProperty = current.getPersistentProperty(OLD_RESOURCE_PROPERTY);
                String locationProperty = current.getPersistentProperty(OLD_LOCATION_PROPERTY);
                try {
                    RepositoryProvider.unmap((IProject)current);
                }
                catch (Exception exception) {}
                current.setPersistentProperty(ModelBusTeamProvider.RESOURCE_PROPERTY, resourceProperty);
                current.setPersistentProperty(ModelBusTeamProvider.LOCATION_PROPERTY, locationProperty);
                RepositoryProvider.map((IProject)current, (String)"org.modelbus.team.eclipse.core.modelbusnature");
                this.processed.add(current);
            }
        }
    }
}

