/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.decorator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.core.resource.events.IResourceStatesListener;
import org.modelbus.team.eclipse.core.resource.events.ResourceStatesChangedEvent;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.decorator.DecoratorVariables;
import org.modelbus.team.eclipse.ui.decorator.IDecorationFilter;
import org.modelbus.team.eclipse.ui.decorator.IVariable;
import org.modelbus.team.eclipse.ui.decorator.IVariableContentProvider;
import org.modelbus.team.eclipse.ui.decorator.TextVariableSetProvider;
import org.modelbus.team.eclipse.ui.decorator.wrapper.ResourceDecoratorWrapper;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.DateFormatter;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public abstract class AbstractResourceDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    protected static final ImageDescriptor OVR_VERSIONED = TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif");
    protected static final ImageDescriptor OVR_ADDED = TeamImages.getImageDescriptor((String)"ovr/waiting_ovr.gif");
    protected static ImageDescriptor OVR_NEW = TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif");
    protected static ImageDescriptor OVR_MODIFIED = TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif");
    protected static ImageDescriptor OVR_CONFLICTED;
    protected static ImageDescriptor OVR_OBSTRUCTED;
    protected static ImageDescriptor OVR_DELETED;
    protected static ImageDescriptor OVR_LOCKED;
    protected static ImageDescriptor OVR_NEEDS_LOCK;
    protected static ImageDescriptor OVR_SWITCHED;
    protected static IResourceStatesListener installedListener;
    protected static int instanceCounter;
    protected IPropertyChangeListener configurationListener;
    protected boolean indicateConflicted;
    protected boolean indicateModified;
    protected boolean indicateDeleted;
    protected boolean indicateRemote;
    protected boolean indicateAdded;
    protected boolean indicateNew;
    protected boolean indicateLocked;
    protected boolean indicateNeedsLock;
    protected boolean indicateSwitched;
    protected String outgoingChars;
    protected String addedChars;
    protected String trunkPrefix;
    protected String branchPrefix;
    protected String tagPrefix;
    protected boolean useFonts;
    protected IDecorationFilter filter;
    protected Font ignoredFont;
    protected Font changedFont;
    protected Color ignoredForegroundColor;
    protected Color ignoredBackgroundColor;
    protected Color changedForegroundColor;
    protected Color changedBackgroundColor;
    protected IVariable[] format;
    protected DecoratorVariables decorator;

    static {
        installedListener = null;
        instanceCounter = 0;
    }

    public AbstractResourceDecorator(IResourceStatesListener targetListener) {
        this.initStatic(this, targetListener);
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("preference.decoration.") || event.getProperty().startsWith("preference.dateFormat.")) {
                    AbstractResourceDecorator.this.loadConfiguration();
                    String decoratorId = ResourceDecoratorWrapper.class.getName();
                    ModelBusTeamUIPlugin.instance().getWorkbench().getDecoratorManager().update(decoratorId);
                }
            }
        };
        this.filter = ExtensionsManager.getInstance().getCurrentDecorationFilter();
        ModelBusTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener(this.configurationListener);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener(this.configurationListener);
        this.decorator = new DecoratorVariables(TextVariableSetProvider.instance);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener(this.configurationListener);
        ModelBusTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener(this.configurationListener);
        this.finiStatic();
        super.dispose();
    }

    public final void decorate(Object element, IDecoration decoration) {
        try {
            int mask;
            IResource resource = this.getResource(element);
            if (resource == null || RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.modelbus.team.eclipse.core.modelbusnature") == null || !this.filter.isAcceptable(resource)) {
                return;
            }
            ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(resource);
            IRepositoryResource remote = ModelBusRemoteStorage.instance().asRepositoryResource(resource);
            if (IStateFilter.SF_INTERNAL_INVALID.accept(local) || remote == null) {
                return;
            }
            String localStatus = this.getStatus(local);
            if (!IStateFilter.SF_NOTEXISTS.accept(resource, localStatus, mask = local.getChangeMask())) {
                if (this.format == null) {
                    this.loadConfiguration();
                    localStatus = this.getStatus(local);
                }
                this.decorateImpl(remote, local, resource, localStatus, mask, decoration);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void decorateImpl(final IRepositoryResource remote, final ILocalResource local, final IResource resource, final String state, final int mask, IDecoration decoration) {
        if (local.isLocked() && this.indicateLocked) {
            decoration.addOverlay(OVR_LOCKED);
        } else if (IStateFilter.SF_IGNORED.accept(resource, state, mask)) {
            if (this.useFonts) {
                decoration.setBackgroundColor(this.ignoredBackgroundColor);
                decoration.setForegroundColor(this.ignoredForegroundColor);
                decoration.setFont(this.ignoredFont);
            }
        } else if (IStateFilter.SF_NEW.accept(resource, state, mask)) {
            if (this.indicateNew) {
                decoration.addOverlay(OVR_NEW);
            }
        } else if (this.indicateNeedsLock && IStateFilter.SF_NEEDS_LOCK.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_NEEDS_LOCK);
        } else if (IStateFilter.SF_ADDED.accept(resource, state, mask)) {
            if (this.indicateAdded) {
                decoration.addOverlay(OVR_ADDED);
            }
        } else if (IStateFilter.SF_DELETED.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_DELETED);
        } else if (IStateFilter.SF_CONFLICTING.accept(resource, state, mask)) {
            if (this.indicateConflicted) {
                decoration.addOverlay(OVR_CONFLICTED);
            } else if (this.indicateModified) {
                decoration.addOverlay(OVR_MODIFIED);
            } else if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        } else if (IStateFilter.SF_MODIFIED.accept(resource, state, mask)) {
            if (this.indicateModified) {
                decoration.addOverlay(OVR_MODIFIED);
            } else if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        } else if (IStateFilter.SF_OBSTRUCTED.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_OBSTRUCTED);
        } else if (IStateFilter.SF_VERSIONED.accept(resource, state, mask)) {
            if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        }
        if (this.useFonts && IStateFilter.SF_ANY_CHANGE.accept(resource, state, mask)) {
            decoration.setBackgroundColor(this.changedBackgroundColor);
            decoration.setForegroundColor(this.changedForegroundColor);
            decoration.setFont(this.changedFont);
        }
        this.decorator.decorateText(decoration, this.format, new IVariableContentProvider(){

            @Override
            public String getValue(IVariable var) {
                if (var.equals(TextVariableSetProvider.VAR_ADDED_FLAG)) {
                    return IStateFilter.SF_ADDED.accept(resource, state, mask) ? AbstractResourceDecorator.this.addedChars : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_OUTGOING_FLAG)) {
                    return IStateFilter.SF_COMMITABLE.accept(resource, state, mask) || IStateFilter.SF_CONFLICTING.accept(resource, state, mask) ? AbstractResourceDecorator.this.outgoingChars : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_REVISION)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(resource, state, mask) ? String.valueOf(local.getRevision()) : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_AUTHOR)) {
                    String author = local.getAuthor() == null ? "[no author]" : local.getAuthor();
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? author : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_DATE)) {
                    if (!IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return "";
                    }
                    long date = local.getLastCommitDate();
                    if (date == 0L) {
                        return ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoDate");
                    }
                    return DateFormatter.formatDate(date);
                }
                if (var.equals(TextVariableSetProvider.VAR_RESOURCE_URL)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? ModelBusUtility.decodeURL((String)remote.getUrl()) : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_SHORT_RESOURCE_URL)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        String shortURL = ModelBusUtility.decodeURL((String)remote.getUrl()).substring(ModelBusConnector.getRepositoryRootUrl().length());
                        return shortURL.startsWith("/") ? shortURL.substring(1) : shortURL;
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_LOCATION_URL)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? remote.getUrl() : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_LOCATION_LABEL)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return "TODOMWA2";
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_ROOT_PREFIX)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        int kind = ((IRepositoryRoot)remote.getRoot()).getKind();
                        return kind == 3 ? AbstractResourceDecorator.this.tagPrefix : (kind == 2 ? AbstractResourceDecorator.this.branchPrefix : (kind == 1 ? AbstractResourceDecorator.this.trunkPrefix : ""));
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_ASCENDANT)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return ModelBusUtility.getAscendant((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_DESCENDANT)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return ModelBusUtility.getDescendant((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_FULLNAME)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return ModelBusUtility.getPathUpToRoot((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_REMOTE_NAME)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? remote.getName() : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_NAME)) {
                    return local.getName();
                }
                return var.toString();
            }
        });
    }

    protected abstract String getStatus(ILocalResource var1);

    protected IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    protected void loadConfiguration() {
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        this.indicateConflicted = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.conflicted");
        this.indicateModified = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.modified");
        this.indicateRemote = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.remote");
        this.indicateAdded = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.added");
        this.indicateNew = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.new");
        this.indicateLocked = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.locked");
        this.indicateNeedsLock = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.needslock");
        this.indicateSwitched = ModelBusTeamPreferences.getDecorationBoolean(store, "icon.switched");
        this.outgoingChars = ModelBusTeamPreferences.getDecorationString(store, "flag.outgoing");
        this.addedChars = ModelBusTeamPreferences.getDecorationString(store, "flag.added");
        this.trunkPrefix = ModelBusTeamPreferences.getDecorationString(store, "trunk.branch");
        this.branchPrefix = ModelBusTeamPreferences.getDecorationString(store, "prefix.branch");
        this.tagPrefix = ModelBusTeamPreferences.getDecorationString(store, "prefix.tag");
        this.useFonts = ModelBusTeamPreferences.getDecorationBoolean(store, "use.fontdecor");
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                AbstractResourceDecorator.this.ignoredFont = current.getFontRegistry().get(ModelBusTeamPreferences.fullDecorationName("ignored_resource_font"));
                AbstractResourceDecorator.this.changedFont = current.getFontRegistry().get(ModelBusTeamPreferences.fullDecorationName("outgoing_change_font"));
                AbstractResourceDecorator.this.ignoredForegroundColor = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("ignored_resource_foreground_color"));
                AbstractResourceDecorator.this.ignoredBackgroundColor = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("ignored_resource_background_color"));
                AbstractResourceDecorator.this.changedForegroundColor = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("outgoing_change_foreground_color"));
                AbstractResourceDecorator.this.changedBackgroundColor = current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("outgoing_change_background_color"));
            }
        });
    }

    protected synchronized void initStatic(final AbstractResourceDecorator self, final IResourceStatesListener targetListener) {
        if (instanceCounter++ == 0) {
            OVR_NEW = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/new_resource.gif");
            OVR_CONFLICTED = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/conflicted_unresolved.gif");
            OVR_OBSTRUCTED = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/obstructed.gif");
            OVR_DELETED = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/deleted.gif");
            OVR_LOCKED = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/lock.gif");
            OVR_NEEDS_LOCK = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/needs_lock.gif");
            OVR_SWITCHED = ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/overlays/switched.gif");
            installedListener = new IResourceStatesListener(){

                public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                    if (targetListener != null) {
                        targetListener.resourcesStateChanged(event);
                    } else {
                        self.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)self, (Object[])event.getResourcesRecursivelly()));
                    }
                }
            };
            ModelBusRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, installedListener);
        }
    }

    protected synchronized void finiStatic() {
        if (--instanceCounter == 0) {
            ModelBusRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, installedListener);
            installedListener = null;
        }
    }
}

