/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.decorator;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.IDecoration;
import org.modelbus.team.eclipse.ui.decorator.IVariable;
import org.modelbus.team.eclipse.ui.decorator.IVariableContentProvider;
import org.modelbus.team.eclipse.ui.decorator.IVariableSetProvider;
import org.modelbus.team.eclipse.ui.decorator.UserVariable;

public final class DecoratorVariables {
    protected IVariableSetProvider variableSetProvider;

    private String getValue(IVariable var, IVariableContentProvider provider) {
        return this.amend(var, provider);
    }

    private String amend(IVariable var, IVariableContentProvider provider) {
        IVariable[] variables = this.parseFormatLine(provider.getValue(var));
        String value = "";
        int i = 0;
        while (i < variables.length) {
            String variableValue = provider.getValue(variables[i]);
            value = !variables[i].equals(var) ? String.valueOf(value) + variableValue : (variableValue.equals(variables[i].getName()) ? String.valueOf(value) + variableValue : String.valueOf(value) + "?{" + variables[i].getName() + "}?");
            ++i;
        }
        return value;
    }

    public void decorateText(IDecoration decoration, IVariable[] format, IVariableContentProvider provider) {
        int centerPoint = Arrays.asList(format).indexOf(this.variableSetProvider.getCenterVariable());
        String prefix = "";
        String suffix = "";
        int i = 0;
        while (i < format.length) {
            if (!format[i].equals(this.variableSetProvider.getCenterVariable())) {
                if (centerPoint != -1 && i < centerPoint) {
                    prefix = String.valueOf(prefix) + this.getValue(format[i], provider);
                } else {
                    suffix = String.valueOf(suffix) + this.getValue(format[i], provider);
                }
            }
            ++i;
        }
        i = 0;
        while (i < prefix.length() && Character.isWhitespace(prefix.charAt(i))) {
            ++i;
        }
        prefix = prefix.substring(i);
        i = suffix.length() - 1;
        while (i >= 0 && Character.isWhitespace(suffix.charAt(i))) {
            --i;
        }
        suffix = suffix.substring(0, i + 1);
        decoration.addPrefix(prefix);
        decoration.addSuffix(suffix);
    }

    public static String prepareFormatLine(IVariable[] format) {
        String retVal = "";
        int i = 0;
        while (i < format.length) {
            retVal = format[i] instanceof UserVariable ? String.valueOf(retVal) + format[i].getName() : String.valueOf(retVal) + "{" + format[i].getName() + "}";
            ++i;
        }
        return retVal;
    }

    public IVariable[] parseFormatLine(String line) {
        ArrayList<IVariable> retVal = new ArrayList<IVariable>();
        int startPos = 0;
        int stopPos = -1;
        int state = 0;
        do {
            switch (state) {
                case 0: {
                    String userData;
                    stopPos = line.indexOf(123, startPos);
                    String string = userData = stopPos != -1 ? line.substring(startPos, stopPos++) : line.substring(startPos);
                    if (userData.length() > 0) {
                        retVal.add(new UserVariable(this.variableSetProvider.getDomainName(), userData));
                    }
                    startPos = stopPos;
                    state = 1;
                    break;
                }
                case 1: {
                    String userData;
                    stopPos = line.indexOf(125, startPos);
                    if (stopPos != -1) {
                        String varName;
                        if ((varName = line.substring(startPos, stopPos++)).length() > 0) {
                            IVariable var = this.variableSetProvider.getVariable(varName);
                            retVal.add(var == null ? new UserVariable(this.variableSetProvider.getDomainName(), varName) : var);
                        }
                    } else {
                        userData = line.substring(startPos);
                        if (userData.length() > 0) {
                            retVal.add(new UserVariable(this.variableSetProvider.getDomainName(), userData));
                        }
                    }
                    startPos = stopPos;
                    state = 0;
                }
            }
        } while (stopPos > 0);
        return retVal.toArray(new IVariable[retVal.size()]);
    }

    public DecoratorVariables(IVariableSetProvider variableSetProvider) {
        this.variableSetProvider = variableSetProvider;
    }
}

