/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.dialog;

import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.AbstractAdvancedDialogPanel;
import org.modelbus.team.eclipse.ui.panel.IDialogManagerEx;

public class AdvancedDialog
extends DefaultDialog
implements IDialogManagerEx {
    protected Button[] buttonsEx;
    protected String[] buttonLabelsEx;
    protected int basePanelButtonsCount;
    protected int focusButtonIdx;

    public AdvancedDialog(Shell parentShell, AbstractAdvancedDialogPanel panel) {
        super(parentShell, panel);
        this.basePanelButtonsCount = panel.getButtonNames().length;
        this.buttonLabelsEx = panel.getButtonNamesEx();
    }

    public AdvancedDialog(Shell parentShell, AbstractAdvancedDialogPanel panel, int focusButtonIdx) {
        super(parentShell, panel);
        this.basePanelButtonsCount = panel.getButtonNames().length;
        this.buttonLabelsEx = panel.getButtonNamesEx();
        this.focusButtonIdx = focusButtonIdx;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId < this.basePanelButtonsCount) {
            this.baseButtonPressed(buttonId);
        } else {
            this.extendedButtonPressed(buttonId - this.basePanelButtonsCount);
        }
    }

    protected void baseButtonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void extendedButtonPressed(int buttonId) {
        ((AbstractAdvancedDialogPanel)this.panel).extendedButtonPressed(buttonId);
    }

    @Override
    protected Control createButtonPanel(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite buttonPanel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        buttonPanel.setLayout((Layout)layout);
        data = new GridData(768);
        buttonPanel.setLayoutData((Object)data);
        this.createExtendedButtonPanel(buttonPanel);
        this.createBaseButtonPanel(buttonPanel);
        ArrayList<Button> allButtons = new ArrayList<Button>();
        int i = 0;
        while (i < this.getButtonLabels().length) {
            allButtons.add(this.getButton(i));
            ++i;
        }
        this.setButtons(allButtons.toArray(new Button[allButtons.size()]));
        if (this.focusButtonIdx != 0) {
            this.getShell().setDefaultButton(this.getButton(this.focusButtonIdx));
        }
        return buttonPanel;
    }

    protected Control createExtendedButtonPanel(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite buttonPanel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonPanel.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalAlignment = 16384;
        buttonPanel.setLayoutData((Object)data);
        return this.createExtendedButtonBar(buttonPanel);
    }

    protected Control createBaseButtonPanel(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite buttonPanel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonPanel.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalAlignment = 131072;
        buttonPanel.setLayoutData((Object)data);
        return this.createButtonBar(buttonPanel);
    }

    protected Control createExtendedButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForExtendedButtonBar(composite);
        return composite;
    }

    protected void createButtonsForExtendedButtonBar(Composite parent) {
        this.buttonsEx = new Button[this.buttonLabelsEx.length];
        int i = 0;
        while (i < this.buttonsEx.length) {
            Button button;
            String label = this.buttonLabelsEx[i];
            this.buttonsEx[i] = button = this.createButton(parent, this.basePanelButtonsCount + i, label, false);
            ++i;
        }
    }

    public Button getButtonEx(int idx) {
        return this.buttonsEx[idx];
    }

    public void setButtonEx(Button[] newButtons) {
        this.buttonsEx = newButtons;
    }

    @Override
    public void setExtendedButtonEnabled(int idx, boolean enabled) {
        this.buttonsEx[idx].setEnabled(enabled);
    }

    @Override
    public void setExtendedButtonCaption(int idx, String text) {
        this.buttonsEx[idx].setText(text);
    }
}

