/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.extension.impl;

import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.LocateProjectsOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceProvider;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.remote.CheckoutAction;
import org.modelbus.team.eclipse.ui.extension.factory.ICheckoutFactory;

public class DefaultCheckoutFactory
implements ICheckoutFactory {
    @Override
    public LocateProjectsOperation.ILocateFilter getLocateFilter() {
        return new EclipseProjectsFilter();
    }

    @Override
    public IActionOperation getCheckoutOperation(Shell shell, IRepositoryResource[] remote, HashMap checkoutMap, boolean respectHierarchy, String location, int recurseDepth, boolean ignoreExternals) {
        return CheckoutAction.getCheckoutOperation(shell, remote, checkoutMap, respectHierarchy, location, recurseDepth, ignoreExternals);
    }

    @Override
    public ITableLabelProvider getLabelProvider(HashMap resources2names) {
        return new LabelProvider(resources2names);
    }

    @Override
    public IRepositoryResourceProvider additionalProcessing(CompositeOperation op, IRepositoryResourceProvider provider) {
        return provider;
    }

    @Override
    public HashMap prepareName2resources(HashMap name2resources) {
        return name2resources;
    }

    @Override
    public boolean findProjectsOptionEnabled() {
        return false;
    }

    protected class EclipseProjectsFilter
    implements LocateProjectsOperation.ILocateFilter {
        protected EclipseProjectsFilter() {
        }

        public boolean isProject(IRepositoryResource remote, IRepositoryResource[] children) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IRepositoryFile && children[i].getName().equals(".project")) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    protected class LabelProvider
    implements ITableLabelProvider {
        protected HashMap resources2names;

        public LabelProvider(HashMap resources2names) {
            this.resources2names = resources2names;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IRepositoryResource resource = (IRepositoryResource)element;
            switch (columnIndex) {
                case 1: {
                    return resource.getUrl();
                }
                case 2: {
                    return FileUtility.formatResourceName((String)((String)this.resources2names.get(resource)));
                }
                case 3: {
                    return ModelBusTeamUIPlugin.instance().getResource("DefaultCheckoutFactory.EclipseProject");
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

