/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.CompareRevisionAction;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusDiffStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryInfo;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryReference;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusLogPath;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.history.ModelBusRemoteResourceRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IResourcePropertyProvider;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.operation.local.FiniExtractLogOperation;
import org.modelbus.team.eclipse.core.operation.local.GetRemoteContentsOperation;
import org.modelbus.team.eclipse.core.operation.local.InitExtractLogOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.UpdateOperation;
import org.modelbus.team.eclipse.core.operation.remote.ExportOperation;
import org.modelbus.team.eclipse.core.operation.remote.ExtractToOperationRemote;
import org.modelbus.team.eclipse.core.operation.remote.GetRemotePropertiesOperation;
import org.modelbus.team.eclipse.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.modelbus.team.eclipse.core.operation.remote.PreparedBranchTagOperation;
import org.modelbus.team.eclipse.core.operation.remote.management.AddRevisionLinkOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryFile;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceProvider;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceWithStatusProvider;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.action.remote.BranchTagAction;
import org.modelbus.team.eclipse.ui.action.remote.CreatePatchAction;
import org.modelbus.team.eclipse.ui.action.remote.OpenFileAction;
import org.modelbus.team.eclipse.ui.action.remote.OpenFileWithAction;
import org.modelbus.team.eclipse.ui.action.remote.OpenFileWithExternalAction;
import org.modelbus.team.eclipse.ui.action.remote.OpenFileWithInplaceAction;
import org.modelbus.team.eclipse.ui.compare.TwoWayPropertyCompareInput;
import org.modelbus.team.eclipse.ui.dialog.ReplaceWarningDialog;
import org.modelbus.team.eclipse.ui.history.IModelBusHistoryView;
import org.modelbus.team.eclipse.ui.history.data.AffectedPathsNode;
import org.modelbus.team.eclipse.ui.history.data.ModelBusChangedPathData;
import org.modelbus.team.eclipse.ui.history.data.ModelBusLocalFileRevision;
import org.modelbus.team.eclipse.ui.history.model.ILogNode;
import org.modelbus.team.eclipse.ui.history.model.ModelBusLogNode;
import org.modelbus.team.eclipse.ui.operation.CompareRepositoryResourcesOperation;
import org.modelbus.team.eclipse.ui.operation.CompareResourcesOperation;
import org.modelbus.team.eclipse.ui.operation.OpenRemoteFileOperation;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.operation.RemoteShowAnnotationOperation;
import org.modelbus.team.eclipse.ui.operation.ShowHistoryViewOperation;
import org.modelbus.team.eclipse.ui.operation.ShowPropertiesOperation;
import org.modelbus.team.eclipse.ui.operation.ShowRevisionPropertiesOperation;
import org.modelbus.team.eclipse.ui.operation.UILoggedOperation;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFile;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFolder;
import org.modelbus.team.eclipse.ui.utility.LockProposeUtility;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;
import org.modelbus.team.eclipse.ui.wizard.CreatePatchWizard;

public class HistoryActionManager {
    protected IModelBusHistoryView view;
    protected ModelBusRevision selectedRevision;
    public final IControlActionManager affectedTableManager;
    public final IControlActionManager affectedTreeManager;
    public final IControlActionManager logMessagesManager;

    public HistoryActionManager(IModelBusHistoryView info) {
        this.view = info;
        this.affectedTableManager = new AffectedTableActionManager();
        this.affectedTreeManager = new AffectedTreeActionManager();
        this.logMessagesManager = new LogMessagesActionManager();
    }

    public ModelBusRevision getSelectedRevision() {
        return this.selectedRevision;
    }

    public void setSelectedRevision(ModelBusRevision selectedRevision) {
        this.selectedRevision = selectedRevision;
    }

    protected Action addMenuItem(StructuredViewer viewer, MenuManager menuManager, String label, final AbstractRepositoryTeamAction action) {
        IStructuredSelection tSelection = (IStructuredSelection)viewer.getSelection();
        Action wrapper = new Action(label){

            public void run() {
                action.run((IAction)this);
            }
        };
        StructuredSelection resourceSelection = tSelection.size() == 1 && ((ILogNode)tSelection.getFirstElement()).getType() == 2 ? new StructuredSelection((Object)new RepositoryFile(null, this.getResourceForSelectedRevision((ModelBusLogEntry)((ILogNode)tSelection.getFirstElement()).getEntity()))) : new StructuredSelection((Object)StructuredSelection.EMPTY);
        action.selectionChanged((IAction)wrapper, (ISelection)resourceSelection);
        menuManager.add((IAction)wrapper);
        return wrapper;
    }

    protected void getRevisionContents(ModelBusLogEntry item) {
        ILocalResource local;
        IRepositoryResource remote = this.getResourceForSelectedRevision(item);
        boolean canWrite = true;
        if (this.view.getResource() instanceof IFile && !(local = ModelBusRemoteStorage.instance().asLocalResource(this.view.getResource())).isLocked() && IStateFilter.SF_NEEDS_LOCK.accept(local)) {
            canWrite = LockProposeUtility.proposeLock(new IResource[]{this.view.getResource()});
        }
        if (canWrite) {
            HashMap<String, String> remote2local = new HashMap<String, String>();
            remote2local.put(ModelBusUtility.encodeURL((String)remote.getUrl()), FileUtility.getWorkingCopyPath((IResource)this.view.getResource()));
            GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(new IResource[]{this.view.getResource()}, new IRepositoryResource[]{remote}, remote2local);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{this.view.getResource()}));
            UIMonitorUtility.doTaskScheduledWorkspaceModify((IActionOperation)op);
        }
    }

    protected void doExport(ILogNode item) {
        if (item.getType() == 3) {
            final ModelBusLocalFileRevision revision = (ModelBusLocalFileRevision)((Object)item.getEntity());
            FileDialog dlg = new FileDialog(UIMonitorUtility.getShell(), 40960);
            dlg.setText(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.Title"));
            dlg.setFileName(revision.getName());
            dlg.setFilterExtensions(new String[]{"*.*"});
            final String file = dlg.open();
            if (file != null) {
                AbstractActionOperation op = new AbstractActionOperation("Operation.ExportLocalHistory"){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        FileOutputStream output = new FileOutputStream(file);
                        InputStream input = null;
                        try {
                            IStorage storage = revision.getStorage(monitor);
                            input = storage.getContents();
                            byte[] data = new byte[2048];
                            int len = 0;
                            while ((len = input.read(data)) > 0) {
                                output.write(data, 0, len);
                            }
                        }
                        finally {
                            output.close();
                            if (input != null) {
                                input.close();
                            }
                        }
                    }
                };
                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
            }
        } else {
            DirectoryDialog fileDialog = new DirectoryDialog(UIMonitorUtility.getShell());
            fileDialog.setText(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder"));
            fileDialog.setMessage(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder.Msg"));
            String path = fileDialog.open();
            if (path != null) {
                IRepositoryResource resource = this.traceResourceToRevision((ModelBusLogEntry)item.getEntity());
                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new ExportOperation(new IRepositoryResource[]{resource}, path, 3));
            }
        }
    }

    protected IRepositoryResource traceResourceToRevision(ModelBusLogEntry to) {
        IRepositoryResource resource = this.getResourceForSelectedRevision(to);
        String rootUrl = "";
        String url = this.traceUrlToRevision(rootUrl, resource.getUrl().substring(rootUrl.length()), this.view.getCurrentRevision(), to.modelBusRevision);
        IRepositoryFile retVal = resource instanceof IRepositoryFile ? resource.asRepositoryFile(url, false) : resource.asRepositoryContainer(url, false);
        retVal.setPegRevision(ModelBusRevision.fromString((String)to.revision));
        return retVal;
    }

    protected void addRevisionLinks(ILogNode[] tSelection) {
        CompositeOperation op = new CompositeOperation("Operation.HAddSelectedRevision");
        ILogNode[] iLogNodeArray = tSelection;
        int n = tSelection.length;
        int n2 = 0;
        while (n2 < n) {
            ILogNode node = iLogNodeArray[n2];
            ModelBusLogEntry item = (ModelBusLogEntry)node.getEntity();
            IRepositoryResource resource = ModelBusUtility.copyOf((IRepositoryResource)this.view.getRepositoryResource());
            resource.setSelectedRevision(ModelBusRevision.fromString((String)item.revision));
            LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{resource});
            op.add((IActionOperation)locateOp);
            op.add((IActionOperation)new AddRevisionLinkOperation((IRepositoryResourceProvider)locateOp, item.revision), new IActionOperation[]{locateOp});
            ++n2;
        }
        UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
    }

    protected void updateTo(ModelBusLogEntry item) {
        IResource[] resources = new IResource[]{this.view.getResource()};
        CompositeOperation op = new CompositeOperation("Operation.HUpdateTo");
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)new UpdateOperation(resources, ModelBusRevision.fromString((String)item.revision), true));
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources));
        UIMonitorUtility.doTaskScheduledWorkspaceModify((IActionOperation)op);
    }

    protected void createPatch(ILogNode[] selected) {
        CreatePatchWizard wizard = new CreatePatchWizard(this.view.getRepositoryResource().getName());
        WizardDialog dialog = new WizardDialog(UIMonitorUtility.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            ModelBusLogEntry msg0 = (ModelBusLogEntry)selected[0].getEntity();
            IRepositoryResource next = this.getResourceForSelectedRevision(msg0);
            IRepositoryResource prev = null;
            if (selected.length == 1) {
                prev = this.getResourceForSelectedRevision(new ModelBusLogEntry(msg0.modelBusRevision.getPreviousRevision().getRevision(), 0L, null, null, null, false));
            } else {
                ModelBusLogEntry msg1 = (ModelBusLogEntry)selected[1].getEntity();
                prev = this.getResourceForSelectedRevision(msg1);
                if (msg0.date < msg1.date) {
                    IRepositoryResource tmp = next;
                    next = prev;
                    prev = tmp;
                }
            }
            UIMonitorUtility.doTaskScheduledDefault(UIMonitorUtility.getActivePart(), CreatePatchAction.getCreatePatchOperation(prev, next, wizard));
        }
    }

    protected void handleCopy(ILogNode[] selection) {
        String historyText = this.getSelectedMessagesAsString(selection);
        Clipboard clipboard = new Clipboard(UIMonitorUtility.getDisplay());
        try {
            clipboard.setContents(new Object[]{historyText}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    public String getSelectedMessagesAsString(ILogNode[] selection) {
        String[] historyText = new String[]{""};
        HashSet<ILogNode> processed = new HashSet<ILogNode>();
        ModelBusRevision revision = this.view.getCurrentRevision();
        ILogNode[] iLogNodeArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            ILogNode node = iLogNodeArray[n2];
            this.toString(processed, node, revision, historyText);
            ++n2;
        }
        return historyText[0];
    }

    protected void toString(HashSet<ILogNode> processed, ILogNode node, ModelBusRevision revision, String[] retStr) {
        if (processed.contains(node)) {
            return;
        }
        processed.add(node);
        String toAdd = "";
        toAdd = String.valueOf(toAdd) + node.getLabel(0, 1, revision);
        int i = 1;
        while (i < 5) {
            toAdd = String.valueOf(toAdd) + "\t" + node.getLabel(i, 1, revision);
            ++i;
        }
        if (!(toAdd = toAdd.trim()).equals("")) {
            retStr[0] = String.valueOf(retStr[0]) + toAdd + System.getProperty("line.separator");
        }
        if (node.hasChildren()) {
            ILogNode[] children = node.getChildren();
            int j = 0;
            while (j < children.length) {
                this.toString(processed, children[j], revision, retStr);
                ++j;
            }
        }
    }

    protected String toString(HashSet<ILogNode> processed, ILogNode node, ModelBusRevision revision) {
        if (processed.contains(node)) {
            return "";
        }
        processed.add(node);
        String historyText = node.getLabel(0, 1, revision);
        int i = 1;
        while (i < 5) {
            historyText = String.valueOf(historyText) + "\t" + node.getLabel(i, 1, revision);
            ++i;
        }
        return String.valueOf(historyText) + System.getProperty("line.separator");
    }

    protected void handleDoubleClick(TreeViewer viewer, ILogNode item, boolean doubleClick) {
        int type = item.getType();
        if (type == 1) {
            if (viewer.getExpandedState((Object)item)) {
                viewer.collapseToLevel((Object)item, -1);
            } else {
                viewer.expandToLevel((Object)item, -1);
            }
            return;
        }
        boolean isCompareAllowed = true;
        if ((this.view.getOptions() & 2) != 0 && doubleClick && isCompareAllowed) {
            if (type == 2 && !(item.getParent() instanceof ModelBusLogNode)) {
                this.compareWithCurrent((ModelBusLogEntry)item.getEntity());
            } else if (type == 3) {
                this.runCompareForLocal(new Object[]{item});
            }
        } else if (type == 3) {
            try {
                ModelBusLocalFileRevision selected = (ModelBusLocalFileRevision)((Object)item.getEntity());
                Utils.openEditor((IWorkbenchPage)UIMonitorUtility.getActivePage(), (IFileRevision)selected, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                UILoggedOperation.reportError("Open Editor", ex);
            }
        } else if (!(this.view.getRepositoryResource() instanceof IRepositoryContainer) && type == 2 && !(item.getParent() instanceof ModelBusLogNode)) {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)this.getResourceForSelectedRevision((ModelBusLogEntry)item.getEntity())}, 0));
        }
    }

    protected void compareWithCurrent(ModelBusLogEntry item) {
        IRepositoryResource resource = this.getResourceForSelectedRevision(item);
        if (this.view.getResource() != null || this.view.getCompareWith() != null) {
            ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(this.view.getCompareWith());
            CompareResourcesOperation op = new CompareResourcesOperation(local, resource);
            op.setForceId(this.getCompareForceId());
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        } else {
            CompareRepositoryResourcesOperation op = new CompareRepositoryResourcesOperation(this.getResourceForHeadRevision(), resource);
            op.setForceId(this.getCompareForceId());
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        }
    }

    protected void runExtractTo(ILogNode[] selection) {
        IRepositoryResource remote;
        String path = null;
        DirectoryDialog fileDialog = new DirectoryDialog(UIMonitorUtility.getShell());
        fileDialog.setText(ModelBusTeamUIPlugin.instance().getResource("ExtractToAction.Select.Title"));
        fileDialog.setMessage(ModelBusTeamUIPlugin.instance().getResource("ExtractToAction.Select.Description"));
        path = fileDialog.open();
        if (path == null) {
            return;
        }
        ModelBusLogEntry[] selectedLogs = new ModelBusLogEntry[2];
        selectedLogs[0] = (ModelBusLogEntry)selection[0].getEntity();
        if (selection.length == 2) {
            selectedLogs[1] = (ModelBusLogEntry)selection[1].getEntity();
            if (selectedLogs[0].date < selectedLogs[1].date) {
                ModelBusLogEntry tmp = selectedLogs[0];
                selectedLogs[0] = selectedLogs[1];
                selectedLogs[1] = tmp;
            }
        } else {
            selectedLogs[1] = new ModelBusLogEntry(selectedLogs[0].modelBusRevision.getPreviousRevision().getRevision(), 0L, null, null, null, false);
        }
        HashMap<String, String> resource2project = new HashMap<String, String>();
        IResource local = this.view.getResource();
        if (local != null) {
            remote = ModelBusRemoteStorage.instance().asRepositoryResource((IResource)local.getProject());
            resource2project.put(remote.getUrl(), local.getProject().getName());
        } else {
            remote = this.view.getRepositoryResource();
            resource2project.put(remote.getUrl(), remote.getName());
        }
        CompositeOperation op = new CompositeOperation(ModelBusTeamPlugin.instance().getResource("Operation.ExtractTo"));
        InitExtractLogOperation logger = new InitExtractLogOperation(path);
        FromDifferenceRepositoryResourceProvider provider = new FromDifferenceRepositoryResourceProvider(selectedLogs);
        op.add((IActionOperation)provider);
        op.add((IActionOperation)logger);
        op.add((IActionOperation)new ExtractToOperationRemote((IRepositoryResourceWithStatusProvider)provider, provider.getDeletionsProvider(), path, resource2project, logger, true), new IActionOperation[]{provider});
        op.add((IActionOperation)new FiniExtractLogOperation(logger));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void runCompareForLocal(Object[] selection) {
        ArrayList<ModelBusLocalFileRevision> newSelection = new ArrayList<ModelBusLocalFileRevision>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof ILogNode) {
                newSelection.add((ModelBusLocalFileRevision)((Object)((ILogNode)item).getEntity()));
            } else {
                newSelection.add((ModelBusLocalFileRevision)((FileRevision)item));
            }
            ++n2;
        }
        CompareRevisionAction compare = null;
        try {
            compare = (CompareRevisionAction)CompareRevisionAction.class.getConstructor(null).newInstance(null);
            compare.getClass().getMethod("setPage", HistoryPage.class).invoke((Object)compare, this.view.getHistoryPage());
        }
        catch (Exception exception) {
            try {
                compare = (CompareRevisionAction)CompareRevisionAction.class.getConstructor(String.class, HistoryPage.class).newInstance("", this.view.getHistoryPage());
            }
            catch (RuntimeException ex1) {
                throw ex1;
            }
            catch (Exception ex1) {
                throw new RuntimeException(ex1);
            }
        }
        compare.selectionChanged((IStructuredSelection)new StructuredSelection(newSelection));
        compare.setCurrentFileRevision((IFileRevision)new ModelBusLocalFileRevision((IFile)this.view.getResource()));
        compare.run();
    }

    protected IRepositoryResource getResourceForHeadRevision() {
        IRepositoryFile res = this.view.getRepositoryResource() instanceof IRepositoryFile ? ((IRepositoryRoot)this.view.getRepositoryResource().getRoot()).asRepositoryFile(this.view.getRepositoryResource().getUrl(), false) : ((IRepositoryRoot)this.view.getRepositoryResource().getRoot()).asRepositoryContainer(this.view.getRepositoryResource().getUrl(), false);
        res.setSelectedRevision(ModelBusRevision.HEAD);
        res.setPegRevision(ModelBusRevision.HEAD);
        return res;
    }

    protected String getCompareForceId() {
        return this.toString();
    }

    protected IRepositoryResource getResourceForSelectedRevision(ModelBusLogEntry item) {
        String revNum = item.revision;
        IRepositoryResource res = ModelBusUtility.copyOf((IRepositoryResource)this.view.getRepositoryResource());
        res.setSelectedRevision(ModelBusRevision.fromString((String)revNum));
        res.setPegRevision(this.view.getRepositoryResource().getPegRevision());
        return res;
    }

    protected boolean confirmReplacement() {
        ReplaceWarningDialog dialog = new ReplaceWarningDialog(UIMonitorUtility.getShell());
        return dialog.open() == 0;
    }

    protected boolean checkSelectionForExistanceInPrev(IStructuredSelection selection) {
        for (Object next : selection) {
            if (!(next instanceof ModelBusChangedPathData)) continue;
            ModelBusChangedPathData current = (ModelBusChangedPathData)next;
            if (current.action == 'M' || current.action == 'R' || current.copiedFromPath != null && !current.copiedFromPath.equals("")) continue;
            return false;
        }
        return true;
    }

    protected void createPatchToPrevious(Shell shell, IActionOperation preOp, IRepositoryResourceProvider provider) {
        if (UIMonitorUtility.doTaskNowDefault(shell, preOp, true).isCancelled()) {
            return;
        }
        IRepositoryResource current = provider.getRepositoryResources()[0];
        CreatePatchWizard wizard = new CreatePatchWizard(current.getName());
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            IRepositoryContainer previous = current instanceof RepositoryFolder ? current.asRepositoryContainer(current.getUrl(), false) : current.asRepositoryFile(current.getUrl(), false);
            previous.setSelectedRevision(ModelBusRevision.fromString((String)this.selectedRevision.getPreviousRevision().getRevision()));
            previous.setPegRevision(this.selectedRevision);
            UIMonitorUtility.doTaskScheduledDefault(CreatePatchAction.getCreatePatchOperation((IRepositoryResource)previous, current, wizard));
        }
    }

    protected void createBranchTag(Shell shell, IActionOperation preOp, IRepositoryResourceProvider provider, int type) {
        if (UIMonitorUtility.doTaskNowDefault(shell, preOp, true).isCancelled()) {
            return;
        }
        IRepositoryResource[] resources = provider.getRepositoryResources();
        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(resources, shell, type);
        if (op != null) {
            CompositeOperation composite = new CompositeOperation(op.getId());
            composite.add((IActionOperation)op);
            RefreshRemoteResourcesOperation refreshOp = new RefreshRemoteResourcesOperation(new IRepositoryResource[]{op.getDestination().getParent()});
            composite.add((IActionOperation)refreshOp, new IActionOperation[]{op});
            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
        }
    }

    protected void doExport(Shell shell, IActionOperation preOp, IRepositoryResourceProvider provider) {
        DirectoryDialog fileDialog = new DirectoryDialog(shell);
        fileDialog.setText(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder"));
        fileDialog.setMessage(ModelBusTeamUIPlugin.instance().getResource("ExportPanel.ExportFolder.Msg"));
        String path = fileDialog.open();
        if (path != null) {
            ExportOperation mainOp = new ExportOperation(provider, path, 3);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add(preOp);
            op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
        }
    }

    protected void openRemoteResource(ModelBusChangedPathData selectedPath, int openType, String openWith) {
        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(selectedPath, true);
        OpenRemoteFileOperation openOp = new OpenRemoteFileOperation(provider, openType, openWith);
        CompositeOperation composite = new CompositeOperation(openOp.getId(), true);
        composite.add((IActionOperation)provider);
        composite.add((IActionOperation)openOp, new IActionOperation[]{provider});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void showAnnotation(ModelBusChangedPathData selectedPath) {
        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(selectedPath, true);
        RemoteShowAnnotationOperation mainOp = new RemoteShowAnnotationOperation(provider);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), true);
        op.add((IActionOperation)provider);
        op.add((IActionOperation)mainOp, new IActionOperation[]{provider});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void showHistory(IActionOperation preOp, IRepositoryResourceProvider provider) {
        ShowHistoryViewOperation mainOp = new ShowHistoryViewOperation(provider, 0, 0);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add(preOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void showProperties(IActionOperation preOp, IRepositoryResourceProvider provider) {
        GetRemotePropertiesOperation propertyProvider = new GetRemotePropertiesOperation(provider);
        ShowPropertiesOperation mainOp = new ShowPropertiesOperation(UIMonitorUtility.getActivePage(), provider, (IResourcePropertyProvider)propertyProvider);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add(preOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void getContentAffected(IActionOperation preOp, IRepositoryResourceProvider provider, String remotePath) {
        IContainer resourceToLock;
        IContainer viewedResource;
        String rootUrl = "";
        String remoteViewedResourceUrl = ModelBusRemoteStorage.instance().asRepositoryResource(this.view.getResource()).getUrl();
        String remoteFoundPath = this.traceUrlToRevision(rootUrl, remotePath, this.view.getCurrentRevision(), this.selectedRevision);
        if (!remoteFoundPath.startsWith(remoteViewedResourceUrl)) {
            MessageDialog dialog = new MessageDialog(UIMonitorUtility.getShell(), ModelBusTeamUIPlugin.instance().getResource("AffectedPathsActions.CantGetContent.Title"), null, ModelBusTeamUIPlugin.instance().getResource("AffectedPathsActions.CantGetContent.Message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return;
        }
        if (!this.confirmReplacement()) {
            return;
        }
        Path resourcePath = new Path(remoteFoundPath.substring(remoteViewedResourceUrl.length()));
        HashMap<String, String> remote2local = new HashMap<String, String>();
        if (this.view.getResource() instanceof IContainer) {
            viewedResource = (IContainer)this.view.getResource();
            remote2local.put(ModelBusUtility.encodeURL((String)(String.valueOf(rootUrl) + remotePath)), FileUtility.getWorkingCopyPath((IResource)viewedResource).concat(resourcePath.toString()));
            resourceToLock = viewedResource.findMember((IPath)resourcePath);
            while (resourceToLock == null) {
                resourcePath = resourcePath.removeLastSegments(1);
                resourceToLock = viewedResource.findMember((IPath)resourcePath);
            }
        } else {
            viewedResource = (IFile)this.view.getResource();
            remote2local.put(ModelBusUtility.encodeURL((String)(String.valueOf(rootUrl) + remotePath)), FileUtility.getWorkingCopyPath((IResource)viewedResource).concat(resourcePath.toString()));
            resourceToLock = viewedResource.getParent();
        }
        GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(new IResource[]{resourceToLock}, provider, remote2local);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add(preOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
        op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{resourceToLock}));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String traceUrlToRevision(String rootUrl, String resourcePath, ModelBusRevision currentRevision, ModelBusRevision selectedRevision) {
        String url = String.valueOf(rootUrl) + resourcePath;
        ModelBusLogEntry[] entries = this.view.getFullRemoteHistory();
        if (currentRevision.equals((Object)selectedRevision) || entries[entries.length - 1].modelBusRevision.isGreaterThan(currentRevision)) {
            return url;
        }
        if (currentRevision.isGreaterThan(selectedRevision)) {
            int i = entries.length - 1;
            while (i > -1) {
                ModelBusLogEntry entry = entries[i];
                if (!entry.modelBusRevision.isLowerThan(selectedRevision)) {
                    if (entry.modelBusRevision.isGreaterThan(currentRevision)) return url;
                    if (entry.changedPaths == null) {
                        return url;
                    }
                    ModelBusLogPath[] modelBusLogPathArray = entry.changedPaths;
                    int n = entry.changedPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ModelBusLogPath path = modelBusLogPathArray[n2];
                        if (path.copiedFromPath != null && url.endsWith(path.copiedFromPath)) {
                            url = String.valueOf(rootUrl) + path.path;
                            break;
                        }
                        ++n2;
                    }
                }
                --i;
            }
            return url;
        } else {
            ModelBusLogEntry[] modelBusLogEntryArray = entries;
            int n = entries.length;
            int n3 = 0;
            while (n3 < n) {
                ModelBusLogEntry entry = modelBusLogEntryArray[n3];
                if (entry.date <= selectedRevision.getDate()) {
                    if (entry.date < currentRevision.getDate()) return url;
                    if (entry.changedPaths == null) {
                        return url;
                    }
                    ModelBusLogPath[] modelBusLogPathArray = entry.changedPaths;
                    int n4 = entry.changedPaths.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ModelBusLogPath path = modelBusLogPathArray[n5];
                        if (path.copiedFromPath != null && url.endsWith(path.path)) {
                            url = String.valueOf(rootUrl) + path.copiedFromPath;
                            break;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        return url;
    }

    protected void addRevisionLink(IActionOperation preOp, IRepositoryResourceProvider provider) {
        CompositeOperation op = new CompositeOperation("Operation.HAddSelectedRevision");
        op.add(preOp);
        IActionOperation[] condition = new IActionOperation[]{preOp};
        op.add((IActionOperation)new AddRevisionLinkOperation(provider, this.selectedRevision.getRevision()), condition);
        UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
    }

    protected void compareWithPreviousRevision(IActionOperation preOp, final IRepositoryResourceProvider provider) {
        CompareRepositoryResourcesOperation mainOp = new CompareRepositoryResourcesOperation(new IRepositoryResourceProvider(){

            public IRepositoryResource[] getRepositoryResources() {
                IRepositoryResource next = provider.getRepositoryResources()[0];
                IRepositoryResource prev = ModelBusUtility.copyOf((IRepositoryResource)next);
                prev.setSelectedRevision(ModelBusRevision.fromString((String)next.getSelectedRevision().getPreviousRevision().getRevision()));
                return new IRepositoryResource[]{prev, next};
            }
        });
        mainOp.setForceId(this.getCompareForceId());
        if (preOp != null) {
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add(preOp);
            op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        } else {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)mainOp);
        }
    }

    protected class AffectedTableActionManager
    implements IControlActionManager {
        protected AffectedTableActionManager() {
        }

        @Override
        public void installKeyBindings(StructuredViewer viewer) {
        }

        @Override
        public void installDefaultAction(StructuredViewer viewer) {
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent e) {
                    IStructuredSelection selection;
                    if (e.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)e.getSelection()).size() == 1) {
                        ModelBusChangedPathData data = (ModelBusChangedPathData)selection.getFirstElement();
                        if ((((AffectedTableActionManager)AffectedTableActionManager.this).HistoryActionManager.this.view.getOptions() & 2) != 0) {
                            boolean isPreviousExists;
                            boolean bl = isPreviousExists = data.action == 'M' || data.action == 'R' || data.copiedFromPath != null && !data.copiedFromPath.equals("");
                            if (isPreviousExists) {
                                FromChangedPathDataProvider provider = new FromChangedPathDataProvider(data, false);
                                HistoryActionManager.this.compareWithPreviousRevision((IActionOperation)provider, provider);
                            } else {
                                MessageDialog dialog = new MessageDialog(e.getViewer().getControl().getShell(), ModelBusTeamUIPlugin.instance().getResource("AffectedPathsComposite.NoPreviousRevision.Title"), null, ModelBusTeamUIPlugin.instance().getResource("AffectedPathsComposite.NoPreviousRevision.Message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                                dialog.open();
                            }
                        } else {
                            HistoryActionManager.this.openRemoteResource(data, 0, null);
                        }
                    }
                }
            });
        }

        @Override
        public void installMenuActions(final StructuredViewer viewer, IWorkbenchPartSite site) {
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IContributionItem)new Separator("additions"));
                    IStructuredSelection affectedTableSelection = (IStructuredSelection)viewer.getSelection();
                    if (affectedTableSelection.size() == 0) {
                        return;
                    }
                    final ModelBusChangedPathData firstData = (ModelBusChangedPathData)affectedTableSelection.getFirstElement();
                    HistoryAction tAction = null;
                    IEditorRegistry editorRegistry = ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry();
                    tAction = new HistoryAction("HistoryView.Open"){

                        public void run() {
                            HistoryActionManager.this.openRemoteResource(firstData, 0, null);
                        }
                    };
                    manager.add((IAction)tAction);
                    String name = firstData.resourceName;
                    tAction.setImageDescriptor(editorRegistry.getImageDescriptor(name));
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                    MenuManager sub = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("HistoryView.OpenWith"), "historyOpenWithMenu");
                    sub.add((IContributionItem)new Separator("additions"));
                    sub.add((IContributionItem)new Separator("nonDefaultTextEditors"));
                    IEditorDescriptor[] editors = editorRegistry.getEditors(name);
                    int i = 0;
                    while (i < editors.length) {
                        final String id = editors[i].getId();
                        if (!id.equals("org.eclipse.ui.DefaultTextEditor")) {
                            tAction = new HistoryAction(editors[i].getLabel()){

                                public void run() {
                                    HistoryActionManager.this.openRemoteResource(firstData, 3, id);
                                }
                            };
                            sub.add((IAction)tAction);
                            tAction.setImageDescriptor(editors[i].getImageDescriptor());
                            tAction.setEnabled(affectedTableSelection.size() == 1);
                        }
                        ++i;
                    }
                    sub.add((IContributionItem)new Separator("variousEditors"));
                    IEditorDescriptor descriptor = null;
                    tAction = new HistoryAction("HistoryView.TextEditor"){

                        public void run() {
                            HistoryActionManager.this.openRemoteResource(firstData, 3, "org.eclipse.ui.DefaultTextEditor");
                        }
                    };
                    sub.add((IAction)tAction);
                    descriptor = editorRegistry.findEditor("org.eclipse.ui.DefaultTextEditor");
                    tAction.setImageDescriptor(descriptor.getImageDescriptor());
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                    tAction = new HistoryAction("HistoryView.SystemEditor"){

                        public void run() {
                            HistoryActionManager.this.openRemoteResource(firstData, 1, null);
                        }
                    };
                    sub.add((IAction)tAction);
                    if (editorRegistry.isSystemExternalEditorAvailable(name)) {
                        tAction.setImageDescriptor(editorRegistry.getSystemExternalEditorImageDescriptor(name));
                        tAction.setEnabled(affectedTableSelection.size() == 1);
                    } else {
                        tAction.setEnabled(false);
                    }
                    tAction = new HistoryAction("HistoryView.InplaceEditor"){

                        public void run() {
                            HistoryActionManager.this.openRemoteResource(firstData, 2, null);
                        }
                    };
                    sub.add((IAction)tAction);
                    if (editorRegistry.isSystemInPlaceEditorAvailable(name)) {
                        tAction.setImageDescriptor(editorRegistry.getSystemExternalEditorImageDescriptor(name));
                        tAction.setEnabled(affectedTableSelection.size() == 1);
                    } else {
                        tAction.setEnabled(false);
                    }
                    tAction = new HistoryAction("HistoryView.DefaultEditor"){

                        public void run() {
                            HistoryActionManager.this.openRemoteResource(firstData, 0, null);
                        }
                    };
                    sub.add((IAction)tAction);
                    tAction.setImageDescriptor(editorRegistry.getImageDescriptor(name));
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                    manager.add((IContributionItem)sub);
                    manager.add((IContributionItem)new Separator());
                    boolean isPreviousExists = false;
                    if (affectedTableSelection.size() > 0) {
                        isPreviousExists = HistoryActionManager.this.checkSelectionForExistanceInPrev(affectedTableSelection);
                    }
                    tAction = new HistoryAction("HistoryView.CompareWithPrevious"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.compareWithPreviousRevision((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(isPreviousExists);
                    manager.add((IContributionItem)new Separator());
                    tAction = new HistoryAction("ShowPropertiesAction.label", "icons/views/propertiesedit.gif"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.showProperties((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                    tAction = new HistoryAction("ShowResourceHistoryCommand.label", "icons/views/history.gif"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.showHistory((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                    tAction = new HistoryAction("ShowAnnotationCommand.label"){

                        public void run() {
                            HistoryActionManager.this.showAnnotation(firstData);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                    manager.add((IContributionItem)new Separator());
                    tAction = new HistoryAction("ExportCommand.label", "icons/common/export.gif"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.doExport(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != 'D');
                    tAction = new HistoryAction("CreatePatchCommand.label"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.createPatchToPrevious(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(isPreviousExists);
                    if (((AffectedTableActionManager)AffectedTableActionManager.this).HistoryActionManager.this.view.getResource() != null) {
                        tAction = new HistoryAction("HistoryView.GetContents"){

                            public void run() {
                                FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                                HistoryActionManager.this.getContentAffected((IActionOperation)provider, provider, "/" + firstData.getFullResourcePath());
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != 'D');
                    }
                    manager.add((IContributionItem)new Separator());
                    String branchFrom = ModelBusTeamUIPlugin.instance().getResource("HistoryView.BranchFrom", new String[]{String.valueOf(((AffectedTableActionManager)AffectedTableActionManager.this).HistoryActionManager.this.selectedRevision)});
                    String tagFrom = ModelBusTeamUIPlugin.instance().getResource("HistoryView.TagFrom", new String[]{String.valueOf(((AffectedTableActionManager)AffectedTableActionManager.this).HistoryActionManager.this.selectedRevision)});
                    tAction = new HistoryAction(branchFrom, "icons/common/actions/branch.gif"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 0);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != 'D');
                    tAction = new HistoryAction(tagFrom, "icons/common/actions/tag.gif"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 1);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != 'D');
                    tAction = new HistoryAction("AddRevisionLinkAction.label"){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.addRevisionLink((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != 'D');
                }
            });
            menuMgr.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
            site.registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }
    }

    protected class AffectedTreeActionManager
    implements IControlActionManager {
        protected AffectedTreeActionManager() {
        }

        @Override
        public void installKeyBindings(StructuredViewer viewer) {
        }

        @Override
        public void installDefaultAction(StructuredViewer viewer) {
        }

        @Override
        public void installMenuActions(final StructuredViewer viewer, IWorkbenchPartSite site) {
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IContributionItem)new Separator("additions"));
                    IStructuredSelection affectedTableSelection = (IStructuredSelection)viewer.getSelection();
                    if (affectedTableSelection.size() == 0) {
                        return;
                    }
                    final AffectedPathsNode node = (AffectedPathsNode)affectedTableSelection.getFirstElement();
                    HistoryAction tAction = null;
                    tAction = new HistoryAction("HistoryView.CompareWithPrevious"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.compareWithPreviousRevision((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    boolean isCompareFoldersAllowed = true;
                    tAction.setEnabled(isCompareFoldersAllowed && !"0".equals(((AffectedTreeActionManager)AffectedTreeActionManager.this).HistoryActionManager.this.selectedRevision) && affectedTableSelection.size() == 1 && (node.getStatus() == '\u0000' || node.getStatus() == 'M' || node.getStatus() == 'R'));
                    manager.add((IContributionItem)new Separator());
                    tAction = new HistoryAction("ShowPropertiesAction.label", "icons/views/propertiesedit.gif"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.showProperties((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(!"0".equals(((AffectedTreeActionManager)AffectedTreeActionManager.this).HistoryActionManager.this.selectedRevision) && affectedTableSelection.size() == 1);
                    tAction = new HistoryAction("ShowResourceHistoryCommand.label", "icons/views/history.gif"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.showHistory((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(!"0".equals(((AffectedTreeActionManager)AffectedTreeActionManager.this).HistoryActionManager.this.selectedRevision) && affectedTableSelection.size() == 1);
                    manager.add((IContributionItem)new Separator());
                    tAction = new HistoryAction("ExportCommand.label", "icons/common/export.gif"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.doExport(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != 'D');
                    tAction = new HistoryAction("CreatePatchCommand.label"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.createPatchToPrevious(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() == 1 && !"0".equals(((AffectedTreeActionManager)AffectedTreeActionManager.this).HistoryActionManager.this.selectedRevision) && affectedTableSelection.size() == 1 && (node.getStatus() == '\u0000' || node.getStatus() == 'M'));
                    if (((AffectedTreeActionManager)AffectedTreeActionManager.this).HistoryActionManager.this.view.getResource() != null) {
                        tAction = new HistoryAction("HistoryView.GetContents"){

                            public void run() {
                                FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                                HistoryActionManager.this.getContentAffected((IActionOperation)provider, provider, node.getFullPath());
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != 'D');
                    }
                    manager.add((IContributionItem)new Separator());
                    tAction = new HistoryAction("HistoryView.BranchFrom", new String[]{String.valueOf(((AffectedTreeActionManager)AffectedTreeActionManager.this).HistoryActionManager.this.selectedRevision)}, "icons/common/actions/branch.gif"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 0);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != 'D');
                    tAction = new HistoryAction("HistoryView.TagFrom", new String[]{String.valueOf(((AffectedTreeActionManager)AffectedTreeActionManager.this).HistoryActionManager.this.selectedRevision)}, "icons/common/actions/tag.gif"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 1);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != 'D');
                    tAction = new HistoryAction("AddRevisionLinkAction.label"){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.addRevisionLink((IActionOperation)provider, provider);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != 'D');
                }
            });
            menuMgr.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
            site.registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }
    }

    protected class FromAffectedPathsNodeProvider
    extends AbstractActionOperation
    implements IRepositoryResourceProvider {
        protected AffectedPathsNode affectedPathsItem;
        protected IRepositoryResource returnResource;

        public FromAffectedPathsNodeProvider(AffectedPathsNode affectedPathsItem) {
            super("Operation.GetRepositoryResource");
            this.affectedPathsItem = affectedPathsItem;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            String rootUrl = ModelBusConnector.getRepositoryRootUrl();
            String path = this.affectedPathsItem.getFullPath();
            String resourceUrl = String.valueOf(rootUrl) + (path.startsWith("/") ? "" : "/") + path;
            ModelBusRevision revision = HistoryActionManager.this.selectedRevision;
            this.returnResource = ModelBusConnector.asRepositoryContainer((String)resourceUrl, (boolean)false);
            this.returnResource.setSelectedRevision(revision);
            this.returnResource.setPegRevision(revision);
        }

        public IRepositoryResource[] getRepositoryResources() {
            return new IRepositoryResource[]{this.returnResource};
        }
    }

    protected class FromChangedPathDataProvider
    extends AbstractActionOperation
    implements IRepositoryResourceProvider {
        protected IRepositoryResource[] repositoryResources;
        protected ModelBusChangedPathData affectedPathsItem;
        protected boolean filesOnly;

        public FromChangedPathDataProvider(ModelBusChangedPathData affectedPathsItem, boolean filesOnly) {
            super("Operation.GetRepositoryResource");
            this.affectedPathsItem = affectedPathsItem;
            this.filesOnly = filesOnly;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            String affectedPath = this.affectedPathsItem.getFullResourcePath();
            String rootUrl = ModelBusConnector.getRepositoryRootUrl();
            String resourceUrl = String.valueOf(rootUrl) + "/" + affectedPath;
            ModelBusRevision revision = this.affectedPathsItem.action == 'D' ? HistoryActionManager.this.selectedRevision.getPreviousRevision() : HistoryActionManager.this.selectedRevision;
            ModelBusEntryInfo info = null;
            IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
            ModelBusEntryInfo[] infos = ModelBusUtility.info((IModelBusConnector)proxy, (ModelBusEntryRevisionReference)new ModelBusEntryRevisionReference(ModelBusUtility.encodeURL((String)resourceUrl), revision, revision), (int)0, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)this, monitor, null));
            if (infos == null || infos.length == 0) {
                return;
            }
            info = infos[0];
            if (info.kind == 2 && this.filesOnly) {
                final String message = ModelBusTeamUIPlugin.instance().getResource("AffectedPathsComposite.Open.Message", new String[]{ModelBusUtility.decodeURL((String)info.url)});
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog dialog = new MessageDialog(UIMonitorUtility.getDisplay().getActiveShell(), ModelBusTeamUIPlugin.instance().getResource("AffectedPathsComposite.Open.Title"), null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                        dialog.open();
                    }
                });
                this.reportStatus((IStatus)new Status(2, "org.modelbus.team.eclipse.core.modelbusnature", 0, message, null));
                return;
            }
            this.repositoryResources = new IRepositoryResource[1];
            this.repositoryResources[0] = info.kind == 1 ? ModelBusConnector.asRepositoryFile((String)resourceUrl, (boolean)false) : ModelBusConnector.asRepositoryContainer((String)resourceUrl, (boolean)false);
            this.repositoryResources[0].setSelectedRevision(revision);
            this.repositoryResources[0].setPegRevision(revision);
        }

        public IRepositoryResource[] getRepositoryResources() {
            return this.repositoryResources;
        }
    }

    protected class FromDifferenceRepositoryResourceProvider
    extends AbstractActionOperation
    implements IRepositoryResourceWithStatusProvider {
        protected IRepositoryResource[] repositoryResources;
        protected IRepositoryResource[] repositoryResourcesToDelete;
        protected IRepositoryResource newer;
        protected IRepositoryResource older;
        protected HashMap<String, String> url2status;

        public FromDifferenceRepositoryResourceProvider(ModelBusLogEntry[] logEntries) {
            super("Operation.GetRepositoryResource");
            this.newer = HistoryActionManager.this.getResourceForSelectedRevision(logEntries[0]);
            this.older = HistoryActionManager.this.getResourceForSelectedRevision(logEntries[1]);
            this.url2status = new HashMap();
        }

        public IRepositoryResourceProvider getDeletionsProvider() {
            return new IRepositoryResourceProvider(){

                public IRepositoryResource[] getRepositoryResources() {
                    return FromDifferenceRepositoryResourceProvider.this.repositoryResourcesToDelete;
                }
            };
        }

        protected IRepositoryResource createResourceFor(int kind, String url) {
            IRepositoryFile retVal = null;
            if (kind == 1) {
                retVal = ModelBusConnector.asRepositoryFile((String)url, (boolean)false);
            } else if (kind == 2) {
                retVal = ModelBusConnector.asRepositoryContainer((String)url, (boolean)false);
            }
            if (retVal == null) {
                throw new RuntimeException(ModelBusTeamUIPlugin.instance().getResource("Error.CompareUnknownNodeKind"));
            }
            return retVal;
        }

        protected IRepositoryResource getResourceForStatus(ModelBusDiffStatus status) {
            String url = ModelBusUtility.decodeURL((String)status.pathNext);
            return this.createResourceFor(ModelBusUtility.getNodeKind((String)status.pathPrev, (int)status.nodeKind, (boolean)false), url);
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            HashSet<IRepositoryResource> resourcesToReturn = new HashSet<IRepositoryResource>();
            HashSet<IRepositoryResource> resourcesToDelete = new HashSet<IRepositoryResource>();
            ArrayList statusesList = new ArrayList();
            IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
            final LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{this.newer, this.older});
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
                }
            }, monitor, 3);
            this.newer = op.getRepositoryResources()[0];
            this.older = op.getRepositoryResources()[1];
            ModelBusEntryRevisionReference refPrev = ModelBusUtility.getEntryRevisionReference((IRepositoryResource)this.older);
            ModelBusEntryRevisionReference refNext = ModelBusUtility.getEntryRevisionReference((IRepositoryResource)this.newer);
            ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)ModelBusTeamPlugin.instance().getResource("Progress.Running"));
            if (ModelBusUtility.useSingleReferenceSignature((ModelBusEntryRevisionReference)refPrev, (ModelBusEntryRevisionReference)refNext)) {
                ModelBusUtility.diffStatus((IModelBusConnector)proxy, statusesList, (ModelBusEntryReference)refPrev, (ModelBusRevision)refPrev.revision, (ModelBusRevision)refNext.revision, (int)3, (long)0L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)this, monitor, null, false));
            } else {
                ModelBusUtility.diffStatus((IModelBusConnector)proxy, statusesList, (ModelBusEntryRevisionReference)refPrev, (ModelBusEntryRevisionReference)refNext, (int)3, (long)0L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)this, monitor, null, false));
            }
            for (ModelBusDiffStatus status : statusesList) {
                IRepositoryResource resourceToAdd = this.getResourceForStatus(status);
                resourceToAdd.setSelectedRevision(this.newer.getSelectedRevision());
                resourceToAdd.setPegRevision(this.newer.getPegRevision());
                resourcesToReturn.add(resourceToAdd);
                this.url2status.put(resourceToAdd.getUrl(), ModelBusRemoteStorage.instance().getStatusString(status.propStatus, status.textStatus, true));
                if (status.textStatus != 4) continue;
                resourcesToDelete.add(resourceToAdd);
            }
            this.repositoryResources = resourcesToReturn.toArray(new IRepositoryResource[0]);
            this.repositoryResourcesToDelete = resourcesToDelete.toArray(new IRepositoryResource[0]);
        }

        public IRepositoryResource[] getRepositoryResources() {
            return this.repositoryResources;
        }

        public Map<String, String> getStatusesMap() {
            return this.url2status;
        }
    }

    public static class HistoryAction
    extends Action {
        protected HistoryAction(String text) {
            super(ModelBusTeamUIPlugin.instance().getResource(text));
        }

        protected HistoryAction(String text, Object[] args) {
            this(text, args, null);
        }

        protected HistoryAction(String text, Object[] args, String imageDescriptor) {
            super(ModelBusTeamUIPlugin.instance().getResource(text, args));
            this.setHoverImageDescriptor(imageDescriptor == null ? null : ModelBusTeamUIPlugin.instance().getImageDescriptor(imageDescriptor));
        }

        protected HistoryAction(String text, String imageDescriptor) {
            this(text);
            this.setHoverImageDescriptor(imageDescriptor == null ? null : ModelBusTeamUIPlugin.instance().getImageDescriptor(imageDescriptor));
        }

        protected HistoryAction(String text, String imageDescriptor, int style) {
            super(ModelBusTeamUIPlugin.instance().getResource(text), style);
            this.setHoverImageDescriptor(imageDescriptor == null ? null : ModelBusTeamUIPlugin.instance().getImageDescriptor(imageDescriptor));
        }
    }

    public static interface IControlActionManager {
        public void installKeyBindings(StructuredViewer var1);

        public void installDefaultAction(StructuredViewer var1);

        public void installMenuActions(StructuredViewer var1, IWorkbenchPartSite var2);
    }

    protected class LogMessagesActionManager
    implements IControlActionManager {
        protected LogMessagesActionManager() {
        }

        @Override
        public void installKeyBindings(final StructuredViewer viewer) {
            viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    ILogNode[] selection;
                    if (event.keyCode == 0x100000E) {
                        ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.refresh(3);
                    }
                    if (event.stateMask == 262144 && (event.keyCode == 99 || event.keyCode == 67) && (selection = LogMessagesActionManager.this.getSelection(viewer)).length > 0) {
                        HistoryActionManager.this.handleCopy(selection);
                    }
                }
            });
        }

        @Override
        public void installDefaultAction(final StructuredViewer viewer) {
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent e) {
                    IStructuredSelection structured;
                    ISelection selection = e.getSelection();
                    if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                        HistoryActionManager.this.handleDoubleClick((TreeViewer)viewer, (ILogNode)structured.getFirstElement(), true);
                    }
                }
            });
        }

        @Override
        public void installMenuActions(final StructuredViewer viewer, IWorkbenchPartSite site) {
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IContributionItem)new Separator("additions"));
                    HistoryAction refreshAction = new HistoryAction("HistoryView.Refresh", "icons/common/refresh.gif"){

                        public void run() {
                            ((LogMessagesActionManager)(this).LogMessagesActionManager.this).HistoryActionManager.this.view.refresh(3);
                        }
                    };
                    ILogNode[] selection = LogMessagesActionManager.this.getSelection(viewer);
                    if (selection.length == 0 || selection[0].getType() == 0) {
                        if (!((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.isPending() && ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.isFilterEnabled() && ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getMode() != 64) {
                            LogMessagesActionManager.this.addFilterPart(viewer, manager);
                        }
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)refreshAction);
                        return;
                    }
                    boolean onlyLogEntries = true;
                    boolean onlyLocalEntries = true;
                    boolean containsCategory = false;
                    boolean containsMergeHistory = false;
                    ILogNode[] iLogNodeArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILogNode node = iLogNodeArray[n2];
                        int type = node.getType();
                        if (type != 2) {
                            onlyLogEntries = false;
                        } else if (node.getParent() instanceof ModelBusLogNode) {
                            containsMergeHistory = true;
                        }
                        if (type != 3) {
                            onlyLocalEntries = false;
                        }
                        if (type == 1) {
                            onlyLogEntries = false;
                            onlyLocalEntries = false;
                            containsCategory = true;
                        }
                        ++n2;
                    }
                    if (onlyLogEntries) {
                        LogMessagesActionManager.this.addRemotePart(viewer, manager, selection, containsMergeHistory);
                        LogMessagesActionManager.this.addFilterPart(viewer, manager);
                        manager.add((IContributionItem)new Separator());
                    }
                    if (onlyLocalEntries) {
                        LogMessagesActionManager.this.addLocalPart(viewer, manager, selection);
                        manager.add((IContributionItem)new Separator());
                    }
                    if (!(onlyLogEntries || onlyLocalEntries || containsCategory)) {
                        LogMessagesActionManager.this.addLocalOrRemotePart(viewer, manager, selection, containsMergeHistory);
                        manager.add((IContributionItem)new Separator());
                    }
                    if (!onlyLogEntries) {
                        LogMessagesActionManager.this.addCommonPart(viewer, manager, selection, containsMergeHistory);
                        manager.add((IContributionItem)new Separator());
                    }
                    manager.add((IAction)refreshAction);
                }
            });
            menuMgr.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
            site.registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }

        protected void addRemotePart(final StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection, boolean containsMergeHistory) {
            String revision;
            Action tAction = null;
            ModelBusLogEntry[] entries = HistoryActionManager.this.view.getFullRemoteHistory();
            boolean existsInPrevious = entries[entries.length - 1] != selection[0].getEntity() || !HistoryActionManager.this.view.isAllRemoteHistoryFetched();
            final ModelBusLogEntry current = (ModelBusLogEntry)selection[0].getEntity();
            String string = revision = HistoryActionManager.this.view.getResource() != null ? String.valueOf(current.revision) : ModelBusTeamUIPlugin.instance().getResource("HistoryView.HEAD");
            if (!containsMergeHistory) {
                if (HistoryActionManager.this.view.getRepositoryResource() instanceof IRepositoryFile) {
                    String name = HistoryActionManager.this.view.getRepositoryResource().getName();
                    tAction = new HistoryAction("HistoryView.Open"){

                        public void run() {
                            HistoryActionManager.this.handleDoubleClick((TreeViewer)viewer, selection[0], false);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                    tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getImageDescriptor(name));
                    MenuManager sub = new MenuManager(ModelBusTeamUIPlugin.instance().getResource("HistoryView.OpenWith"), "historyOpenWithMenu");
                    sub.add((IContributionItem)new Separator("additions"));
                    sub.add((IContributionItem)new Separator("nonDefaultTextEditors"));
                    IEditorDescriptor[] editors = ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getEditors(name);
                    int i = 0;
                    while (i < editors.length) {
                        if (!editors[i].getId().equals("org.eclipse.ui.DefaultTextEditor")) {
                            HistoryActionManager.this.addMenuItem(viewer, sub, editors[i].getLabel(), new OpenFileWithAction(editors[i].getId(), false));
                        }
                        ++i;
                    }
                    sub.add((IContributionItem)new Separator("variousEditors"));
                    HistoryActionManager.this.addMenuItem(viewer, sub, ModelBusTeamUIPlugin.instance().getResource("HistoryView.TextEditor"), new OpenFileWithAction());
                    HistoryActionManager.this.addMenuItem(viewer, sub, ModelBusTeamUIPlugin.instance().getResource("HistoryView.SystemEditor"), new OpenFileWithExternalAction());
                    HistoryActionManager.this.addMenuItem(viewer, sub, ModelBusTeamUIPlugin.instance().getResource("HistoryView.InplaceEditor"), new OpenFileWithInplaceAction());
                    HistoryActionManager.this.addMenuItem(viewer, sub, ModelBusTeamUIPlugin.instance().getResource("HistoryView.DefaultEditor"), new OpenFileAction());
                    manager.add((IContributionItem)sub);
                    manager.add((IContributionItem)new Separator());
                }
                boolean isCompareAllowed = true;
                tAction = new HistoryAction("HistoryView.CompareEachOther"){

                    public void run() {
                        ModelBusLogEntry msg0 = (ModelBusLogEntry)selection[0].getEntity();
                        ModelBusLogEntry msg1 = (ModelBusLogEntry)selection[1].getEntity();
                        IRepositoryResource next = HistoryActionManager.this.getResourceForSelectedRevision(msg0);
                        IRepositoryResource prev = HistoryActionManager.this.getResourceForSelectedRevision(msg1);
                        if (msg0.modelBusRevision.isLowerThan(msg1.modelBusRevision)) {
                            IRepositoryResource tmp = prev;
                            prev = next;
                            next = tmp;
                        }
                        CompareRepositoryResourcesOperation op = new CompareRepositoryResourcesOperation(prev, next);
                        op.setForceId(HistoryActionManager.this.getCompareForceId());
                        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 2 && isCompareAllowed);
                tAction = new HistoryAction("HistoryView.CompareCurrentWith", new String[]{revision}){

                    public void run() {
                        HistoryActionManager.this.compareWithCurrent(current);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && isCompareAllowed);
                tAction = new HistoryAction("HistoryView.CompareWithPrevious"){

                    public void run() {
                        HistoryActionManager.this.compareWithPreviousRevision(null, new IRepositoryResourceProvider(){

                            public IRepositoryResource[] getRepositoryResources() {
                                ModelBusLogEntry current = (ModelBusLogEntry)selection[0].getEntity();
                                return new IRepositoryResource[]{HistoryActionManager.this.getResourceForSelectedRevision(current)};
                            }
                        });
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && isCompareAllowed && existsInPrevious);
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction("ShowPropertiesAction.label", "icons/views/propertiesedit.gif"){

                    public void run() {
                        ModelBusLogEntry current = (ModelBusLogEntry)selection[0].getEntity();
                        IRepositoryResource resource = HistoryActionManager.this.getResourceForSelectedRevision(current);
                        GetRemotePropertiesOperation provider = new GetRemotePropertiesOperation(resource);
                        ShowPropertiesOperation op = new ShowPropertiesOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IAdaptable)resource, (IResourcePropertyProvider)provider);
                        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction("SynchronizeActionGroup.CompareProperties"){

                    public void run() {
                        IRepositoryResource remote;
                        ModelBusLogEntry first = (ModelBusLogEntry)selection[0].getEntity();
                        ModelBusLogEntry second = (ModelBusLogEntry)selection[1].getEntity();
                        if (first.modelBusRevision.isLowerThan(second.modelBusRevision)) {
                            ModelBusLogEntry tmp = second;
                            second = first;
                            first = tmp;
                        }
                        if ((remote = ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getRepositoryResource()) == null) {
                            remote = ModelBusRemoteStorage.instance().asRepositoryResource(((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getResource());
                        }
                        TwoWayPropertyCompareInput input = new TwoWayPropertyCompareInput(new CompareConfiguration(), new ModelBusEntryRevisionReference(remote.getUrl(), ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getCurrentRevision(), ModelBusRevision.fromString((String)first.revision)), new ModelBusEntryRevisionReference(remote.getUrl(), ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getCurrentRevision(), ModelBusRevision.fromString((String)second.revision)));
                        CompareUI.openCompareEditor((CompareEditorInput)input);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 2);
            }
            tAction = new HistoryAction("ShowRevisionProperties.label"){

                public void run() {
                    ModelBusRevision selectedRevision = HistoryActionManager.this.getSelectedRevision();
                    ShowRevisionPropertiesOperation op = new ShowRevisionPropertiesOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), selectedRevision);
                    UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            if (!containsMergeHistory) {
                if (HistoryActionManager.this.view.getRepositoryResource() instanceof IRepositoryFile) {
                    tAction = new HistoryAction("ShowAnnotationCommand.label"){

                        public void run() {
                            IRepositoryResource remote = HistoryActionManager.this.getResourceForSelectedRevision((ModelBusLogEntry)selection[0].getEntity());
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new RemoteShowAnnotationOperation(remote));
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                }
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction("ExportCommand.label", "icons/common/export.gif"){

                    public void run() {
                        HistoryActionManager.this.doExport(selection[0]);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction("CreatePatchCommand.label"){

                    public void run() {
                        HistoryActionManager.this.createPatch(selection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && existsInPrevious || selection.length == 2);
                if (HistoryActionManager.this.view.getResource() != null) {
                    tAction = new HistoryAction("HistoryView.GetContents"){

                        public void run() {
                            if (HistoryActionManager.this.confirmReplacement()) {
                                HistoryActionManager.this.getRevisionContents((ModelBusLogEntry)selection[0].getEntity());
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                }
                if (HistoryActionManager.this.view.getResource() != null) {
                    tAction = new HistoryAction("HistoryView.UpdateTo"){

                        public void run() {
                            if (HistoryActionManager.this.confirmReplacement()) {
                                HistoryActionManager.this.updateTo((ModelBusLogEntry)selection[0].getEntity());
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                }
                tAction = new Action(ModelBusTeamUIPlugin.instance().getResource("ExtractToAction.Label")){

                    public void run() {
                        HistoryActionManager.this.runExtractTo(selection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && existsInPrevious || selection.length == 2);
                manager.add((IContributionItem)new Separator());
                String branchFrom = ModelBusTeamUIPlugin.instance().getResource("HistoryView.BranchFromRevision");
                String tagFrom = ModelBusTeamUIPlugin.instance().getResource("HistoryView.TagFromRevision");
                if (selection.length == 1) {
                    revision = String.valueOf(((ModelBusLogEntry)selection[0].getEntity()).revision);
                    branchFrom = ModelBusTeamUIPlugin.instance().getResource("HistoryView.BranchFrom", new String[]{revision});
                    tagFrom = ModelBusTeamUIPlugin.instance().getResource("HistoryView.TagFrom", new String[]{revision});
                }
                tAction = new HistoryAction(branchFrom, "icons/common/actions/branch.gif"){

                    public void run() {
                        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(new IRepositoryResource[]{HistoryActionManager.this.getResourceForSelectedRevision((ModelBusLogEntry)selection[0].getEntity())}, UIMonitorUtility.getShell(), 0);
                        if (op != null) {
                            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction(tagFrom, "icons/common/actions/tag.gif"){

                    public void run() {
                        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(new IRepositoryResource[]{HistoryActionManager.this.getResourceForSelectedRevision((ModelBusLogEntry)selection[0].getEntity())}, UIMonitorUtility.getShell(), 1);
                        if (op != null) {
                            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction("AddRevisionLinkAction.label"){

                    public void run() {
                        HistoryActionManager.this.addRevisionLinks(selection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length > 0);
            }
            manager.add((IContributionItem)new Separator());
            tAction = new HistoryAction("HistoryView.CopyHistory", "icons/common/copy.gif"){

                public void run() {
                    HistoryActionManager.this.handleCopy(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length > 0);
        }

        protected void addFilterPart(StructuredViewer viewer, IMenuManager manager) {
            manager.add((IContributionItem)new Separator());
            HistoryAction tAction = null;
            tAction = new HistoryAction("HistoryView.QuickFilter", "icons/views/history/filter.gif"){

                public void run() {
                    ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.setFilter();
                }
            };
            manager.add((IAction)tAction);
            tAction = new HistoryAction("HistoryView.ClearFilter", "icons/views/history/clear_filter.gif"){

                public void run() {
                    ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.clearFilter();
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(HistoryActionManager.this.view.isFilterEnabled());
        }

        protected void addLocalPart(final StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection) {
            HistoryAction tAction = null;
            tAction = new HistoryAction("HistoryView.Open"){

                public void run() {
                    HistoryActionManager.this.handleDoubleClick((TreeViewer)viewer, selection[0], false);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            tAction.setImageDescriptor(ModelBusTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getImageDescriptor(((ModelBusLocalFileRevision)((Object)selection[0].getEntity())).getName()));
            manager.add((IContributionItem)new Separator());
            tAction = new HistoryAction("HistoryView.CompareEachOther"){

                public void run() {
                    HistoryActionManager.this.runCompareForLocal(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 2);
            tAction = new HistoryAction("HistoryView.CompareCurrentWith", new String[]{ModelBusTeamUIPlugin.instance().getResource("HistoryView.RevisionLocal")}){

                public void run() {
                    HistoryActionManager.this.runCompareForLocal(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            tAction = new HistoryAction("HistoryView.CompareWithPrevious"){

                public void run() {
                    ModelBusLocalFileRevision[] localHistory = ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getLocalHistory();
                    ModelBusLocalFileRevision currentSelected = (ModelBusLocalFileRevision)((Object)selection[0].getEntity());
                    ArrayList<ModelBusLocalFileRevision> toOperate = new ArrayList<ModelBusLocalFileRevision>();
                    toOperate.add(currentSelected);
                    int i = 0;
                    while (i < localHistory.length - 1) {
                        if (currentSelected.equals((Object)localHistory[i])) {
                            toOperate.add(localHistory[i + 1]);
                            break;
                        }
                        ++i;
                    }
                    HistoryActionManager.this.runCompareForLocal(toOperate.toArray());
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1 && !selection[0].getEntity().equals((Object)HistoryActionManager.this.view.getLocalHistory()[HistoryActionManager.this.view.getLocalHistory().length - 1]));
            manager.add((IContributionItem)new Separator());
            tAction = new HistoryAction("ExportCommand.label", "icons/common/export.gif"){

                public void run() {
                    HistoryActionManager.this.doExport(selection[0]);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            tAction = new HistoryAction("HistoryView.GetContents"){

                public void run() {
                    try {
                        ((IFile)((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getResource()).setContents(((ModelBusLocalFileRevision)((Object)selection[0].getEntity())).getState(), true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException ex) {
                        UILoggedOperation.reportError(this.getText(), ex);
                    }
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1 && !((ModelBusLocalFileRevision)((Object)selection[0].getEntity())).isCurrentState());
        }

        protected void addLocalOrRemotePart(StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection, boolean containsMergeHistory) {
            HistoryAction tAction = null;
            if (!containsMergeHistory) {
                tAction = new HistoryAction("HistoryView.CompareEachOther"){

                    public void run() {
                        ArrayList<ILogNode> selected = new ArrayList<ILogNode>();
                        ILogNode[] iLogNodeArray = selection;
                        int n = selection.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILogNode item = iLogNodeArray[n2];
                            if (item.getType() == 3) {
                                selected.add(item);
                            } else {
                                selected.add((ILogNode)new ModelBusRemoteResourceRevision(HistoryActionManager.this.getResourceForSelectedRevision((ModelBusLogEntry)item.getEntity()), (ModelBusLogEntry)item.getEntity()));
                            }
                            ++n2;
                        }
                        HistoryActionManager.this.runCompareForLocal(selected.toArray());
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 2);
            }
        }

        protected void addCommonPart(StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection, boolean containsMergeHistory) {
            HistoryAction tAction = null;
            tAction = new HistoryAction("HistoryView.CopyHistory", "icons/common/copy.gif"){

                public void run() {
                    HistoryActionManager.this.handleCopy(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length > 0);
        }

        protected ILogNode[] getSelection(StructuredViewer viewer) {
            List selection = ((IStructuredSelection)viewer.getSelection()).toList();
            return selection.toArray(new ILogNode[selection.size()]);
        }
    }
}

