/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.extension.factory.ICommentView;
import org.modelbus.team.eclipse.ui.history.AffectedPathsComposite;
import org.modelbus.team.eclipse.ui.history.HistoryActionManager;
import org.modelbus.team.eclipse.ui.history.IModelBusHistoryViewInfo;
import org.modelbus.team.eclipse.ui.history.data.ModelBusChangedPathData;
import org.modelbus.team.eclipse.ui.history.data.RootHistoryCategory;
import org.modelbus.team.eclipse.ui.history.model.CategoryLogNode;
import org.modelbus.team.eclipse.ui.history.model.ILogNode;
import org.modelbus.team.eclipse.ui.history.model.ModelBusLogNode;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.ColumnedViewerComparator;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class LogMessagesComposite
extends SashForm {
    public static final int REFRESH_UI_AFFECTED = 1;
    public static final int REFRESH_UI_ALL = 2;
    public static final int REFRESH_ALL = 3;
    protected SashForm innerSashForm;
    protected CheckboxTreeViewer historyTable;
    protected ISelectionChangedListener historyTableListener;
    protected Font currentRevisionFont;
    protected AffectedPathsComposite affectedPathsComposite;
    protected ICommentView commentViewManager;
    protected RootHistoryCategory rootCategory;
    protected HistoryActionManager actionManager;
    protected IModelBusHistoryViewInfo info;
    protected boolean useCheckboxes;

    public LogMessagesComposite(Composite parent, boolean multiSelect, boolean useCheckboxes, IModelBusHistoryViewInfo info) {
        super(parent, 512);
        this.info = info;
        this.useCheckboxes = useCheckboxes;
        this.rootCategory = new RootHistoryCategory(info);
        this.initializeFont();
        this.initializeTableView(multiSelect ? 2 : 4);
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.historyTable;
    }

    public void setCommentViewerVisible(boolean visible) {
        if (visible) {
            this.innerSashForm.setMaximizedControl(null);
        } else {
            this.innerSashForm.setMaximizedControl(this.historyTable.getControl());
        }
    }

    public void setAffectedPathsViewerVisible(boolean visible) {
        if (visible) {
            this.setMaximizedControl(null);
        } else {
            this.setMaximizedControl((Control)this.innerSashForm);
        }
    }

    public void setResourceTreeVisible(boolean visible) {
        this.affectedPathsComposite.setResourceTreeVisible(visible);
    }

    public void collapseAll() {
        this.historyTable.collapseAll();
    }

    public void expandAll() {
        this.historyTable.expandAll();
    }

    public void registerActionManager(HistoryActionManager manager, IWorkbenchPartSite site) {
        this.actionManager = manager;
        manager.logMessagesManager.installKeyBindings((StructuredViewer)this.historyTable);
        manager.logMessagesManager.installDefaultAction((StructuredViewer)this.historyTable);
        manager.logMessagesManager.installMenuActions((StructuredViewer)this.historyTable, site);
        this.affectedPathsComposite.registerActionManager(manager, site);
    }

    public void setSelectedRevision(String revision) {
        ModelBusLogEntry[] msgs = this.rootCategory.getRemoteHistory();
        if (msgs != null) {
            ModelBusLogEntry[] modelBusLogEntryArray = msgs;
            int n = msgs.length;
            int n2 = 0;
            while (n2 < n) {
                ModelBusLogEntry msg = modelBusLogEntryArray[n2];
                if (msg.revision.equals(revision)) {
                    this.historyTable.setSelection((ISelection)new StructuredSelection((Object)new ModelBusLogNode(msg, null)), true);
                    return;
                }
                ++n2;
            }
        }
        this.historyTable.setSelection((ISelection)new StructuredSelection());
    }

    public ModelBusLogEntry[] getSelectedLogMessages() {
        ArrayList<ModelBusLogEntry> entries = new ArrayList<ModelBusLogEntry>();
        if (this.useCheckboxes) {
            Object[] checked;
            Object[] objectArray = checked = this.historyTable.getCheckedElements();
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object current = objectArray[n2];
                ILogNode node = (ILogNode)current;
                if (node.getType() == 2) {
                    entries.add((ModelBusLogEntry)node.getEntity());
                }
                ++n2;
            }
        } else {
            IStructuredSelection tSelection = (IStructuredSelection)this.historyTable.getSelection();
            for (ILogNode node : tSelection) {
                if (node.getType() != 2) continue;
                entries.add((ModelBusLogEntry)node.getEntity());
            }
        }
        return entries.toArray(new ModelBusLogEntry[entries.size()]);
    }

    public ModelBusRevision getSelectedRevision() {
        ILogNode node;
        IStructuredSelection tSelection = (IStructuredSelection)this.historyTable.getSelection();
        if (tSelection.size() > 0 && (node = (ILogNode)tSelection.getFirstElement()).getType() == 2) {
            return ((ModelBusLogEntry)node.getEntity()).modelBusRevision;
        }
        return ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
    }

    public void refresh(int refreshType) {
        if (refreshType == 3) {
            if (this.info.getResource() != null) {
                this.commentViewManager.usedFor(this.info.getResource());
            } else {
                this.commentViewManager.usedFor(this.info.getRepositoryResource());
            }
            this.rootCategory.refreshModel();
        }
        this.refreshImpl(refreshType);
    }

    public void dispose() {
        this.historyTable.removeSelectionChangedListener(this.historyTableListener);
        if (this.historyTable.getContentProvider() != null) {
            this.historyTable.setInput(null);
        }
        this.currentRevisionFont.dispose();
        super.dispose();
    }

    protected void refreshImpl(int refreshType) {
        if (!this.historyTable.getTree().isDisposed()) {
            if (refreshType != 1) {
                Object[] entries = this.rootCategory.getEntries();
                this.historyTable.getTree().setLinesVisible(entries != RootHistoryCategory.NO_REMOTE && entries != RootHistoryCategory.NO_LOCAL && entries != RootHistoryCategory.NO_REVS);
                this.historyTable.setInput((Object)new CategoryLogNode(this.rootCategory));
            }
            this.historyTableListener.selectionChanged(null);
        }
    }

    private void initializeTableView(int style) {
        this.innerSashForm = new SashForm((Composite)this, 512);
        Tree treeTable = new Tree((Composite)this.innerSashForm, style | 0x100 | 0x200 | 0x10000 | (this.useCheckboxes ? 32 : 0));
        treeTable.setHeaderVisible(true);
        treeTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        treeTable.setLayout((Layout)layout);
        this.commentViewManager = ExtensionsManager.getInstance().getCurrentMessageFactory().getCommentView();
        this.commentViewManager.createCommentView((Composite)this.innerSashForm, 578);
        this.affectedPathsComposite = new AffectedPathsComposite((Composite)this, 0);
        this.innerSashForm.setWeights(new int[]{75, 25});
        this.setWeights(new int[]{70, 30});
        this.historyTable = new CheckboxTreeViewer(treeTable);
        HistoryTableComparator comparator = new HistoryTableComparator((Viewer)this.historyTable);
        TreeColumn col = new TreeColumn(treeTable, 0);
        col.setResizable(true);
        col.setAlignment(131072);
        col.setText(ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.Revision"));
        col.addSelectionListener((SelectionListener)comparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(14, true));
        col = new TreeColumn(treeTable, 0);
        col.setResizable(true);
        col.setText(ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.Date"));
        col.addSelectionListener((SelectionListener)comparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, true));
        col = new TreeColumn(treeTable, 0);
        col.setResizable(true);
        col.setAlignment(131072);
        col.setText(ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.Changes"));
        col.addSelectionListener((SelectionListener)comparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, true));
        col = new TreeColumn(treeTable, 0);
        col.setResizable(true);
        col.setText(ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.Author"));
        col.addSelectionListener((SelectionListener)comparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(14, true));
        col = new TreeColumn(treeTable, 0);
        col.setResizable(true);
        col.setText(ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.Comment"));
        col.addSelectionListener((SelectionListener)comparator);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.historyTable.setComparator((ViewerComparator)comparator);
        comparator.setColumnNumber(1);
        comparator.setReversed(true);
        this.historyTable.getTree().setSortColumn(this.historyTable.getTree().getColumn(1));
        this.historyTable.getTree().setSortDirection(1024);
        this.historyTable.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return inputElement == null ? new Object[]{} : ((ILogNode)inputElement).getChildren();
            }

            public Object[] getChildren(Object parentElement) {
                return ((ILogNode)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                return ((ILogNode)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((ILogNode)element).hasChildren();
            }

            public void dispose() {
            }
        });
        this.historyTable.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        this.historyTableListener = new ISelectionChangedListener(){
            protected ILogNode oldSelection;
            protected boolean hideUnrelated;
            {
                this.hideUnrelated = LogMessagesComposite.this.info.isRelatedPathsOnly();
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (LogMessagesComposite.this.isDisposed()) {
                    return;
                }
                IStructuredSelection tSelection = (IStructuredSelection)LogMessagesComposite.this.historyTable.getSelection();
                if (tSelection.size() > 0) {
                    ILogNode selection = (ILogNode)tSelection.getFirstElement();
                    if (this.oldSelection != selection || this.hideUnrelated != LogMessagesComposite.this.info.isRelatedPathsOnly()) {
                        String message = selection.getComment();
                        if (message == null || message.length() == 0) {
                            message = selection.getType() == 2 ? ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoComment") : "";
                        }
                        LogMessagesComposite.this.commentViewManager.setComment(message);
                        Collection<String> relatedPrefixes = LogMessagesComposite.this.info.isRelatedPathsOnly() ? LogMessagesComposite.this.rootCategory.getRelatedPathPrefixes() : null;
                        Collection<String> relatedParents = LogMessagesComposite.this.info.isRelatedPathsOnly() ? LogMessagesComposite.this.rootCategory.getRelatedParents() : null;
                        ModelBusChangedPathData[] pathData = LogMessagesComposite.this.rootCategory.getPathData(selection);
                        ModelBusRevision revision = LogMessagesComposite.this.getSelectedRevision();
                        if (LogMessagesComposite.this.actionManager != null) {
                            LogMessagesComposite.this.actionManager.setSelectedRevision(revision);
                        }
                        LogMessagesComposite.this.affectedPathsComposite.setInput(pathData, relatedPrefixes, relatedParents, revision);
                        this.oldSelection = selection;
                        this.hideUnrelated = LogMessagesComposite.this.info.isRelatedPathsOnly();
                    }
                } else {
                    LogMessagesComposite.this.commentViewManager.setComment("");
                    LogMessagesComposite.this.affectedPathsComposite.setInput(null, null, null, ModelBusRevision.INVALID_REVISION_DESCRIPTOR);
                    this.oldSelection = null;
                }
            }
        };
        this.historyTable.addSelectionChangedListener(this.historyTableListener);
        if (this.useCheckboxes) {
            this.historyTable.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean isChecked = event.getChecked();
                    ILogNode checkedNode = (ILogNode)event.getElement();
                    if (checkedNode.getType() == 1) {
                        ILogNode[] iLogNodeArray = checkedNode.getChildren();
                        int n = iLogNodeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILogNode node = iLogNodeArray[n2];
                            LogMessagesComposite.this.historyTable.setChecked((Object)node, isChecked);
                            ++n2;
                        }
                        LogMessagesComposite.this.historyTable.setGrayed((Object)checkedNode, false);
                    } else if (checkedNode.getType() == 2) {
                        if (checkedNode.getParent().getType() == 2) {
                            LogMessagesComposite.this.historyTable.setChecked((Object)checkedNode, false);
                        } else {
                            ILogNode[] children;
                            int uncheckedCount = 0;
                            ILogNode parent = checkedNode.getParent();
                            ILogNode[] iLogNodeArray = children = parent.getChildren();
                            int n = children.length;
                            int n3 = 0;
                            while (n3 < n) {
                                ILogNode node = iLogNodeArray[n3];
                                if (!LogMessagesComposite.this.historyTable.getChecked((Object)node)) {
                                    ++uncheckedCount;
                                }
                                ++n3;
                            }
                            if (uncheckedCount == children.length) {
                                LogMessagesComposite.this.historyTable.setChecked((Object)parent, false);
                                LogMessagesComposite.this.historyTable.setGrayed((Object)parent, false);
                            } else {
                                LogMessagesComposite.this.historyTable.setChecked((Object)parent, true);
                                LogMessagesComposite.this.historyTable.setGrayed((Object)parent, uncheckedCount > 0);
                            }
                        }
                    }
                }
            });
        }
        this.historyTable.setAutoExpandLevel(2);
        this.historyTable.setInput((Object)new CategoryLogNode(this.rootCategory));
    }

    private void initializeFont() {
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] data = defaultFont.getFontData();
        int i = 0;
        while (i < data.length) {
            data[i].setStyle(1);
            ++i;
        }
        this.currentRevisionFont = new Font((Device)this.getDisplay(), data);
    }

    protected class HistoryLabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    IColorProvider {
        private Color mergedRevisionsForeground;
        private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
        protected IPropertyChangeListener configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("preference.decoration.")) {
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            HistoryLabelProvider.this.loadConfiguration();
                            LogMessagesComposite.this.refresh(2);
                        }
                    });
                }
            }
        };

        public HistoryLabelProvider() {
            this.loadConfiguration();
            PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener(this.configurationListener);
        }

        protected void loadConfiguration() {
            if (this.mergedRevisionsForeground != null) {
                this.mergedRevisionsForeground.dispose();
            }
            ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            this.mergedRevisionsForeground = new Color((Device)Display.getCurrent(), current.getColorRegistry().get(ModelBusTeamPreferences.fullDecorationName("merged_revision_foreground_color")).getRGB());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                ILogNode node = (ILogNode)element;
                ImageDescriptor descr = node.getImageDescriptor();
                Image retVal = this.images.get(descr);
                if (descr != null && retVal == null) {
                    retVal = descr.createImage();
                    this.images.put(descr, retVal);
                }
                return retVal;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((ILogNode)element).getLabel(columnIndex, 0, LogMessagesComposite.this.info.getCurrentRevision());
        }

        public Font getFont(Object element) {
            return ((ILogNode)element).requiresBoldFont(LogMessagesComposite.this.info.getCurrentRevision()) ? LogMessagesComposite.this.currentRevisionFont : null;
        }

        public void dispose() {
            PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener(this.configurationListener);
            for (Image img : this.images.values()) {
                img.dispose();
            }
            this.mergedRevisionsForeground.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ILogNode node = (ILogNode)element;
            return node.getType() == 2 && node.getParent() instanceof ModelBusLogNode ? this.mergedRevisionsForeground : null;
        }
    }

    protected class HistoryTableComparator
    extends ColumnedViewerComparator {
        public HistoryTableComparator(Viewer treeViewer) {
            super(treeViewer);
        }

        @Override
        public int compareImpl(Viewer viewer, Object row1, Object row2) {
            ILogNode node1 = (ILogNode)row1;
            ILogNode node2 = (ILogNode)row2;
            switch (this.column) {
                case 0: {
                    ModelBusRevision rev1 = node1.getRevision();
                    ModelBusRevision rev2 = node2.getRevision();
                    if (!"-1".equals(rev1) && !"-1".equals(rev2)) {
                        return rev1.isLowerThan(rev2) ? -1 : (rev1.isGreaterThan(rev2) ? 1 : 0);
                    }
                }
                case 1: {
                    return node1.getTimeStamp() < node2.getTimeStamp() ? -1 : (node1.getTimeStamp() > node2.getTimeStamp() ? 1 : 0);
                }
                case 2: {
                    return node1.getChangesCount() < node2.getChangesCount() ? -1 : (node1.getChangesCount() > node2.getChangesCount() ? 1 : 0);
                }
                case 3: {
                    return ColumnedViewerComparator.compare(node1.getAuthor(), node2.getAuthor());
                }
                case 4: {
                    return ColumnedViewerComparator.compare(node1.getComment(), node2.getComment());
                }
            }
            return 0;
        }
    }
}

