/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.data;

import java.util.ArrayList;
import java.util.List;
import org.modelbus.team.eclipse.ui.history.data.ModelBusChangedPathData;

public class AffectedPathsNode {
    protected String name;
    protected String compressedName;
    protected List<AffectedPathsNode> children;
    protected AffectedPathsNode parent;
    protected ArrayList<ModelBusChangedPathData> data;
    protected char status;

    public AffectedPathsNode(String name, AffectedPathsNode parent, char status) {
        this.name = this.compressedName = name;
        this.parent = parent;
        this.data = new ArrayList();
        this.children = new ArrayList<AffectedPathsNode>();
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public String getCompressedName() {
        return this.compressedName;
    }

    public void addCompressedNameSegment(String compressedName) {
        this.compressedName = String.valueOf(this.compressedName) + "/" + compressedName;
    }

    public String toString() {
        return this.compressedName;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public AffectedPathsNode getParent() {
        return this.parent;
    }

    public List<AffectedPathsNode> getChildren() {
        return this.children;
    }

    public boolean addChild(AffectedPathsNode child) {
        if (this.children.contains(child)) {
            return false;
        }
        return this.children.add(child);
    }

    public boolean removeChild(AffectedPathsNode child) {
        if (this.children.contains(child)) {
            return this.children.remove(child);
        }
        return false;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof AffectedPathsNode) {
            AffectedPathsNode node2 = (AffectedPathsNode)arg0;
            if (this.parent == null) {
                return node2.parent == null;
            }
            if (this.parent.equals(node2.parent) && this.name.equals(node2.name)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = 17;
        h += 31 * (this.parent != null ? this.parent.hashCode() : 0);
        return h += 31 * this.name.hashCode();
    }

    public ModelBusChangedPathData[] getData() {
        return this.data.toArray(new ModelBusChangedPathData[this.data.size()]);
    }

    protected List<ModelBusChangedPathData> getPathDataImpl(List<ModelBusChangedPathData> result) {
        result.addAll(this.data);
        for (AffectedPathsNode node : this.children) {
            node.getPathDataImpl(result);
        }
        return result;
    }

    public void addData(ModelBusChangedPathData data) {
        if (!this.data.contains(data)) {
            this.data.add(data);
        }
    }

    public ModelBusChangedPathData[] getPathData() {
        List<ModelBusChangedPathData> tmp = this.getPathDataImpl(new ArrayList<ModelBusChangedPathData>());
        return tmp.toArray(new ModelBusChangedPathData[tmp.size()]);
    }

    public void setParent(AffectedPathsNode parent) {
        this.parent = parent;
    }

    public void setChildren(List<AffectedPathsNode> children) {
        if (children != null) {
            this.children = children;
        } else {
            this.children.clear();
        }
    }

    public String getFullPath() {
        return this.parent != null ? String.valueOf(this.parent.getFullPath()) + "/" + this.compressedName : "";
    }

    public char getStatus() {
        return this.status;
    }

    public void setStatus(char status) {
        this.status = status;
    }
}

