/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.operation.UILoggedOperation;
import org.modelbus.team.eclipse.ui.utility.DateFormatter;

public class ModelBusLocalFileRevision
extends LocalFileRevision
implements IEditableContent {
    public ModelBusLocalFileRevision(IFile file) {
        super(file);
    }

    public ModelBusLocalFileRevision(IFileState fileState) {
        super(fileState);
    }

    public String getComment() {
        if (this.getFile() != null) {
            return ModelBusTeamUIPlugin.instance().getResource("ModelBusLocalFileRevision.CurrentVersion");
        }
        return "";
    }

    public String getContentIdentifier() {
        if (this.getFile() != null) {
            return "";
        }
        return "[" + DateFormatter.formatDate(this.getTimestamp()) + "]";
    }

    public boolean isEditable() {
        return this.isCurrentState();
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return dest;
    }

    public void setContent(byte[] newContent) {
        if (this.isEditable()) {
            try {
                this.getFile().setContents((InputStream)new ByteArrayInputStream(newContent), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                UILoggedOperation.reportError(ModelBusTeamUIPlugin.instance().getResource("Operation.GetFileContent.SetContent"), ex);
            }
        }
    }
}

