/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusLogPath;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.history.IModelBusHistoryViewInfo;
import org.modelbus.team.eclipse.ui.history.data.HistoryCategory;
import org.modelbus.team.eclipse.ui.history.data.ModelBusChangedPathData;
import org.modelbus.team.eclipse.ui.history.data.ModelBusLocalFileRevision;
import org.modelbus.team.eclipse.ui.history.model.ILogNode;

public class RootHistoryCategory
extends HistoryCategory {
    public static String[] NO_REMOTE;
    public static String[] NO_LOCAL;
    public static String[] NO_REVS;
    public static String[] PENDING;
    protected Object[] allHistory;
    protected ModelBusLocalFileRevision[] localHistory;
    protected ModelBusLogEntry[] remoteHistory;
    protected HistoryCategory[] categoriesBoth;
    protected HistoryCategory[] categoriesRemote;
    protected HistoryCategory[] categoriesLocal;
    protected Map<Object, ModelBusChangedPathData[]> pathData;
    protected Set<String> relatedPathsPrefixes;
    protected Set<String> relatedParents;
    protected IModelBusHistoryViewInfo info;

    public RootHistoryCategory(IModelBusHistoryViewInfo info) {
        super(0, null);
        if (NO_REMOTE == null) {
            NO_REMOTE = new String[]{ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.NoRemote")};
            NO_LOCAL = new String[]{ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.NoLocal")};
            NO_REVS = new String[]{ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.NoRevs")};
            PENDING = new String[]{ModelBusTeamUIPlugin.instance().getResource("RepositoriesView.Model.Pending")};
        }
        this.info = info;
        this.pathData = new HashMap<Object, ModelBusChangedPathData[]>();
    }

    public ModelBusLogEntry[] getRemoteHistory() {
        return this.remoteHistory;
    }

    public ModelBusLocalFileRevision[] getLocalHistory() {
        return this.localHistory;
    }

    @Override
    public Object[] getEntries() {
        switch (this.info.getMode()) {
            case 64: {
                return this.getLocalHistoryInternal();
            }
            case 128: {
                return this.getRemoteHistoryInternal();
            }
        }
        return this.getAllHistoryInternal();
    }

    public Collection<String> getRelatedPathPrefixes() {
        return this.relatedPathsPrefixes;
    }

    public Collection<String> getRelatedParents() {
        return this.relatedParents;
    }

    public ModelBusChangedPathData[] getPathData(ILogNode key) {
        return this.pathData.get(key == null ? null : key.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        IModelBusHistoryViewInfo iModelBusHistoryViewInfo = this.info;
        synchronized (iModelBusHistoryViewInfo) {
            this.localHistory = this.info.getLocalHistory();
            this.remoteHistory = this.info.getRemoteHistory();
            if (this.localHistory == null) {
                this.allHistory = this.remoteHistory;
            } else if (this.remoteHistory == null) {
                this.allHistory = this.localHistory;
            } else {
                this.allHistory = new Object[this.localHistory.length + this.remoteHistory.length];
                System.arraycopy(this.localHistory, 0, this.allHistory, 0, this.localHistory.length);
                System.arraycopy(this.remoteHistory, 0, this.allHistory, this.localHistory.length, this.remoteHistory.length);
            }
            this.collectRelatedNodes();
            this.collectCategoriesAndMapData();
        }
    }

    protected void collectRelatedNodes() {
        this.relatedPathsPrefixes = null;
        this.relatedParents = null;
        if (this.remoteHistory != null) {
            ModelBusLogPath[] changes = null;
            ModelBusLogEntry[] modelBusLogEntryArray = this.remoteHistory;
            int n = this.remoteHistory.length;
            int n2 = 0;
            while (n2 < n) {
                ModelBusLogEntry msg = modelBusLogEntryArray[n2];
                if (msg.changedPaths != null && msg.changedPaths.length > 0) {
                    changes = msg.changedPaths;
                    break;
                }
                ++n2;
            }
            if (changes != null) {
                String baseUrl = this.info.getRepositoryResource().getUrl();
                String changePath = changes[0].path;
                int idx = -1;
                while (changePath.length() > 0 && (idx = baseUrl.indexOf(changePath)) == -1) {
                    changePath = new Path(changePath).removeLastSegments(1).toString();
                }
                if (idx != -1 && idx < baseUrl.length()) {
                    String relatedPathsPrefix = baseUrl.substring(idx + 1, baseUrl.length());
                    this.relatedPathsPrefixes = new HashSet<String>();
                    this.relatedParents = new HashSet<String>();
                    ModelBusLogEntry[] modelBusLogEntryArray2 = this.remoteHistory;
                    int n3 = this.remoteHistory.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ModelBusLogEntry msg = modelBusLogEntryArray2[n4];
                        this.relatedPathsPrefixes.add(relatedPathsPrefix);
                        if (msg.changedPaths != null && msg.changedPaths.length > 0) {
                            relatedPathsPrefix = this.getNextPrefix(msg, relatedPathsPrefix);
                        }
                        ++n4;
                    }
                }
            }
        }
    }

    protected String getNextPrefix(ModelBusLogEntry message, String current) {
        String checked = "/" + current;
        ModelBusLogPath[] changes = message.changedPaths;
        int i = 0;
        while (i < changes.length) {
            if (changes[i].copiedFromPath != null && checked.startsWith(changes[i].path)) {
                String rest = checked.substring(changes[i].path.length());
                String relatedParent = changes[i].copiedFromPath.substring(1);
                this.relatedParents.add(relatedParent);
                this.relatedParents.add(changes[i].path.substring(1));
                return String.valueOf(relatedParent) + rest;
            }
            ++i;
        }
        return current;
    }

    protected void collectCategoriesAndMapData() {
        int i;
        this.pathData.clear();
        ArrayList<HistoryCategory> categoriesAll = new ArrayList<HistoryCategory>();
        ArrayList<HistoryCategory> categoriesLocal = new ArrayList<HistoryCategory>();
        ArrayList<HistoryCategory> categoriesRemote = new ArrayList<HistoryCategory>();
        ArrayList<Object> todayEntriesAll = new ArrayList<Object>();
        ArrayList<Object> yesterdayEntriesAll = new ArrayList<Object>();
        ArrayList<Object> weekEntriesAll = new ArrayList<Object>();
        ArrayList<Object> monthEntriesAll = new ArrayList<Object>();
        ArrayList<Object> earlierEntriesAll = new ArrayList<Object>();
        ArrayList<ModelBusLocalFileRevision> todayEntriesLocal = new ArrayList<ModelBusLocalFileRevision>();
        ArrayList<ModelBusLocalFileRevision> yesterdayEntriesLocal = new ArrayList<ModelBusLocalFileRevision>();
        ArrayList<ModelBusLocalFileRevision> weekEntriesLocal = new ArrayList<ModelBusLocalFileRevision>();
        ArrayList<ModelBusLocalFileRevision> monthEntriesLocal = new ArrayList<ModelBusLocalFileRevision>();
        ArrayList<ModelBusLocalFileRevision> earlierEntriesLocal = new ArrayList<ModelBusLocalFileRevision>();
        ArrayList<ModelBusLogEntry> todayEntriesRemote = new ArrayList<ModelBusLogEntry>();
        ArrayList<ModelBusLogEntry> yesterdayEntriesRemote = new ArrayList<ModelBusLogEntry>();
        ArrayList<ModelBusLogEntry> weekEntriesRemote = new ArrayList<ModelBusLogEntry>();
        ArrayList<ModelBusLogEntry> monthEntriesRemote = new ArrayList<ModelBusLogEntry>();
        ArrayList<ModelBusLogEntry> earlierEntriesRemote = new ArrayList<ModelBusLogEntry>();
        Calendar yesterdayCal = Calendar.getInstance();
        yesterdayCal.set(11, 0);
        yesterdayCal.set(12, 0);
        yesterdayCal.set(13, 0);
        long yesterdayDate = yesterdayCal.getTimeInMillis();
        Calendar beforeYesterdayCal = Calendar.getInstance();
        beforeYesterdayCal.roll(6, -1);
        beforeYesterdayCal.set(11, 0);
        beforeYesterdayCal.set(12, 0);
        beforeYesterdayCal.set(13, 0);
        long beforeYesterdayDate = beforeYesterdayCal.getTimeInMillis();
        Calendar weekCal = Calendar.getInstance();
        weekCal.roll(6, -7);
        weekCal.set(11, 0);
        weekCal.set(12, 0);
        weekCal.set(13, 0);
        long lastWeekDate = weekCal.getTimeInMillis();
        Calendar monthCal = Calendar.getInstance();
        monthCal.set(5, 1);
        monthCal.set(11, 0);
        monthCal.set(12, 0);
        monthCal.set(13, 0);
        long lastMonthDate = monthCal.getTimeInMillis();
        if (this.remoteHistory != null) {
            i = 0;
            while (i < this.remoteHistory.length) {
                this.mapPathData(this.remoteHistory[i]);
                if (this.remoteHistory[i].date >= yesterdayDate) {
                    todayEntriesAll.add(this.remoteHistory[i]);
                    todayEntriesRemote.add(this.remoteHistory[i]);
                } else if (this.remoteHistory[i].date < yesterdayDate && this.remoteHistory[i].date >= beforeYesterdayDate) {
                    yesterdayEntriesAll.add(this.remoteHistory[i]);
                    yesterdayEntriesRemote.add(this.remoteHistory[i]);
                } else if (this.remoteHistory[i].date < beforeYesterdayDate && this.remoteHistory[i].date >= lastWeekDate) {
                    weekEntriesAll.add(this.remoteHistory[i]);
                    weekEntriesRemote.add(this.remoteHistory[i]);
                } else if (this.remoteHistory[i].date < lastWeekDate && this.remoteHistory[i].date >= lastMonthDate) {
                    monthEntriesAll.add(this.remoteHistory[i]);
                    monthEntriesRemote.add(this.remoteHistory[i]);
                } else {
                    earlierEntriesAll.add(this.remoteHistory[i]);
                    earlierEntriesRemote.add(this.remoteHistory[i]);
                }
                ++i;
            }
        }
        if (this.localHistory != null) {
            i = 0;
            while (i < this.localHistory.length) {
                if (this.localHistory[i].getTimestamp() >= yesterdayDate) {
                    todayEntriesAll.add((Object)this.localHistory[i]);
                    todayEntriesLocal.add(this.localHistory[i]);
                } else if (this.localHistory[i].getTimestamp() < yesterdayDate && this.localHistory[i].getTimestamp() >= beforeYesterdayDate) {
                    yesterdayEntriesAll.add((Object)this.localHistory[i]);
                    yesterdayEntriesLocal.add(this.localHistory[i]);
                } else if (this.localHistory[i].getTimestamp() < beforeYesterdayDate && this.localHistory[i].getTimestamp() >= lastWeekDate) {
                    weekEntriesAll.add((Object)this.localHistory[i]);
                    weekEntriesLocal.add(this.localHistory[i]);
                } else if (this.localHistory[i].getTimestamp() < lastWeekDate && this.localHistory[i].getTimestamp() >= lastMonthDate) {
                    monthEntriesAll.add((Object)this.localHistory[i]);
                    monthEntriesLocal.add(this.localHistory[i]);
                } else {
                    earlierEntriesAll.add((Object)this.localHistory[i]);
                    earlierEntriesLocal.add(this.localHistory[i]);
                }
                ++i;
            }
        }
        HistoryCategory cat = null;
        if (todayEntriesAll.size() > 0) {
            cat = new HistoryCategory(1, todayEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (yesterdayEntriesAll.size() > 0) {
            cat = new HistoryCategory(2, yesterdayEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (weekEntriesAll.size() > 0) {
            cat = new HistoryCategory(3, weekEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (monthEntriesAll.size() > 0) {
            cat = new HistoryCategory(4, monthEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (earlierEntriesAll.size() > 0) {
            cat = new HistoryCategory(5, earlierEntriesAll.toArray());
            categoriesAll.add(cat);
        }
        if (todayEntriesLocal.size() > 0) {
            cat = new HistoryCategory(1, todayEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (yesterdayEntriesLocal.size() > 0) {
            cat = new HistoryCategory(2, yesterdayEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (weekEntriesLocal.size() > 0) {
            cat = new HistoryCategory(3, weekEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (monthEntriesLocal.size() > 0) {
            cat = new HistoryCategory(4, monthEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (earlierEntriesLocal.size() > 0) {
            cat = new HistoryCategory(5, earlierEntriesLocal.toArray());
            categoriesLocal.add(cat);
        }
        if (todayEntriesRemote.size() > 0) {
            cat = new HistoryCategory(1, todayEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (yesterdayEntriesRemote.size() > 0) {
            cat = new HistoryCategory(2, yesterdayEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (weekEntriesRemote.size() > 0) {
            cat = new HistoryCategory(3, weekEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (monthEntriesRemote.size() > 0) {
            cat = new HistoryCategory(4, monthEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        if (earlierEntriesRemote.size() > 0) {
            cat = new HistoryCategory(5, earlierEntriesRemote.toArray());
            categoriesRemote.add(cat);
        }
        this.categoriesBoth = categoriesAll.size() > 0 ? categoriesAll.toArray(new HistoryCategory[categoriesAll.size()]) : null;
        this.categoriesLocal = categoriesLocal.size() > 0 ? categoriesLocal.toArray(new HistoryCategory[categoriesLocal.size()]) : null;
        this.categoriesRemote = categoriesRemote.size() > 0 ? categoriesRemote.toArray(new HistoryCategory[categoriesRemote.size()]) : null;
    }

    protected void mapPathData(ModelBusLogEntry key) {
        ModelBusChangedPathData[] pathData = new ModelBusChangedPathData[key.changedPaths == null ? 0 : key.changedPaths.length];
        int i = 0;
        while (i < pathData.length) {
            String path = key.changedPaths[i].path;
            path = path.startsWith("/") ? path.substring(1) : path;
            int idx = path.lastIndexOf("/");
            pathData[i] = new ModelBusChangedPathData(key.changedPaths[i].action, idx != -1 ? path.substring(idx + 1) : path, idx != -1 ? path.substring(0, idx) : "", key.changedPaths[i].copiedFromRevision != ModelBusRevision.INVALID_REVISION_DESCRIPTOR ? key.changedPaths[i].copiedFromPath : "", key.changedPaths[i].copiedFromRevision);
            ++i;
        }
        this.pathData.put(key, pathData);
        ModelBusLogEntry[] children = key.getChildren();
        if (children != null) {
            ModelBusLogEntry[] modelBusLogEntryArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ModelBusLogEntry child = modelBusLogEntryArray[n2];
                this.mapPathData(child);
                ++n2;
            }
        }
    }

    protected Object[] getLocalHistoryInternal() {
        if (this.localHistory == null) {
            return NO_LOCAL;
        }
        return this.info.isGrouped() ? this.categoriesLocal : this.localHistory;
    }

    protected Object[] getRemoteHistoryInternal() {
        if (this.remoteHistory == null) {
            return this.info.isPending() ? PENDING : NO_REMOTE;
        }
        return this.info.isGrouped() ? this.categoriesRemote : this.remoteHistory;
    }

    protected Object[] getAllHistoryInternal() {
        if (this.allHistory == null) {
            return this.info.isPending() ? PENDING : NO_REVS;
        }
        return this.info.isGrouped() && this.categoriesBoth != null ? this.categoriesBoth : this.allHistory;
    }
}

