/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.filter;

import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.utility.StringMatcher;
import org.modelbus.team.eclipse.ui.history.filter.ILogEntryFilter;

public class AuthorNameLogEntryFilter
implements ILogEntryFilter {
    protected String authorNameToAccept;

    public AuthorNameLogEntryFilter() {
        this(null);
    }

    public AuthorNameLogEntryFilter(String authorNameToAccept) {
        this.authorNameToAccept = authorNameToAccept;
    }

    @Override
    public boolean accept(ModelBusLogEntry logEntry) {
        if (this.authorNameToAccept == null) {
            return true;
        }
        StringMatcher matcher = new StringMatcher(this.authorNameToAccept);
        String authorName = logEntry.author == null ? "" : logEntry.author;
        return matcher.match(authorName);
    }

    public void setAuthorNameToAccept(String authorNameToAccept) {
        this.authorNameToAccept = authorNameToAccept;
    }

    public String getAuthorNameToAccept() {
        return this.authorNameToAccept;
    }
}

