/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.filter;

import java.util.Arrays;
import java.util.HashSet;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.ui.history.filter.ILogEntryFilter;

public class CompositeLogEntryFilter
implements ILogEntryFilter {
    protected HashSet<ILogEntryFilter> filtersSet;

    public CompositeLogEntryFilter() {
        this.filtersSet = new HashSet();
    }

    public CompositeLogEntryFilter(ILogEntryFilter[] filters) {
        this.filtersSet = new HashSet<ILogEntryFilter>(Arrays.asList(filters));
    }

    @Override
    public boolean accept(ModelBusLogEntry logEntry) {
        for (ILogEntryFilter current : this.filtersSet) {
            if (current.accept(logEntry)) continue;
            return false;
        }
        return true;
    }

    public void addFilter(ILogEntryFilter filter) {
        this.filtersSet.add(filter);
    }

    public void removeFilter(ILogEntryFilter filter) {
        this.filtersSet.remove(filter);
    }
}

