/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.history.data.HistoryCategory;
import org.modelbus.team.eclipse.ui.history.data.ModelBusLocalFileRevision;
import org.modelbus.team.eclipse.ui.history.data.RootHistoryCategory;
import org.modelbus.team.eclipse.ui.history.model.AbstractLogNode;
import org.modelbus.team.eclipse.ui.history.model.ILogNode;
import org.modelbus.team.eclipse.ui.history.model.LocalLogNode;
import org.modelbus.team.eclipse.ui.history.model.ModelBusLogNode;
import org.modelbus.team.eclipse.ui.history.model.PlainTextLogNode;

public class CategoryLogNode
extends AbstractLogNode {
    protected HistoryCategory category;

    public CategoryLogNode(RootHistoryCategory category) {
        this(category, null);
    }

    public CategoryLogNode(HistoryCategory category, ILogNode parent) {
        super(parent);
        this.category = category;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(HistoryCategory.class)) {
            return this.category;
        }
        return null;
    }

    @Override
    public ILogNode[] getChildren() {
        Object[] entries = this.category.getEntries();
        ILogNode[] children = new ILogNode[entries.length];
        int i = 0;
        while (i < entries.length) {
            if (entries[i] instanceof ModelBusLogEntry) {
                children[i] = new ModelBusLogNode((ModelBusLogEntry)entries[i], this);
            } else if (entries[i] instanceof ModelBusLocalFileRevision) {
                children[i] = new LocalLogNode((ModelBusLocalFileRevision)((Object)entries[i]), this);
            } else if (entries[i] instanceof HistoryCategory) {
                children[i] = new CategoryLogNode((HistoryCategory)entries[i], this);
            } else if (entries[i] instanceof String) {
                children[i] = new PlainTextLogNode((String)entries[i], this);
            }
            ++i;
        }
        return children;
    }

    @Override
    public Object getEntity() {
        return this.category;
    }

    @Override
    public boolean requiresBoldFont(ModelBusRevision currentRevision) {
        return true;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/group_by_date.gif");
    }

    @Override
    public String getLabel(int columnIndex, int labelType, ModelBusRevision currentRevision) {
        if (columnIndex == 0) {
            return this.category.getName();
        }
        return "";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "";
    }

    @Override
    public int getChangesCount() {
        return 0;
    }

    @Override
    public String getComment() {
        return "";
    }

    @Override
    public ModelBusRevision getRevision() {
        return ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    public int hashCode() {
        return this.category.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryLogNode) {
            return this.category.equals(((CategoryLogNode)obj).category);
        }
        return false;
    }
}

