/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.history.IFileRevision;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.history.data.ModelBusLocalFileRevision;
import org.modelbus.team.eclipse.ui.history.model.AbstractLogNode;
import org.modelbus.team.eclipse.ui.history.model.ILogNode;
import org.modelbus.team.eclipse.ui.utility.DateFormatter;

public class LocalLogNode
extends AbstractLogNode {
    protected ModelBusLocalFileRevision entry;

    public LocalLogNode(ModelBusLocalFileRevision entry, ILogNode parent) {
        super(parent);
        this.entry = entry;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IFileRevision.class)) {
            return this.entry;
        }
        return null;
    }

    @Override
    public ILogNode[] getChildren() {
        return null;
    }

    @Override
    public Object getEntity() {
        return this.entry;
    }

    @Override
    public boolean requiresBoldFont(ModelBusRevision currentRevision) {
        return this.entry.isCurrentState();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return ModelBusTeamUIPlugin.instance().getImageDescriptor("icons/views/history/local_rev.gif");
    }

    @Override
    public String getLabel(int columnIndex, int labelType, ModelBusRevision currentRevision) {
        switch (columnIndex) {
            case 1: {
                return DateFormatter.formatDate(this.entry.getTimestamp());
            }
            case 0: {
                if (this.entry.isCurrentState()) {
                    if (!"-1".equals(currentRevision)) {
                        return ModelBusTeamUIPlugin.instance().getResource("LogMessagesComposite.CurrentRevision", new String[]{String.valueOf(currentRevision)});
                    }
                    return "*";
                }
                return "";
            }
            case 4: {
                String retVal = this.entry.getComment();
                if (labelType == 0) {
                    return FileUtility.formatMultilineText((String)retVal);
                }
                if (labelType == 1) {
                    return AbstractLogNode.flattenMultiLineText(retVal, " ");
                }
                return retVal;
            }
        }
        return "";
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public String getAuthor() {
        return "";
    }

    @Override
    public int getChangesCount() {
        return 0;
    }

    @Override
    public String getComment() {
        return this.entry.getComment();
    }

    @Override
    public ModelBusRevision getRevision() {
        return ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
    }

    @Override
    public long getTimeStamp() {
        return this.entry.getTimestamp();
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalLogNode) {
            return this.entry.equals((Object)((LocalLogNode)obj).entry);
        }
        return false;
    }
}

