/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.history.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusLogEntry;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.history.model.AbstractLogNode;
import org.modelbus.team.eclipse.ui.history.model.ILogNode;
import org.modelbus.team.eclipse.ui.utility.DateFormatter;

public class ModelBusLogNode
extends AbstractLogNode {
    protected ModelBusLogEntry entry;

    public ModelBusLogNode(ModelBusLogEntry entry, ILogNode parent) {
        super(parent);
        this.entry = entry;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ModelBusLogEntry.class)) {
            return this.entry;
        }
        return null;
    }

    @Override
    public ILogNode[] getChildren() {
        ModelBusLogEntry[] entries = this.entry.getChildren();
        ILogNode[] children = new ILogNode[entries.length];
        int i = 0;
        while (i < entries.length) {
            children[i] = new ModelBusLogNode(entries[i], this);
            ++i;
        }
        return children;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return ModelBusTeamUIPlugin.instance().getImageDescriptor(this.parent instanceof ModelBusLogNode ? "icons/objects/repository-gray.gif" : "icons/objects/repository.gif");
    }

    @Override
    public boolean requiresBoldFont(ModelBusRevision currentRevision) {
        return !"-1".equals(currentRevision) && this.entry.revision.equals(currentRevision);
    }

    @Override
    public String getLabel(int columnIndex, int labelType, ModelBusRevision currentRevision) {
        switch (columnIndex) {
            case 0: {
                String retVal = String.valueOf(this.entry.revision);
                if (currentRevision.equals((Object)this.entry.revision)) {
                    retVal = "*" + retVal;
                }
                return retVal;
            }
            case 1: {
                return this.entry.date == 0L ? ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoDate") : DateFormatter.formatDate(this.entry.date);
            }
            case 2: {
                return String.valueOf(this.entry.changedPaths != null ? this.entry.changedPaths.length : 0);
            }
            case 3: {
                return this.entry.author == null || this.entry.author.length() == 0 ? ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoAuthor") : this.entry.author;
            }
            case 4: {
                String retVal = this.entry.message;
                if (retVal == null || retVal.length() == 0) {
                    return ModelBusTeamPlugin.instance().getResource("ModelBusInfo.NoComment");
                }
                if (labelType == 0) {
                    return FileUtility.formatMultilineText((String)retVal);
                }
                if (labelType == 1) {
                    return AbstractLogNode.flattenMultiLineText(retVal, " ");
                }
                return retVal;
            }
        }
        return "";
    }

    @Override
    public Object getEntity() {
        return this.entry;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean hasChildren() {
        return this.entry.hasChildren();
    }

    @Override
    public String getAuthor() {
        return this.entry.author;
    }

    @Override
    public int getChangesCount() {
        return this.entry.changedPaths == null ? 0 : this.entry.changedPaths.length;
    }

    @Override
    public String getComment() {
        return this.entry.message;
    }

    @Override
    public ModelBusRevision getRevision() {
        return this.entry.modelBusRevision;
    }

    @Override
    public long getTimeStamp() {
        return this.entry.date;
    }

    public int hashCode() {
        return this.entry.revision.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelBusLogNode) {
            return this.entry.revision == ((ModelBusLogNode)obj).entry.revision;
        }
        return false;
    }
}

