/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.operation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryReference;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceProvider;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.compare.ResourceCompareInput;
import org.modelbus.team.eclipse.ui.compare.TwoWayResourceCompareInput;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class CompareRepositoryResourcesOperation
extends AbstractActionOperation {
    protected IRepositoryResource next;
    protected IRepositoryResource prev;
    protected IRepositoryResourceProvider provider;
    protected boolean forceReuse;
    protected String forceId;

    public CompareRepositoryResourcesOperation(IRepositoryResource prev, IRepositoryResource next) {
        this(prev, next, false);
    }

    public CompareRepositoryResourcesOperation(IRepositoryResource prev, IRepositoryResource next, boolean forceReuse) {
        super("Operation.CompareRepository");
        this.prev = prev;
        this.next = next;
        this.forceReuse = forceReuse;
    }

    public CompareRepositoryResourcesOperation(IRepositoryResourceProvider provider) {
        this(null, null, false);
        this.provider = provider;
    }

    public CompareRepositoryResourcesOperation(IRepositoryResourceProvider provider, boolean forceReuse) {
        this(null, null, forceReuse);
        this.provider = provider;
    }

    public void setForceId(String forceId) {
        this.forceId = forceId;
    }

    public String getForceId() {
        return this.forceId;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.provider != null) {
            IRepositoryResource[] toCompare = this.provider.getRepositoryResources();
            this.prev = toCompare[0];
            this.next = toCompare[1];
        }
        final LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{this.next, this.prev});
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
            }
        }, monitor, 100, 60);
        this.next = op.getRepositoryResources()[0];
        this.prev = op.getRepositoryResources()[1];
        final IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
        final ArrayList statuses = new ArrayList();
        ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)ModelBusTeamPlugin.instance().getResource("Progress.Running"));
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                ModelBusEntryRevisionReference refNext;
                ModelBusEntryRevisionReference refPrev = ModelBusUtility.getEntryRevisionReference((IRepositoryResource)CompareRepositoryResourcesOperation.this.prev);
                if (ModelBusUtility.useSingleReferenceSignature((ModelBusEntryRevisionReference)refPrev, (ModelBusEntryRevisionReference)(refNext = ModelBusUtility.getEntryRevisionReference((IRepositoryResource)CompareRepositoryResourcesOperation.this.next)))) {
                    ModelBusUtility.diffStatus((IModelBusConnector)proxy, (Collection)statuses, (ModelBusEntryReference)refPrev, (ModelBusRevision)refPrev.revision, (ModelBusRevision)refNext.revision, (int)3, (long)0L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)CompareRepositoryResourcesOperation.this, monitor, null, false));
                } else {
                    ModelBusUtility.diffStatus((IModelBusConnector)proxy, (Collection)statuses, (ModelBusEntryRevisionReference)refPrev, (ModelBusEntryRevisionReference)refNext, (int)3, (long)0L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)CompareRepositoryResourcesOperation.this, monitor, null, false));
                }
            }
        }, monitor, 100, 20);
        if (!monitor.isCanceled()) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    CompareConfiguration cc = new CompareConfiguration();
                    cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.FALSE);
                    final TwoWayResourceCompareInput compare = new TwoWayResourceCompareInput(cc, CompareRepositoryResourcesOperation.this.next, CompareRepositoryResourcesOperation.this.prev, statuses);
                    compare.setForceId(CompareRepositoryResourcesOperation.this.forceId);
                    compare.initialize(monitor);
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceCompareInput.openCompareEditor(compare, (this).CompareRepositoryResourcesOperation.this.forceReuse);
                        }
                    });
                }
            }, monitor, 100, 20);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.next.getName(), this.prev.getName());
    }
}

