/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.IModelbusEntryStatusCallback;
import org.modelbus.team.eclipse.core.connector.ModelBusChangeStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusDiffStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryReference;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.core.utility.ProgressMonitorUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.compare.ComparePanel;
import org.modelbus.team.eclipse.ui.compare.ResourceCompareInput;
import org.modelbus.team.eclipse.ui.compare.ThreeWayResourceCompareInput;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class CompareResourcesOperation
extends AbstractActionOperation {
    protected ILocalResource local;
    protected IRepositoryResource ancestor;
    protected IRepositoryResource remote;
    protected boolean showInDialog;
    protected boolean forceReuse;
    protected String forceId;

    public CompareResourcesOperation(ILocalResource local, IRepositoryResource remote) {
        this(local, remote, false, false);
    }

    public CompareResourcesOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse) {
        this(local, remote, forceReuse, false);
    }

    public CompareResourcesOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse, boolean showInDialog) {
        super("Operation.CompareLocal");
        this.local = local;
        this.ancestor = local.isCopied() ? ModelBusUtility.getCopiedFrom((IResource)local.getResource()) : ModelBusRemoteStorage.instance().asRepositoryResource(local.getResource());
        this.ancestor.setSelectedRevision(local.getBaseRevision());
        this.remote = remote;
        this.showInDialog = showInDialog;
        this.forceReuse = forceReuse;
    }

    public void setForceId(String forceId) {
        this.forceId = forceId;
    }

    public String getForceId() {
        return this.forceId;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final ArrayList localChanges = new ArrayList();
        final ArrayList remoteChanges = new ArrayList();
        final IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
        final IRepositoryResource[] diffPair = new IRepositoryResource[]{this.ancestor, this.remote};
        ModelBusRevision revision = this.remote.getSelectedRevision();
        boolean fetchRemote = revision.getKind() == 7 || revision.getKind() == 1;
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                proxy.status(FileUtility.getWorkingCopyPath((IResource)CompareResourcesOperation.this.local.getResource()), 3, 1L, null, new IModelbusEntryStatusCallback(){

                    public void next(ModelBusChangeStatus status) {
                        localChanges.add(new ModelBusDiffStatus(status.path, status.path, status.nodeKind, status.textStatus, status.propStatus));
                    }
                }, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)CompareResourcesOperation.this, monitor, null, false));
            }
        }, monitor, 100, fetchRemote ? 5 : 60);
        if (!monitor.isCanceled() && fetchRemote) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(diffPair);
                    ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
                    if (op.getExecutionState() != 0) {
                        CompareResourcesOperation.this.reportStatus(op.getStatus());
                        return;
                    }
                    diffPair[0] = op.getRepositoryResources()[0];
                    diffPair[1] = op.getRepositoryResources()[1];
                }
            }, monitor, 100, 55);
            if (this.getExecutionState() == 1) {
                return;
            }
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)CompareResourcesOperation.this, (String)ModelBusTeamPlugin.instance().getResource("Progress.Running"));
                    ModelBusEntryRevisionReference refPrev = ModelBusUtility.getEntryRevisionReference((IRepositoryResource)diffPair[0]);
                    ModelBusEntryRevisionReference refNext = ModelBusUtility.getEntryRevisionReference((IRepositoryResource)diffPair[1]);
                    if (ModelBusUtility.useSingleReferenceSignature((ModelBusEntryRevisionReference)refPrev, (ModelBusEntryRevisionReference)refNext)) {
                        ModelBusUtility.diffStatus((IModelBusConnector)proxy, (Collection)remoteChanges, (ModelBusEntryReference)refPrev, (ModelBusRevision)refPrev.revision, (ModelBusRevision)refNext.revision, (int)3, (long)0L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)CompareResourcesOperation.this, monitor, null, false));
                    } else {
                        ModelBusUtility.diffStatus((IModelBusConnector)proxy, (Collection)remoteChanges, (ModelBusEntryRevisionReference)refPrev, (ModelBusEntryRevisionReference)refNext, (int)3, (long)0L, (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)CompareResourcesOperation.this, monitor, null, false));
                    }
                }
            }, monitor, 100, 5);
        }
        if (!monitor.isCanceled()) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    CompareConfiguration cc = new CompareConfiguration();
                    cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
                    diffPair[0].setSelectedRevision(ModelBusRevision.BASE);
                    final ThreeWayResourceCompareInput compare = new ThreeWayResourceCompareInput(cc, CompareResourcesOperation.this.local, diffPair[0], diffPair[1], localChanges, remoteChanges);
                    compare.setForceId(CompareResourcesOperation.this.forceId);
                    compare.initialize(monitor);
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).CompareResourcesOperation.this.showInDialog) {
                                if (CompareResourcesOperation.this.compareResultOK(compare)) {
                                    ComparePanel panel = new ComparePanel(compare, (this).CompareResourcesOperation.this.local.getResource());
                                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                                    dialog.open();
                                }
                            } else {
                                ResourceCompareInput.openCompareEditor(compare, (this).CompareResourcesOperation.this.forceReuse);
                            }
                        }
                    });
                }
            }, monitor, 100, 40);
        }
    }

    protected boolean compareResultOK(CompareEditorInput input) {
        block5: {
            Shell shell = UIMonitorUtility.getShell();
            try {
                ModelBusTeamUIPlugin.instance().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
                String message = input.getMessage();
                if (message != null) {
                    MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)message);
                    break block5;
                }
                if (input.getCompareResult() == null) {
                    MessageDialog.openInformation((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.dialogTitle"), (String)Utilities.getString((String)"CompareUIPlugin.noDifferences"));
                    break block5;
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException x) {
                MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
            }
        }
        return false;
    }
}

