/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.operation;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.GetLogMessagesOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class CorrectRevisionOperation
extends AbstractActionOperation {
    protected IRepositoryResource[] repositoryResources;
    protected String[] knownRevisions;
    protected GetLogMessagesOperation[] msgsOps;
    protected IResource[] resources;

    public CorrectRevisionOperation(GetLogMessagesOperation msgsOp, IRepositoryResource repositoryResource, ModelBusRevision knownRevision, IResource resource) {
        GetLogMessagesOperation[] getLogMessagesOperationArray;
        if (msgsOp == null) {
            getLogMessagesOperationArray = null;
        } else {
            GetLogMessagesOperation[] getLogMessagesOperationArray2 = new GetLogMessagesOperation[1];
            getLogMessagesOperationArray = getLogMessagesOperationArray2;
            getLogMessagesOperationArray2[0] = msgsOp;
        }
        this(getLogMessagesOperationArray, new IRepositoryResource[]{repositoryResource}, new String[]{knownRevision.getRevision()}, new IResource[]{resource});
    }

    public CorrectRevisionOperation(GetLogMessagesOperation[] msgsOps, IRepositoryResource[] repositoryResources, String[] knownRevisions, IResource[] resources) {
        super("Operation.CorrectRevision");
        this.repositoryResources = repositoryResources;
        this.knownRevisions = knownRevisions;
        this.msgsOps = msgsOps;
        this.resources = resources;
    }

    public int getOperationWeight() {
        if (this.msgsOps == null) {
            return 0;
        }
        return super.getOperationWeight();
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        boolean hasWarning = false;
        int i = 0;
        while (i < this.repositoryResources.length) {
            if (!this.repositoryResources[i].exists() && this.resources != null && this.resources[i] != null && this.resources[i].getType() != 4) {
                boolean switchedStateEquals;
                ILocalResource parent = ModelBusRemoteStorage.instance().asLocalResourceAccessible((IResource)this.resources[i].getParent());
                ILocalResource self = ModelBusRemoteStorage.instance().asLocalResourceAccessible(this.resources[i]);
                boolean bl = switchedStateEquals = (parent.getChangeMask() & 8) == (self.getChangeMask() & 8);
                if (switchedStateEquals) {
                    ModelBusRevision selfRevision;
                    ModelBusRevision revision;
                    ModelBusRevision parentRevision = parent.getRevision();
                    ModelBusRevision modelBusRevision = revision = parentRevision.isGreaterThan(selfRevision = self.getRevision()) ? parentRevision : selfRevision;
                    if (revision != ModelBusRevision.INVALID_REVISION_DESCRIPTOR) {
                        this.repositoryResources[i].setPegRevision(revision);
                    }
                } else {
                    this.repositoryResources[i].setPegRevision(self.getRevision());
                }
            }
            if (!this.repositoryResources[i].exists() && this.knownRevisions[i] != "-1") {
                hasWarning = true;
                ModelBusRevision rev = ModelBusRevision.fromString((String)this.knownRevisions[i]);
                this.repositoryResources[i].setSelectedRevision(rev);
                this.repositoryResources[i].setPegRevision(rev);
                if (this.msgsOps != null) {
                    this.msgsOps[i].setStartRevision(rev);
                }
            }
            ++i;
        }
        if (hasWarning) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean one = CorrectRevisionOperation.this.repositoryResources.length == 1;
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), CorrectRevisionOperation.this.getOperationResource(one ? "Title.Single" : "Title.Multi"), null, CorrectRevisionOperation.this.getOperationResource(one ? "Message.Single" : "Message.Multi"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    if (dlg.open() != 0) {
                        monitor.setCanceled(true);
                    }
                }
            });
        }
    }
}

