/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.operation;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.connector.ModelBusEntryRevisionReference;
import org.modelbus.team.eclipse.core.connector.ModelBusProperty;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.AbstractActionOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.operation.UnreportableException;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;

public class GetRemoteFolderChildrenOperation
extends AbstractActionOperation {
    protected IRepositoryContainer parent;
    protected IRepositoryResource[] children;
    protected boolean sortChildren;
    protected Map<IRepositoryResource, String> externalsNames;

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent) {
        this(parent, true);
    }

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent, boolean sortChildren) {
        super("Operation.GetRemoteChildren");
        this.parent = parent;
        this.sortChildren = sortChildren;
        this.externalsNames = new HashMap<IRepositoryResource, String>();
    }

    public IRepositoryResource[] getChildren() {
        return this.children;
    }

    public String getExternalsName(IRepositoryResource resource) {
        return this.externalsNames.get(resource);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IModelBusConnector proxy;
        ModelBusProperty data;
        IRepositoryResource[] tmp = this.parent.getChildren();
        IRepositoryResource.Information info = this.parent.getInfo();
        if (info != null && info.hasProperties && ModelBusTeamPreferences.getRepositoryBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "showExternals") && (data = (proxy = ModelBusConnector.getModelBusConnector()).getProperty(ModelBusUtility.getEntryRevisionReference((IRepositoryResource)this.parent), "modelbus:externals", (IModelBusProgressMonitor)new ModelBusProgressMonitor((IActionOperation)this, monitor, null))) != null) {
            try {
                Map externals = ModelBusUtility.parseModelBusExternalsProperty((String)data.value, (IRepositoryResource)this.parent);
                IRepositoryResource[] newTmp = new IRepositoryResource[tmp.length + externals.size()];
                System.arraycopy(tmp, 0, newTmp, 0, tmp.length);
                int i = 0;
                for (Map.Entry entry : externals.entrySet()) {
                    String name = (String)entry.getKey();
                    ModelBusEntryRevisionReference ref = (ModelBusEntryRevisionReference)entry.getValue();
                    newTmp[tmp.length + i] = ModelBusRemoteStorage.instance().asRepositoryResource(ref.path, false);
                    newTmp[tmp.length + i].setSelectedRevision(ref.revision);
                    newTmp[tmp.length + i].setPegRevision(ref.pegRevision);
                    this.externalsNames.put(newTmp[tmp.length + i], name);
                    ++i;
                }
                tmp = newTmp;
            }
            catch (UnreportableException ex) {
                this.reportStatus((IStatus)new Status(2, "org.modelbus.team.eclipse.core.modelbusnature", 0, this.getShortErrorMessage(ex), (Throwable)ex));
            }
        }
        if (this.sortChildren) {
            Arrays.sort(tmp, new Comparator<IRepositoryResource>(){

                @Override
                public int compare(IRepositoryResource first, IRepositoryResource second) {
                    boolean firstContainer = first instanceof IRepositoryContainer;
                    boolean secondContainer = second instanceof IRepositoryContainer;
                    if (firstContainer && secondContainer) {
                        boolean firstRoot = first instanceof IRepositoryRoot;
                        boolean secondRoot = second instanceof IRepositoryRoot;
                        return firstRoot == secondRoot ? (firstRoot ? this.compareRoots(((IRepositoryRoot)first).getKind(), ((IRepositoryRoot)second).getKind()) : first.getUrl().compareTo(second.getUrl())) : (firstRoot ? -1 : 1);
                    }
                    return firstContainer == secondContainer ? first.getUrl().compareTo(second.getUrl()) : (firstContainer ? -1 : 1);
                }

                public int compareRoots(int firstKind, int secondKind) {
                    return firstKind < secondKind ? -1 : 1;
                }
            });
        }
        this.children = tmp;
    }
}

