/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.operation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.local.AbstractWorkingCopyOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.annotate.BuiltInAnnotate;
import org.modelbus.team.eclipse.ui.operation.CorrectRevisionOperation;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class LocalShowAnnotationOperation
extends AbstractWorkingCopyOperation {
    protected ModelBusRevision revision;

    public LocalShowAnnotationOperation(IResource resource) {
        this(resource, null);
    }

    public LocalShowAnnotationOperation(IResource resource, ModelBusRevision revision) {
        super("Operation.ShowAnnotation", new IResource[]{resource});
        this.revision = revision;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final IResource resource = this.operableData()[0];
        ILocalResource local = ModelBusRemoteStorage.instance().asLocalResourceAccessible(resource);
        boolean notExists = IStateFilter.SF_NOTEXISTS.accept(local);
        ModelBusRevision revision = this.revision != null ? this.revision : (notExists || local.getRevision() == ModelBusRevision.INVALID_REVISION_DESCRIPTOR ? ModelBusRevision.HEAD : local.getRevision());
        final IRepositoryResource remote = ModelBusRemoteStorage.instance().asRepositoryResource(resource);
        remote.setSelectedRevision(revision);
        final CorrectRevisionOperation correctOp = new CorrectRevisionOperation(null, remote, local.getRevision(), resource);
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                correctOp.run(monitor);
            }
        }, monitor, 1);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = UIMonitorUtility.getActivePage();
                if (page != null) {
                    new BuiltInAnnotate().open(page, remote, (IFile)resource);
                }
            }
        });
    }
}

