/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.operation;

import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.modelbus.team.eclipse.core.connector.IModelBusConnector;
import org.modelbus.team.eclipse.core.connector.IModelBusProgressMonitor;
import org.modelbus.team.eclipse.core.connector.ModelBusChangeStatus;
import org.modelbus.team.eclipse.core.connector.ModelBusConnector;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.IUnprotectedOperation;
import org.modelbus.team.eclipse.core.operation.ModelBusNullProgressMonitor;
import org.modelbus.team.eclipse.core.operation.ModelBusResourceRuleFactory;
import org.modelbus.team.eclipse.core.operation.local.AbstractWorkingCopyOperation;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.compare.ComparePanel;
import org.modelbus.team.eclipse.ui.compare.ConflictingFileEditorInput;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class ShowConflictEditorOperation
extends AbstractWorkingCopyOperation {
    protected boolean showInDialog;

    public ShowConflictEditorOperation(IResource[] resources, boolean showInDialog) {
        super("Operation.ShowConflictEditor", resources);
        this.showInDialog = showInDialog;
    }

    public ShowConflictEditorOperation(IResourceProvider provider, boolean showInDialog) {
        super("Operation.ShowConflictEditor", provider);
        this.showInDialog = showInDialog;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = super.getSchedulingRule();
        if (rule instanceof IWorkspaceRoot) {
            return rule;
        }
        IResource[] resources = this.operableData();
        HashSet<ISchedulingRule> ruleSet = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            ruleSet.add(ModelBusResourceRuleFactory.INSTANCE.refreshRule((IResource)resources[i].getParent()));
            ++i;
        }
        return new MultiRule((ISchedulingRule[])ruleSet.toArray(new IResource[ruleSet.size()]));
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] conflictingResources = this.operableData();
        int i = 0;
        while (i < conflictingResources.length && !monitor.isCanceled()) {
            final IResource current = conflictingResources[i];
            if (current.getType() == 1) {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        ShowConflictEditorOperation.this.showEditorFor((IFile)current, monitor);
                    }
                }, monitor, conflictingResources.length);
            }
            ++i;
        }
    }

    protected void showEditorFor(IFile resource, IProgressMonitor monitor) throws Exception {
        ModelBusRemoteStorage.instance();
        IModelBusConnector proxy = ModelBusConnector.getModelBusConnector();
        ModelBusChangeStatus[] status = ModelBusUtility.status((IModelBusConnector)proxy, (String)FileUtility.getWorkingCopyPath((IResource)resource), (int)0, (long)0L, (IModelBusProgressMonitor)new ModelBusNullProgressMonitor());
        if (status.length == 1) {
            IContainer parent = resource.getParent();
            parent.refreshLocal(1, monitor);
            IFile local = parent.getFile((IPath)new Path(status[0].conflictWorking));
            IFile remote = parent.getFile((IPath)new Path(status[0].conflictNew));
            IFile ancestor = parent.getFile((IPath)new Path(status[0].conflictOld));
            this.openEditor(resource, local, remote, ancestor, monitor);
        }
    }

    protected void openEditor(final IFile target, IFile left, IFile right, IFile ancestor, IProgressMonitor monitor) throws Exception {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
        final ConflictingFileEditorInput compare = new ConflictingFileEditorInput(cc, target, left, right, ancestor);
        compare.run(monitor);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ShowConflictEditorOperation.this.showInDialog) {
                    ComparePanel panel = new ComparePanel(compare, (IResource)target);
                    DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                    dlg.open();
                } else {
                    CompareUI.openCompareEditor((CompareEditorInput)compare);
                }
            }
        });
    }
}

