/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.operation;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorAuthenticationException;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorCancelException;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorException;
import org.modelbus.team.eclipse.core.operation.ActivityCancelledException;
import org.modelbus.team.eclipse.core.operation.HiddenException;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.LoggedOperation;
import org.modelbus.team.eclipse.core.operation.UnreportableException;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.debugmail.ReportPartsFactory;
import org.modelbus.team.eclipse.ui.extension.factory.IReporter;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.DefaultOperationWrapperFactory;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class UILoggedOperation
extends LoggedOperation {
    protected static LinkedList<Object[]> errorQueue = new LinkedList();

    public UILoggedOperation(IActionOperation op) {
        super(op);
    }

    public static void reportError(String where, Throwable t) {
        String errMessage = ModelBusTeamPlugin.instance().getResource("Operation.Error.LogHeader", (Object[])new String[]{where});
        MultiStatus status = new MultiStatus("org.modelbus.team.eclipse.core.modelbusnature", 0, errMessage, null);
        Status st = new Status(4, "org.modelbus.team.eclipse.core.modelbusnature", 0, String.valueOf(status.getMessage()) + ": " + t.getMessage(), t);
        status.merge((IStatus)st);
        UILoggedOperation.logError((IStatus)st);
        UILoggedOperation.showError("org.modelbus.team.eclipse.core.modelbusnature", where, (IStatus)st);
    }

    protected void handleError(IStatus errorStatus) {
        super.handleError(errorStatus);
        if (errorStatus.matches(4)) {
            UILoggedOperation.showError("org.modelbus.team.eclipse.core.modelbusnature", this.getOperationName(), errorStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showError(String pluginID, String operationName, IStatus errorStatus) {
        OperationErrorInfo errorInfo = UILoggedOperation.formatMessage(errorStatus, false);
        if (errorInfo == null) {
            return;
        }
        LinkedList<Object[]> linkedList = errorQueue;
        synchronized (linkedList) {
            errorQueue.add(new Object[]{pluginID, operationName, errorStatus});
            if (errorQueue.size() == 1) {
                Job job = new Job(""){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        boolean showCheckBox = ModelBusTeamPreferences.getMailReporterBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "enabled");
                        while (!monitor.isCanceled()) {
                            IStatus errorStatus;
                            String operationName;
                            String pluginID;
                            LinkedList<Object[]> linkedList = errorQueue;
                            synchronized (linkedList) {
                                if (errorQueue.size() == 0) {
                                    break;
                                }
                                Object[] entry = errorQueue.get(0);
                                pluginID = (String)entry[0];
                                operationName = (String)entry[1];
                                errorStatus = (IStatus)entry[2];
                                Iterator it = errorQueue.iterator();
                                it.next();
                                while (it.hasNext()) {
                                    MultiStatus ms;
                                    entry = (Object[])it.next();
                                    if (!pluginID.equals(entry[0]) || !operationName.equals(entry[1])) continue;
                                    if (!(errorStatus instanceof MultiStatus)) {
                                        ms = new MultiStatus(errorStatus.getPlugin(), errorStatus.getCode(), errorStatus.getMessage(), errorStatus.getException());
                                        errorStatus = ms;
                                    } else {
                                        ms = (MultiStatus)errorStatus;
                                    }
                                    ms.addAll((IStatus)entry[2]);
                                    it.remove();
                                }
                            }
                            boolean doNotShowAgain = UILoggedOperation.showErrorImpl(pluginID, operationName, errorStatus, true, showCheckBox ? ModelBusTeamUIPlugin.instance().getResource("UILoggedOperation.DontAskSend") : null, null);
                            if (showCheckBox && doNotShowAgain) {
                                showCheckBox = !doNotShowAgain;
                                ModelBusTeamPreferences.setMailReporterBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "enabled", false);
                            }
                            LinkedList<Object[]> linkedList2 = errorQueue;
                            synchronized (linkedList2) {
                                errorQueue.remove(0);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    protected static boolean showErrorImpl(String pluginID, String operationName, IStatus errorStatus, boolean isReportingAllowed, String optionName, String originalReport) {
        return false;
    }

    public static void sendReport(final IReporter reporter) {
        boolean doNotShowAgain;
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                UIMonitorUtility.doTaskNow(UIMonitorUtility.getShell(), reporter, true, new DefaultOperationWrapperFactory(){

                    @Override
                    protected IActionOperation wrappedOperation(IActionOperation operation) {
                        return new LoggedOperation(operation);
                    }
                });
            }
        });
        if (reporter.getExecutionState() != 0 && ModelBusTeamPreferences.getMailReporterBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "errorsEnabled") && (doNotShowAgain = UILoggedOperation.showErrorImpl("org.modelbus.team.eclipse.core.modelbusnature", ModelBusTeamUIPlugin.instance().getResource("UILoggedOperation.SendReport.Error.Title"), reporter.getStatus(), false, ModelBusTeamUIPlugin.instance().getResource("UILoggedOperation.SendReport.Error.DontShow"), reporter.buildReport()))) {
            ModelBusTeamPreferences.setMailReporterBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "errorsEnabled", false);
        }
    }

    public static OperationErrorInfo formatMessage(IStatus status, boolean allowsCancelled) {
        if (!status.isMultiStatus()) {
            Throwable ex = status.getException();
            if (!allowsCancelled && (ex instanceof ModelBusConnectorCancelException || ex instanceof ActivityCancelledException || ex instanceof OperationCanceledException) || ex instanceof HiddenException) {
                return null;
            }
            String simpleMsg = UILoggedOperation.getSimpleMessage(status);
            if (ex instanceof ModelBusConnectorCancelException || ex instanceof ActivityCancelledException || ex instanceof OperationCanceledException || ex instanceof ModelBusConnectorAuthenticationException) {
                return new OperationErrorInfo(simpleMsg, simpleMsg, ex, 1);
            }
            String advancedMsg = UILoggedOperation.getSingleStatusMessage(status);
            return new OperationErrorInfo(simpleMsg, advancedMsg, ex, 1);
        }
        IStatus[] children = status.getChildren();
        String advanceMess = "";
        String simpleMess = "";
        int i = 0;
        while (i < children.length) {
            Throwable exception = children[i].getException();
            if (!(!allowsCancelled && (exception instanceof ModelBusConnectorCancelException || exception instanceof ActivityCancelledException || exception instanceof OperationCanceledException) || exception instanceof HiddenException)) {
                String simpleMsg = UILoggedOperation.getSimpleMessage(children[i]);
                String advancedMsg = UILoggedOperation.getSingleStatusMessage(children[i]);
                advanceMess = String.valueOf(advanceMess) + (advanceMess.length() == 0 ? advancedMsg : "\n\n" + advancedMsg);
                simpleMess = String.valueOf(simpleMess) + (simpleMess.length() == 0 ? simpleMsg : "\n" + simpleMsg);
                if (exception instanceof ModelBusConnectorCancelException || exception instanceof ActivityCancelledException || exception instanceof OperationCanceledException || exception instanceof ModelBusConnectorAuthenticationException) {
                    return new OperationErrorInfo(simpleMess, advanceMess, exception, i + 1);
                }
            }
            ++i;
        }
        return advanceMess.length() == 0 && simpleMess.length() == 0 ? null : new OperationErrorInfo(simpleMess, advanceMess, null, children.length);
    }

    protected static String getSimpleMessage(IStatus status) {
        if (status.getException() instanceof ModelBusConnectorCancelException || status.getException() instanceof ActivityCancelledException || status.getException() instanceof OperationCanceledException) {
            return ModelBusTeamUIPlugin.instance().getResource("UILoggedOperation.Cancelled");
        }
        if (status.getException() instanceof ModelBusConnectorAuthenticationException) {
            return ModelBusTeamUIPlugin.instance().getResource("UILoggedOperation.Authentication");
        }
        return status.getMessage();
    }

    protected static String getSingleStatusMessage(IStatus status) {
        if (status.getException() == null) {
            if (status.getMessage() != null) {
                return status.getMessage();
            }
            return ModelBusTeamUIPlugin.instance().getResource("UILoggedOperation.Unknown");
        }
        if (status.getException() instanceof ModelBusConnectorCancelException || status.getException() instanceof ActivityCancelledException) {
            return ModelBusTeamUIPlugin.instance().getResource("UILoggedOperation.Cancelled");
        }
        if (status.getException().getMessage() == null) {
            return status.getException().getClass().getName();
        }
        return status.getException().getMessage();
    }

    protected static class ErrorReasonVisitor
    implements ReportPartsFactory.IStatusVisitor {
        protected ErrorReasonVisitor() {
        }

        @Override
        public boolean visit(IStatus status) {
            Throwable t = status.getException();
            return t != null && !(t instanceof OperationCanceledException) && !(t instanceof ModelBusConnectorException) && !(t instanceof UnreportableException);
        }
    }

    public static class OperationErrorInfo {
        public String simpleMessage;
        public String advancedMessage;
        public Throwable exception;
        public int numberOfErrors;

        public OperationErrorInfo(String simpleMessage, String advancedMessage, Throwable exception, int numberOfErrors) {
            this.simpleMessage = simpleMessage;
            this.advancedMessage = advancedMessage;
            this.exception = exception;
            this.numberOfErrors = numberOfErrors;
        }
    }
}

