/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.callback;

import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.connector.IModelBusCredentialsPrompt;
import org.modelbus.team.eclipse.core.resource.SSHSettings;
import org.modelbus.team.eclipse.core.resource.SSLSettings;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.CredentialsComposite;
import org.modelbus.team.eclipse.ui.composite.ProxyComposite;
import org.modelbus.team.eclipse.ui.composite.SSHComposite;
import org.modelbus.team.eclipse.ui.composite.SSLComposite;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class PromptCredentialsPanel
extends AbstractDialogPanel {
    public static IModelBusCredentialsPrompt DEFAULT_PROMPT = new DefaultPrompt();
    protected String selectedRealm;
    protected CredentialsComposite credentialsComposite;
    protected String username;
    protected String password;
    protected String host;
    protected boolean savePassword;
    protected SSHComposite compositeSSH;
    protected SSLComposite compositeSSL;
    protected ProxyComposite proxyComposite;
    protected SSHSettings sshSettings;
    protected SSLSettings sslSettings;
    protected String rootLocationName;
    protected int connectionType;

    public PromptCredentialsPanel() {
        this("");
    }

    public PromptCredentialsPanel(String forWhat) {
        this.dialogTitle = ModelBusTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Title");
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("PromptCredentialsPanel.Description");
        this.rootLocationName = ModelBusTeamUIPlugin.instance().getResource("PromptCredentialsPanel.LocationRealm");
        this.defaultMessage = forWhat;
        this.host = ModelBusTeamPlugin.instance().getProxyService().getProxyData(forWhat.split(":")[0].equals("https") ? "HTTPS" : "HTTP").getHost();
        this.connectionType = this.connectionType;
        this.sslSettings = new SSLSettings();
        this.sslSettings.setAuthenticationEnabled(true);
        this.sshSettings = new SSHSettings();
        this.sshSettings.setUseKeyFile(true);
        this.savePassword = false;
        this.username = null;
        this.password = null;
    }

    public String getRealmToSave() {
        return this.selectedRealm == this.rootLocationName ? "<Repository Location>" : this.selectedRealm;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSavePasswordEnabled(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean isSavePasswordEnabled() {
        return this.savePassword;
    }

    public String getSSHPassphrase() {
        return this.sshSettings.getPassPhrase();
    }

    public void setSSHPassphrase(String passphrase) {
        this.sshSettings.setPassPhrase(passphrase);
    }

    public boolean isSSHPassphraseSaved() {
        return this.sshSettings.isPassPhraseSaved();
    }

    public void setSSHPassphraseSaved(boolean passphraseSaved) {
        this.sshSettings.setPassPhraseSaved(passphraseSaved);
    }

    public String getSSHPrivateKeyFile() {
        return this.sshSettings.getPrivateKeyPath();
    }

    public void setSSHPrivateKeyFile(String privateKeyFile) {
        this.sshSettings.setPrivateKeyPath(privateKeyFile);
    }

    public int getSSHPort() {
        return this.sshSettings.getPort();
    }

    public void setSSHPort(int sshPort) {
        this.sshSettings.setPort(sshPort);
    }

    public boolean isSSHPublicKeySelected() {
        return this.sshSettings.isUseKeyFile();
    }

    public void setSSHPublicKeySelected(boolean publicKeySelected) {
        this.sshSettings.setUseKeyFile(publicKeySelected);
    }

    public boolean isSSLAuthenticationEnabled() {
        return this.sslSettings.isAuthenticationEnabled();
    }

    public void setSSLAuthenticationEnabled(boolean sslAuthenticationEnabled) {
        this.sslSettings.setAuthenticationEnabled(sslAuthenticationEnabled);
    }

    public String getSSLCertificatePath() {
        return this.sslSettings.getCertificatePath();
    }

    public void setSSLCertificatePath(String sslCertificatePath) {
        this.sslSettings.setCertificatePath(sslCertificatePath);
    }

    public String getSSLPassphrase() {
        return this.sslSettings.getPassPhrase();
    }

    public void setSSLPassphrase(String sslPassphrase) {
        this.sslSettings.setPassPhrase(sslPassphrase);
    }

    public boolean isSSLPassphraseSaved() {
        return this.sslSettings.isPassPhraseSaved();
    }

    public void setSSLPassphraseSaved(boolean sslPassphraseSaved) {
        this.sslSettings.setPassPhraseSaved(sslPassphraseSaved);
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)tabFolder, 0);
        layout = new GridLayout();
        layout.marginHeight = 3;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createGeneral(composite);
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    protected void createGeneral(Composite parent) {
        this.credentialsComposite = new CredentialsComposite(parent, 0);
        this.credentialsComposite.setUsernameInput(this.username);
        this.credentialsComposite.setPasswordInput(this.password);
        this.credentialsComposite.setPasswordSaved(this.savePassword);
        this.credentialsComposite.initialize();
    }

    @Override
    protected void saveChangesImpl() {
        System.out.println("TODOMWA5");
    }

    @Override
    protected void cancelChangesImpl() {
    }

    protected static class DefaultPrompt
    implements IModelBusCredentialsPrompt {
        protected String realmToSave;
        protected String username;
        protected String password;
        protected boolean saveCredentials;
        protected boolean sslAuthenticationEnabled;
        protected boolean sslSavePassphrase;
        protected String sslClientCertPassword;
        protected String sslClientCertPath;
        protected boolean sshPublicKeySelected;
        protected String sshPrivateKeyPath;
        protected String sshPrivateKeyPassphrase;
        protected boolean sshPrivateKeyPassphraseSaved;
        protected int sshPort;
        protected boolean proxyEnabled;
        protected String proxyHost;
        protected int proxyPort;
        protected boolean proxyAuthenticationEnabled;
        protected String proxyUsername;
        protected String proxyPassword;
        protected boolean proxySavePassword;

        protected DefaultPrompt() {
        }

        public String getRealmToSave() {
            return this.realmToSave;
        }

        public boolean prompt(Object context, String realm) {
            throw new RuntimeException("TODOMWA");
        }

        public boolean promptSSL(Object context, String realm) {
            throw new RuntimeException("TODOMWA");
        }

        public boolean promptSSH(Object context, String realm) {
            throw new RuntimeException("TODOMWA");
        }

        public boolean promptProxy(Object context) {
            throw new RuntimeException("TODOMWA");
        }

        public int askTrustSSLServer(Object context, String info, boolean allowPermanently) {
            int[] retVal = new int[1];
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    throw new RuntimeException("TODOMWA");
                }
            });
            return retVal[0] == 0 ? 1 : (retVal[0] == 2 ? 0 : (retVal[0] == 1 ? (allowPermanently ? 2 : 0) : 0));
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isSaveCredentialsEnabled() {
            return this.saveCredentials;
        }

        public boolean isSSLAuthenticationEnabled() {
            return this.sslAuthenticationEnabled;
        }

        public boolean isSSLSavePassphrase() {
            return this.sslSavePassphrase;
        }

        public String getSSLClientCertPath() {
            return this.sslClientCertPath;
        }

        public String getSSLClientCertPassword() {
            return this.sslClientCertPassword;
        }

        public String getSSHPrivateKeyPath() {
            return this.sshPublicKeySelected ? this.sshPrivateKeyPath : null;
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.sshPublicKeySelected ? this.sshPrivateKeyPassphrase : null;
        }

        public int getSSHPort() {
            return this.sshPort;
        }

        public boolean isSSHPublicKeySelected() {
            return this.sshPublicKeySelected;
        }

        public boolean isSSHPrivateKeyPassphraseSaved() {
            return this.sshPrivateKeyPassphraseSaved;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public String getProxyUserName() {
            return this.proxyUsername;
        }

        public String getProxyPassword() {
            return this.proxyPassword;
        }

        public boolean isProxyEnabled() {
            return this.proxyEnabled;
        }

        public boolean isProxyAuthenticationEnabled() {
            return this.proxyAuthenticationEnabled;
        }

        public boolean isSaveProxyPassword() {
            return this.proxySavePassword;
        }

        protected boolean showPanel(int connectionType, String realm) {
            int[] retVal = new int[1];
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
            return retVal[0] == 0;
        }
    }
}

