/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.common;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.composite.RepositoryResourceSelectionComposite;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;

public abstract class AbstractRepositoryResourceSelectionPanel
extends AbstractDialogPanel {
    protected IRepositoryResource selectedResource;
    protected ModelBusRevision currentRevision;
    protected boolean filterCurrentRevision;
    protected boolean toFilterCurrent;
    protected String historyKey;
    protected RepositoryResourceSelectionComposite selectionComposite;
    protected String selectionTitle;
    protected String selectionDescription;
    protected int defaultTextType;

    public AbstractRepositoryResourceSelectionPanel(IRepositoryResource baseResource, ModelBusRevision currentRevision, String title, String proposal, String historyKey, String selectionTitle, String selectionDescription, int defaultTextType) {
        this.dialogTitle = title;
        this.dialogDescription = proposal;
        this.historyKey = historyKey;
        this.selectedResource = baseResource;
        this.currentRevision = currentRevision;
        this.selectionTitle = selectionTitle;
        this.selectionDescription = selectionDescription;
        this.defaultTextType = defaultTextType;
        this.toFilterCurrent = false;
    }

    public void setFilterCurrent(boolean toFilter) {
        this.toFilterCurrent = toFilter;
    }

    public IRepositoryResource[] getSelection(IResource[] to) {
        IRepositoryResource base = this.getSelectedResource();
        if (to.length == 1) {
            return new IRepositoryResource[]{base};
        }
        IRepositoryResource[] retVal = new IRepositoryResource[to.length];
        String baseUrl = base.getUrl();
        int i = 0;
        while (i < retVal.length) {
            String url = String.valueOf(baseUrl) + "/" + ModelBusRemoteStorage.instance().asRepositoryResource(to[i]).getName();
            retVal[i] = to[i].getType() == 1 ? base.asRepositoryFile(url, false) : base.asRepositoryContainer(url, false);
            ++i;
        }
        return retVal;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridData data = null;
        this.selectionComposite = new RepositoryResourceSelectionComposite(parent, 0, this, this.historyKey, this.selectedResource, false, this.selectionTitle, this.selectionDescription, 0, this.defaultTextType);
        this.selectionComposite.setFilterCurrent(this.toFilterCurrent);
        data = new GridData(768);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setCurrentRevision(this.currentRevision);
    }

    @Override
    protected void saveChangesImpl() {
        this.selectedResource = this.selectionComposite.getSelectedResource();
        this.selectionComposite.saveHistory();
    }

    @Override
    protected void cancelChangesImpl() {
    }
}

