/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.panel.common;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.composite.CommentComposite;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.properties.bugtraq.BugtraqModel;

public class CommentPanel
extends AbstractDialogPanel {
    protected CommentComposite comment;
    protected BugtraqModel bugtraqModel;

    public CommentPanel(String title) {
        this.dialogTitle = title;
        this.dialogDescription = ModelBusTeamUIPlugin.instance().getResource("CommentPanel.Description");
        this.defaultMessage = ModelBusTeamUIPlugin.instance().getResource("CommentPanel.Message");
    }

    public CommentPanel(String title, BugtraqModel bugtraqModel) {
        this(title);
        this.bugtraqModel = bugtraqModel;
    }

    public String getMessage() {
        return this.appendBugtraqMessage(this.comment.getMessage());
    }

    @Override
    public void createControlsImpl(Composite parent) {
        this.comment = new CommentComposite(parent, this);
        GridData data = new GridData(1808);
        this.comment.setLayoutData(data);
    }

    @Override
    protected Point getPrefferedSizeImpl() {
        return new Point(510, -1);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
    }

    @Override
    protected void saveChangesImpl() {
        this.comment.saveChanges();
    }

    @Override
    protected void cancelChangesImpl() {
        this.comment.cancelChanges();
    }

    protected String appendBugtraqMessage(String message) {
        String addString;
        String bugtraqMessage;
        if (this.bugtraqModel != null && (bugtraqMessage = this.bugtraqModel.getMessage()) != null && (addString = this.comment.getBugID()) != null && addString.trim().length() > 0) {
            bugtraqMessage = bugtraqMessage.replaceFirst("%BUGID%", addString);
            message = this.bugtraqModel.isAppend() ? String.valueOf(message) + "\n" + bugtraqMessage : String.valueOf(bugtraqMessage) + "\n" + message;
        }
        return message;
    }
}

